/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import io.micrometer.observation.Observation;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.cassandra.observability.CassandraObservation;
import org.springframework.data.cassandra.observability.CassandraObservationContext;
import org.springframework.data.cassandra.observability.CassandraObservationSupplier;
import org.springframework.lang.Nullable;

public enum ObservationRequestTracker implements RequestTracker
{
    INSTANCE;

    private static final Log log;

    public void onSuccess(Request request, long latencyNanos, DriverExecutionProfile executionProfile, Node node, String requestLogPrefix) {
        if (request instanceof CassandraObservationSupplier) {
            CassandraObservationSupplier supplier = (CassandraObservationSupplier)request;
            Observation observation = supplier.getObservation();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing observation [" + observation + "]"));
            }
            observation.stop();
        }
    }

    public void onError(Request request, Throwable error, long latencyNanos, DriverExecutionProfile executionProfile, @Nullable Node node, String requestLogPrefix) {
        if (request instanceof CassandraObservationSupplier) {
            CassandraObservationSupplier supplier = (CassandraObservationSupplier)request;
            Observation observation = supplier.getObservation();
            observation.error(error);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing observation [" + observation + "]"));
            }
            observation.stop();
        }
    }

    public void onNodeError(Request request, Throwable error, long latencyNanos, DriverExecutionProfile executionProfile, Node node, String requestLogPrefix) {
        if (request instanceof CassandraObservationSupplier) {
            CassandraObservationSupplier supplier = (CassandraObservationSupplier)request;
            Observation observation = supplier.getObservation();
            ObservationRequestTracker.ifContextPresent(observation, CassandraObservationContext.class, context -> context.setNode(node));
            observation.highCardinalityKeyValue(String.format(CassandraObservation.HighCardinalityKeyNames.NODE_ERROR_TAG.asString(), node.getEndPoint()), error.toString());
            observation.event(Observation.Event.of((String)CassandraObservation.Events.NODE_ERROR.getValue()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Marking node error for [" + observation + "]"));
            }
        }
    }

    public void onNodeSuccess(Request request, long latencyNanos, DriverExecutionProfile executionProfile, Node node, String requestLogPrefix) {
        if (request instanceof CassandraObservationSupplier) {
            CassandraObservationSupplier supplier = (CassandraObservationSupplier)request;
            Observation observation = supplier.getObservation();
            ObservationRequestTracker.ifContextPresent(observation, CassandraObservationContext.class, context -> context.setNode(node));
            observation.event(Observation.Event.of((String)CassandraObservation.Events.NODE_SUCCESS.getValue()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Marking node success for [" + observation + "]"));
            }
        }
    }

    public void close() throws Exception {
    }

    static <T extends Observation.Context> void ifContextPresent(Observation observation, Class<T> contextType, Consumer<T> contextConsumer) {
        if (observation.isNoop()) {
            return;
        }
        Observation.Context context = observation.getContext();
        if (contextType.isInstance(context)) {
            contextConsumer.accept((Observation.Context)contextType.cast(context));
        }
    }

    static {
        log = LogFactory.getLog(ObservationRequestTracker.class);
    }
}

