/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.data.cassandra.observability.ObservableCqlSessionFactory;
import org.springframework.data.cassandra.observability.ObservationRequestTracker;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ObservableCqlSessionFactoryBean
extends AbstractFactoryBean<CqlSession> {
    private final CqlSessionBuilder cqlSessionBuilder;
    private final ObservationRegistry observationRegistry;
    @Nullable
    private String remoteServiceName;

    public ObservableCqlSessionFactoryBean(CqlSessionBuilder cqlSessionBuilder, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)cqlSessionBuilder, (String)"CqlSessionBuilder must not be null");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        this.cqlSessionBuilder = cqlSessionBuilder;
        this.observationRegistry = observationRegistry;
    }

    protected CqlSession createInstance() {
        this.cqlSessionBuilder.addRequestTracker((RequestTracker)ObservationRequestTracker.INSTANCE);
        if (ObjectUtils.isEmpty((Object)this.getRemoteServiceName())) {
            return ObservableCqlSessionFactory.wrap((CqlSession)this.cqlSessionBuilder.build(), this.observationRegistry);
        }
        return ObservableCqlSessionFactory.wrap((CqlSession)this.cqlSessionBuilder.build(), this.getRemoteServiceName(), this.observationRegistry);
    }

    protected void destroyInstance(@Nullable CqlSession instance) {
        if (instance != null) {
            instance.close();
        }
    }

    public Class<?> getObjectType() {
        return CqlSession.class;
    }

    @Nullable
    public String getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public void setRemoteServiceName(@Nullable String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
    }
}

