/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import java.util.Map;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class ColumnMapRowMapper
implements RowMapper<Map<String, Object>> {
    @Override
    public Map<String, Object> mapRow(Row rs, int rowNum) {
        ColumnDefinitions columnDefinitions = rs.getColumnDefinitions();
        int columnCount = columnDefinitions.size();
        Map<String, Object> mapOfColValues = this.createColumnMap(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            ColumnDefinition columnDefinition = columnDefinitions.get(i);
            String key = this.getColumnKey(columnDefinition.getName().toString());
            Object obj = this.getColumnValue(rs, i);
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    protected Map<String, Object> createColumnMap(int columnCount) {
        return new LinkedCaseInsensitiveMap(columnCount);
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    @Nullable
    protected Object getColumnValue(Row row, int index) {
        return row.getObject(index);
    }
}

