/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.cassandra.core.cql.keyspace.AddColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.ColumnChangeSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.RenameColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.TableOptionsSpecification;

public class AlterTableSpecification
extends TableOptionsSpecification<AlterTableSpecification> {
    private List<ColumnChangeSpecification> changes = new ArrayList<ColumnChangeSpecification>();

    private AlterTableSpecification(CqlIdentifier name) {
        super(name);
    }

    public static AlterTableSpecification alterTable(String tableName) {
        return AlterTableSpecification.alterTable(CqlIdentifier.fromCql((String)tableName));
    }

    public static AlterTableSpecification alterTable(CqlIdentifier tableName) {
        return new AlterTableSpecification(tableName);
    }

    public AlterTableSpecification add(String column, DataType type) {
        return this.add(CqlIdentifier.fromCql((String)column), type);
    }

    public AlterTableSpecification add(CqlIdentifier column, DataType type) {
        return this.add(AddColumnSpecification.addColumn(column, type));
    }

    public AlterTableSpecification drop(String column) {
        return this.drop(CqlIdentifier.fromCql((String)column));
    }

    public AlterTableSpecification drop(CqlIdentifier column) {
        return this.add(DropColumnSpecification.dropColumn(column));
    }

    public AlterTableSpecification rename(String from, String to) {
        return this.rename(CqlIdentifier.fromCql((String)from), CqlIdentifier.fromCql((String)to));
    }

    public AlterTableSpecification rename(CqlIdentifier from, CqlIdentifier to) {
        return this.add(new RenameColumnSpecification(from, to));
    }

    public AlterTableSpecification alter(String column, DataType type) {
        return this.alter(CqlIdentifier.fromCql((String)column), type);
    }

    public AlterTableSpecification alter(CqlIdentifier column, DataType type) {
        return this.add(AlterColumnSpecification.alterColumn(column, type));
    }

    private AlterTableSpecification add(ColumnChangeSpecification specification) {
        this.changes.add(specification);
        return this;
    }

    public List<ColumnChangeSpecification> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }
}

