/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import org.springframework.util.Assert;

class UserTypeUtil {
    UserTypeUtil() {
    }

    static DataType potentiallyFreeze(DataType dataType) {
        ListType collectionType;
        DataType elementType;
        Assert.notNull((Object)dataType, (String)"DataType must not be null");
        if (dataType instanceof ListType && (UserTypeUtil.isCollectionType(elementType = (collectionType = (ListType)dataType).getElementType()) || UserTypeUtil.isNonFrozenUdt(elementType))) {
            return DataTypes.listOf((DataType)UserTypeUtil.potentiallyFreeze(elementType), (boolean)collectionType.isFrozen());
        }
        if (dataType instanceof SetType && (UserTypeUtil.isCollectionType(elementType = (collectionType = (SetType)dataType).getElementType()) || UserTypeUtil.isNonFrozenUdt(elementType))) {
            return DataTypes.setOf((DataType)UserTypeUtil.potentiallyFreeze(elementType), (boolean)collectionType.isFrozen());
        }
        if (dataType instanceof MapType) {
            collectionType = (MapType)dataType;
            DataType keyType = collectionType.getKeyType();
            DataType valueType = collectionType.getValueType();
            if (UserTypeUtil.isCollectionType(keyType) || UserTypeUtil.isCollectionType(valueType) || UserTypeUtil.isNonFrozenUdt(keyType) || UserTypeUtil.isNonFrozenUdt(valueType)) {
                return DataTypes.mapOf((DataType)UserTypeUtil.potentiallyFreeze(keyType), (DataType)UserTypeUtil.potentiallyFreeze(valueType), (boolean)collectionType.isFrozen());
            }
        }
        if (UserTypeUtil.isNonFrozenUdt(dataType)) {
            return ((UserDefinedType)dataType).copy(true);
        }
        return dataType;
    }

    private static boolean isCollectionType(DataType typeArgument) {
        return typeArgument instanceof ListType || typeArgument instanceof SetType || typeArgument instanceof MapType;
    }

    private static boolean isNonFrozenUdt(DataType dataType) {
        return dataType instanceof UserDefinedType && !((UserDefinedType)dataType).isFrozen();
    }
}

