/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

class SchemaUtils {
    SchemaUtils() {
    }

    static void withSuspendedSchemaRefresh(Session session, Runnable schemaAction) {
        CompletableFutures.getUninterruptibly(SchemaUtils.withSuspendedAsyncSchemaRefresh(session, schemaAction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompletionStage<?> withSuspendedAsyncSchemaRefresh(Session session, Runnable schemaAction) {
        CompletionStage<Object> schemaRefresh;
        boolean schemaEnabledPreviously = session.isSchemaMetadataEnabled();
        if (schemaEnabledPreviously) {
            session.setSchemaMetadataEnabled(Boolean.valueOf(false));
        }
        try {
            schemaAction.run();
        }
        finally {
            schemaRefresh = schemaEnabledPreviously ? session.setSchemaMetadataEnabled(null) : CompletableFuture.completedFuture(null);
        }
        return schemaRefresh;
    }

    static void withSchemaRefresh(Session session, Runnable schemaAction) {
        CompletableFutures.getUninterruptibly(SchemaUtils.withAsyncSchemaRefresh(session, schemaAction));
    }

    static CompletionStage<?> withAsyncSchemaRefresh(Session session, Runnable schemaAction) {
        schemaAction.run();
        if (session.isSchemaMetadataEnabled()) {
            return session.refreshSchemaAsync();
        }
        return CompletableFuture.completedFuture(null);
    }
}

