/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.support;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.springframework.data.cassandra.core.cql.support.PreparedStatementCache;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Deprecated
public class MapPreparedStatementCache
implements PreparedStatementCache {
    private final Map<CacheKey, PreparedStatement> cache;

    private MapPreparedStatementCache(Map<CacheKey, PreparedStatement> cache) {
        Assert.notNull(cache, (String)"Cache must not be null");
        this.cache = cache;
    }

    public static MapPreparedStatementCache create() {
        return MapPreparedStatementCache.of(new ConcurrentHashMap<CacheKey, PreparedStatement>());
    }

    public static MapPreparedStatementCache of(Map<CacheKey, PreparedStatement> cache) {
        return new MapPreparedStatementCache(cache);
    }

    protected Map<CacheKey, PreparedStatement> getCache() {
        return this.cache;
    }

    @Override
    public PreparedStatement getPreparedStatement(CqlSession session, SimpleStatement statement, Supplier<PreparedStatement> preparer) {
        CacheKey cacheKey = new CacheKey(session, statement.getQuery());
        return this.getCache().computeIfAbsent(cacheKey, key -> (PreparedStatement)preparer.get());
    }

    protected static class CacheKey {
        final String sessionName;
        final String keyspace;
        final String cql;

        CacheKey(CqlSession session, String cql) {
            this.sessionName = session.getName();
            this.keyspace = session.getKeyspace().orElse(CqlIdentifier.fromCql((String)"system")).asInternal();
            this.cql = cql;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.sessionName, (Object)cacheKey.sessionName)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.keyspace, (Object)cacheKey.keyspace)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.cql, (Object)cacheKey.cql);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.sessionName);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.keyspace);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.cql);
            return result;
        }
    }
}

