/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.core.mapping.Table;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class CassandraEntityClassScanner {
    private Set<String> entityBasePackages = new HashSet<String>();
    private Set<Class<?>> entityBasePackageClasses = new HashSet();
    @Nullable
    private ClassLoader beanClassLoader;

    public static Set<Class<?>> scan(String ... entityBasePackages) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackages).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Class<?> ... entityBasePackageClasses) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackageClasses).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Collection<String> entityBasePackages) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackages).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Collection<String> entityBasePackages, Collection<Class<?>> entityBasePackageClasses) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackages, entityBasePackageClasses).scanForEntityClasses();
    }

    public CassandraEntityClassScanner() {
    }

    public CassandraEntityClassScanner(Class<?> ... entityBasePackageClasses) {
        this.setEntityBasePackageClasses(Arrays.asList(entityBasePackageClasses));
    }

    public CassandraEntityClassScanner(String ... entityBasePackages) {
        this(Arrays.asList(entityBasePackages));
    }

    public CassandraEntityClassScanner(Collection<String> entityBasePackages) {
        this.setEntityBasePackages(entityBasePackages);
    }

    public CassandraEntityClassScanner(Collection<String> entityBasePackages, Collection<Class<?>> entityBasePackageClasses) {
        this.setEntityBasePackages(entityBasePackages);
        this.setEntityBasePackageClasses(entityBasePackageClasses);
    }

    public Set<String> getEntityBasePackages() {
        return Collections.unmodifiableSet(this.entityBasePackages);
    }

    public void setEntityBasePackages(Collection<String> entityBasePackages) {
        this.entityBasePackages = new HashSet<String>(entityBasePackages);
    }

    public Set<Class<?>> getEntityBasePackageClasses() {
        return Collections.unmodifiableSet(this.entityBasePackageClasses);
    }

    public void setEntityBasePackageClasses(Collection<Class<?>> entityBasePackageClasses) {
        this.entityBasePackageClasses = new HashSet(entityBasePackageClasses);
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public Set<Class<?>> scanForEntityClasses() throws ClassNotFoundException {
        HashSet classes = new HashSet();
        for (String string : this.getEntityBasePackages()) {
            classes.addAll(this.scanBasePackageForEntities(string));
        }
        for (Class clazz : this.getEntityBasePackageClasses()) {
            classes.addAll(this.scanBasePackageForEntities(clazz.getPackage().getName()));
        }
        return classes;
    }

    protected Set<Class<?>> scanBasePackageForEntities(String basePackage) throws ClassNotFoundException {
        HashSet classes = new HashSet();
        if (ObjectUtils.isEmpty((Object)basePackage)) {
            return classes;
        }
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        for (Class<? extends Annotation> annotation : this.getEntityAnnotations()) {
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotation));
        }
        for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
            if (candidate.getBeanClassName() == null) continue;
            classes.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)this.beanClassLoader));
        }
        return classes;
    }

    protected Class<? extends Annotation>[] getEntityAnnotations() {
        return new Class[]{Table.class, PrimaryKeyClass.class};
    }
}

