/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.data.cassandra.core.mapping.BasicMapId;
import org.springframework.data.cassandra.core.mapping.IdInterfaceValidator;
import org.springframework.data.cassandra.core.mapping.MapId;
import org.springframework.data.cassandra.core.mapping.MapIdProxyDelegate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MapIdFactory {
    public static <T> T id(Class<T> idInterface) {
        Assert.notNull(idInterface, (String)"Interface class must not be null");
        return MapIdFactory.id(idInterface, idInterface.getClassLoader());
    }

    public static <T> T id(Class<T> idInterface, ClassLoader loader) {
        if (MapId.class.equals(idInterface)) {
            return (T)new BasicMapId();
        }
        IdInterfaceValidator.validate(idInterface);
        Class[] idInterfaces = ClassUtils.getAllInterfacesForClass(idInterface);
        HashSet<Class> proxyInterfaces = new HashSet<Class>(idInterfaces.length + 1, 1.0f);
        proxyInterfaces.add(MapId.class);
        proxyInterfaces.addAll(Arrays.asList(idInterfaces));
        return (T)Proxy.newProxyInstance(loader, proxyInterfaces.toArray(new Class[proxyInterfaces.size()]), (InvocationHandler)new MapIdProxyDelegate(idInterface));
    }
}

