/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BiFunction;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentPropertyComparator;
import org.springframework.data.cassandra.core.mapping.CompositeCassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.CqlIdentifierGenerator;
import org.springframework.data.cassandra.core.mapping.NamingStrategy;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.core.mapping.Table;
import org.springframework.data.cassandra.core.mapping.UnsupportedCassandraOperationException;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BasicCassandraPersistentEntity<T>
extends BasicPersistentEntity<T, CassandraPersistentProperty>
implements CassandraPersistentEntity<T>,
ApplicationContextAware {
    private static final CassandraPersistentEntityMetadataVerifier DEFAULT_VERIFIER = new CompositeCassandraPersistentEntityMetadataVerifier();
    private final CqlIdentifierGenerator namingAccessor = new CqlIdentifierGenerator();
    private Boolean forceQuote;
    private CassandraPersistentEntityMetadataVerifier verifier = DEFAULT_VERIFIER;
    private CqlIdentifier tableName;
    @Nullable
    private StandardEvaluationContext spelContext;

    public BasicCassandraPersistentEntity(TypeInformation<T> typeInformation) {
        this(typeInformation, DEFAULT_VERIFIER);
    }

    public BasicCassandraPersistentEntity(TypeInformation<T> typeInformation, CassandraPersistentEntityMetadataVerifier verifier) {
        super(typeInformation, (Comparator)CassandraPersistentPropertyComparator.INSTANCE);
        this.setVerifier(verifier);
    }

    protected BasicCassandraPersistentEntity(TypeInformation<T> typeInformation, CassandraPersistentEntityMetadataVerifier verifier, Comparator<CassandraPersistentProperty> comparator) {
        super(typeInformation, comparator);
        this.setVerifier(verifier);
    }

    protected CqlIdentifier determineTableName() {
        return this.determineTableName(NamingStrategy::getTableName, this.findAnnotation(Table.class));
    }

    CqlIdentifier determineTableName(BiFunction<NamingStrategy, CassandraPersistentEntity<?>, String> defaultNameGenerator, @Nullable Annotation annotation) {
        if (annotation != null) {
            return this.namingAccessor.generate((String)AnnotationUtils.getValue((Annotation)annotation), (Boolean)AnnotationUtils.getValue((Annotation)annotation, (String)"forceQuote"), defaultNameGenerator, this, (EvaluationContext)this.spelContext);
        }
        return this.namingAccessor.generate(null, this.forceQuote != null ? this.forceQuote : false, defaultNameGenerator, this, (EvaluationContext)this.spelContext);
    }

    public void addAssociation(Association<CassandraPersistentProperty> association) {
        throw new UnsupportedCassandraOperationException("Cassandra does not support associations");
    }

    public void doWithAssociations(AssociationHandler<CassandraPersistentProperty> handler) {
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return this.isAnnotationPresent(PrimaryKeyClass.class);
    }

    public void verify() throws MappingException {
        super.verify();
        this.verifier.verify(this);
        if (this.tableName == null) {
            this.setTableName(this.determineTableName());
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null");
        this.spelContext = new StandardEvaluationContext();
        this.spelContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.spelContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)context));
        this.spelContext.setRootObject((Object)context);
    }

    @Override
    public void setForceQuote(boolean forceQuote) {
        boolean changed = !Boolean.valueOf(forceQuote).equals(this.forceQuote);
        this.forceQuote = forceQuote;
        if (changed) {
            this.setTableName(CqlIdentifierGenerator.createIdentifier(this.getTableName().asInternal(), forceQuote));
        }
    }

    @Override
    public void setTableName(CqlIdentifier tableName) {
        Assert.notNull((Object)tableName, (String)"CqlIdentifier must not be null");
        this.tableName = tableName;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingAccessor.setNamingStrategy(namingStrategy);
    }

    @Override
    public CqlIdentifier getTableName() {
        return Optional.ofNullable(this.tableName).orElseGet(this::determineTableName);
    }

    public void setVerifier(CassandraPersistentEntityMetadataVerifier verifier) {
        this.verifier = verifier;
    }

    public CassandraPersistentEntityMetadataVerifier getVerifier() {
        return this.verifier;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public boolean isUserDefinedType() {
        return false;
    }
}

