/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.Criteria;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.repository.CassandraRepository;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.cassandra.repository.support.FindByIdQuery;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.util.Assert;

public class SimpleCassandraRepository<T, ID>
implements CassandraRepository<T, ID> {
    private static final InsertOptions INSERT_NULLS = InsertOptions.builder().withInsertNulls().build();
    private final AbstractMappingContext<BasicCassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final CassandraEntityInformation<T, ID> entityInformation;
    private final CassandraOperations operations;

    public SimpleCassandraRepository(CassandraEntityInformation<T, ID> metadata, CassandraOperations operations) {
        Assert.notNull(metadata, (String)"CassandraEntityInformation must not be null");
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        this.entityInformation = metadata;
        this.operations = operations;
        this.mappingContext = operations.getConverter().getMappingContext();
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        if (persistentEntity != null && persistentEntity.hasVersionProperty() && !this.entityInformation.isNew(entity)) {
            return this.operations.update(entity);
        }
        return this.operations.insert(entity, INSERT_NULLS).getEntity();
    }

    @Override
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        return Optional.ofNullable(this.doFindOne(id));
    }

    private T doFindOne(ID id) {
        return this.operations.selectOneById(id, this.entityInformation.getJavaType());
    }

    public boolean existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        return this.operations.exists(id, this.entityInformation.getJavaType());
    }

    @Override
    public List<T> findAll() {
        return this.operations.select(Query.empty(), this.entityInformation.getJavaType());
    }

    @Override
    public List<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of id's must not be null");
        if (!ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        return this.operations.select(this.createIdsInQuery(ids), this.entityInformation.getJavaType());
    }

    public long count() {
        return this.operations.count(this.entityInformation.getJavaType());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        this.operations.deleteById(id, this.entityInformation.getJavaType());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null");
        this.deleteById(this.entityInformation.getRequiredId(entity));
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null");
        if (!ids.iterator().hasNext()) {
            return;
        }
        this.operations.delete(this.createIdsInQuery(ids), this.entityInformation.getJavaType());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        entities.forEach(this.operations::delete);
    }

    public void deleteAll() {
        this.operations.truncate(this.entityInformation.getJavaType());
    }

    @Override
    public Slice<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        return this.operations.slice(Query.empty().pageRequest(pageable), this.entityInformation.getJavaType());
    }

    @Override
    public <S extends T> S insert(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return this.operations.insert(entity);
    }

    @Override
    public <S extends T> List<S> insert(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(this.operations.insert(entity));
        }
        return result;
    }

    private Query createIdsInQuery(Iterable<? extends ID> ids) {
        FindByIdQuery mapIdQuery = FindByIdQuery.forIds(ids);
        List<Object> idCollection = mapIdQuery.getIdCollection();
        String idField = mapIdQuery.getIdProperty();
        if (idField == null) {
            idField = this.entityInformation.getIdAttribute();
        }
        return Query.query(Criteria.where(idField).in(idCollection));
    }
}

