/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.cassandra.core.cql.PrimaryKeyType;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.Column;
import org.springframework.data.cassandra.core.mapping.IdentifierFactory;
import org.springframework.data.cassandra.core.mapping.NamingStrategy;
import org.springframework.data.cassandra.core.mapping.PrimaryKey;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.util.SpelUtils;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BasicCassandraPersistentProperty
extends AnnotationBasedPersistentProperty<CassandraPersistentProperty>
implements CassandraPersistentProperty,
ApplicationContextAware {
    private Boolean forceQuote;
    @Nullable
    private CqlIdentifier columnName;
    private NamingStrategy namingStrategy = NamingStrategy.INSTANCE;
    @Nullable
    private StandardEvaluationContext spelContext;

    public BasicCassandraPersistentProperty(Property property, CassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
    }

    public void setApplicationContext(ApplicationContext context) {
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null");
        this.spelContext = new StandardEvaluationContext();
        this.spelContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.spelContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)context));
        this.spelContext.setRootObject((Object)context);
    }

    public CassandraPersistentEntity<?> getOwner() {
        return (CassandraPersistentEntity)super.getOwner();
    }

    @Override
    public CqlIdentifier getColumnName() {
        if (this.columnName == null) {
            this.columnName = this.determineColumnName();
        }
        if (this.columnName == null) {
            throw new IllegalStateException(String.format("Cannot determine column name for %s", this));
        }
        return this.columnName;
    }

    @Override
    @Nullable
    public Integer getOrdinal() {
        return null;
    }

    @Override
    @Nullable
    public Ordering getPrimaryKeyOrdering() {
        PrimaryKeyColumn annotation = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return annotation != null ? annotation.ordering() : null;
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.getType(), PrimaryKeyClass.class) != null;
    }

    @Override
    public boolean isClusterKeyColumn() {
        PrimaryKeyColumn annotation = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return annotation != null && PrimaryKeyType.CLUSTERED.equals((Object)annotation.type());
    }

    @Override
    public boolean isPartitionKeyColumn() {
        PrimaryKeyColumn annotation = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return annotation != null && PrimaryKeyType.PARTITIONED.equals((Object)annotation.type());
    }

    @Override
    public boolean isPrimaryKeyColumn() {
        return this.isAnnotationPresent(PrimaryKeyColumn.class);
    }

    @Override
    public boolean isStaticColumn() {
        Column annotation = (Column)this.findAnnotation(Column.class);
        return annotation != null && annotation.isStatic();
    }

    @Nullable
    private CqlIdentifier determineColumnName() {
        if (this.isCompositePrimaryKey()) {
            return null;
        }
        Supplier<String> defaultName = () -> this.getNamingStrategy().getColumnName(this);
        String overriddenName = null;
        boolean forceQuote = false;
        if (this.isIdProperty()) {
            PrimaryKey primaryKey = (PrimaryKey)this.findAnnotation(PrimaryKey.class);
            if (primaryKey != null) {
                overriddenName = primaryKey.value();
                forceQuote = primaryKey.forceQuote();
            }
        } else if (this.isPrimaryKeyColumn()) {
            PrimaryKeyColumn primaryKeyColumn = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
            if (primaryKeyColumn != null) {
                overriddenName = primaryKeyColumn.value();
                forceQuote = primaryKeyColumn.forceQuote();
            }
        } else {
            Column column = (Column)this.findAnnotation(Column.class);
            if (column != null) {
                overriddenName = column.value();
                forceQuote = column.forceQuote();
            }
        }
        return this.createColumnName(defaultName, overriddenName, forceQuote);
    }

    @Nullable
    private CqlIdentifier createColumnName(Supplier<String> defaultName, @Nullable String overriddenName, boolean forceQuote) {
        String name = StringUtils.hasText((String)overriddenName) ? (this.spelContext != null ? SpelUtils.evaluate(overriddenName, (EvaluationContext)this.spelContext) : overriddenName) : defaultName.get();
        return name != null ? IdentifierFactory.create(name, forceQuote) : null;
    }

    @Override
    public void setColumnName(CqlIdentifier columnName) {
        Assert.notNull((Object)columnName, (String)"ColumnName must not be null");
        this.columnName = columnName;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        Assert.notNull((Object)namingStrategy, (String)"NamingStrategy must not be null");
        this.namingStrategy = namingStrategy;
    }

    NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    @Override
    public void setForceQuote(boolean forceQuote) {
        boolean changed = !Boolean.valueOf(forceQuote).equals(this.forceQuote);
        this.forceQuote = forceQuote;
        if (changed) {
            this.setColumnName(IdentifierFactory.create(this.getRequiredColumnName().asInternal(), forceQuote));
        }
    }

    public Association<CassandraPersistentProperty> getAssociation() {
        return null;
    }

    protected Association<CassandraPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, (PersistentProperty)this);
    }

    @Override
    public boolean isMapLike() {
        return ClassUtils.isAssignable(Map.class, (Class)this.getType());
    }

    @Override
    public AnnotatedType findAnnotatedType(Class<? extends Annotation> annotationType) {
        return Optionals.toStream((Optional[])new Optional[]{Optional.ofNullable(this.getField()).map(Field::getAnnotatedType), Optional.ofNullable(this.getGetter()).map(Method::getAnnotatedReturnType), Optional.ofNullable(this.getSetter()).map(it -> it.getParameters()[0].getAnnotatedType())}).filter(it -> BasicCassandraPersistentProperty.hasAnnotation(it, annotationType, this.getTypeInformation())).findFirst().orElse(null);
    }

    private static boolean hasAnnotation(AnnotatedType type, Class<? extends Annotation> annotationType, TypeInformation<?> typeInformation) {
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)type, annotationType)) {
            return true;
        }
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
            AnnotatedType[] arguments = parameterizedType.getAnnotatedActualTypeArguments();
            if (typeInformation.isCollectionLike() && arguments.length == 1) {
                return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)arguments[0], annotationType);
            }
            if (typeInformation.isMap() && arguments.length == 2) {
                return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)arguments[0], annotationType) || AnnotatedElementUtils.hasAnnotation((AnnotatedElement)arguments[1], annotationType);
            }
        }
        return false;
    }
}

