/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.ExecutableDeleteOperation;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ExecutableDeleteOperationSupport
implements ExecutableDeleteOperation {
    private final CassandraTemplate template;

    public ExecutableDeleteOperationSupport(CassandraTemplate template) {
        this.template = template;
    }

    @Override
    public ExecutableDeleteOperation.ExecutableDelete delete(Class<?> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableDeleteSupport(this.template, domainType, Query.empty(), null);
    }

    static class ExecutableDeleteSupport
    implements ExecutableDeleteOperation.ExecutableDelete,
    ExecutableDeleteOperation.TerminatingDelete {
        private final CassandraTemplate template;
        private final Class<?> domainType;
        private final Query query;
        @Nullable
        private final CqlIdentifier tableName;

        public ExecutableDeleteSupport(CassandraTemplate template, Class<?> domainType, Query query2, CqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.query = query2;
            this.tableName = tableName;
        }

        @Override
        public ExecutableDeleteOperation.DeleteWithQuery inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ExecutableDeleteSupport(this.template, this.domainType, this.query, tableName);
        }

        @Override
        public ExecutableDeleteOperation.TerminatingDelete matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ExecutableDeleteSupport(this.template, this.domainType, query2, this.tableName);
        }

        @Override
        public WriteResult all() {
            return this.template.doDelete(this.query, this.domainType, this.getTableName());
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }
}

