/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.Optional;
import org.springframework.util.Assert;

public abstract class ColumnName {
    public static ColumnName from(CqlIdentifier cqlIdentifier) {
        Assert.notNull((Object)cqlIdentifier, (String)"Column name must not be null");
        return new CqlIdentifierColumnName(cqlIdentifier);
    }

    public static ColumnName from(String columnName) {
        Assert.hasText((String)columnName, (String)"Column name must not be null or empty");
        return new StringColumnName(columnName);
    }

    public abstract Optional<String> getColumnName();

    public abstract Optional<CqlIdentifier> getCqlIdentifier();

    public abstract String toCql();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColumnName)) {
            return false;
        }
        ColumnName that = (ColumnName)obj;
        return this.toCql().equals(that.toCql());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + this.toCql().hashCode();
        return hashValue;
    }

    static class CqlIdentifierColumnName
    extends ColumnName {
        private final CqlIdentifier cqlIdentifier;

        CqlIdentifierColumnName(CqlIdentifier cqlIdentifier) {
            this.cqlIdentifier = cqlIdentifier;
        }

        @Override
        public Optional<String> getColumnName() {
            return Optional.empty();
        }

        @Override
        public Optional<CqlIdentifier> getCqlIdentifier() {
            return Optional.of(this.cqlIdentifier);
        }

        @Override
        public String toCql() {
            return this.cqlIdentifier.toString();
        }

        public String toString() {
            return this.cqlIdentifier.toString();
        }
    }

    static class StringColumnName
    extends ColumnName {
        private final String columnName;

        StringColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public Optional<String> getColumnName() {
            return Optional.of(this.columnName);
        }

        @Override
        public Optional<CqlIdentifier> getCqlIdentifier() {
            return Optional.empty();
        }

        @Override
        public String toCql() {
            return this.columnName;
        }

        public String toString() {
            return this.columnName;
        }
    }
}

