/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.ThreeTenBackPortConverters;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.ClassUtils;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

@Deprecated
public abstract class CassandraThreeTenBackPortConverters {
    private static final boolean THREE_TEN_BACK_PORT_IS_PRESENT = ClassUtils.isPresent((String)"org.threeten.bp.LocalDateTime", (ClassLoader)ThreeTenBackPortConverters.class.getClassLoader());

    private CassandraThreeTenBackPortConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!THREE_TEN_BACK_PORT_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(MillisOfDayToLocalTimeConverter.INSTANCE);
        converters.add(LocalTimeToMillisOfDayConverter.INSTANCE);
        converters.add(FromBpLocalTimeConverter.INSTANCE);
        converters.add(ToBpLocalTimeConverter.INSTANCE);
        converters.add(FromBpLocalDateConverter.INSTANCE);
        converters.add(ToBpLocalDateConverter.INSTANCE);
        converters.add(FromBpLocalDateTimeConverter.INSTANCE);
        converters.add(ToBpLocalDateTimeConverter.INSTANCE);
        converters.add(LocalDateTimeToInstantConverter.INSTANCE);
        converters.add(BpInstantToInstantConverter.INSTANCE);
        converters.add(InstantToBpInstantConverter.INSTANCE);
        converters.add(ZoneIdToStringConverter.INSTANCE);
        converters.add(StringToZoneIdConverter.INSTANCE);
        return converters;
    }

    @Deprecated
    static enum StringToZoneIdConverter implements Converter<String, ZoneId>
    {
        INSTANCE;


        public ZoneId convert(String source) {
            return ZoneId.of((String)source);
        }
    }

    @Deprecated
    static enum ZoneIdToStringConverter implements Converter<ZoneId, String>
    {
        INSTANCE;


        public String convert(ZoneId source) {
            return source.toString();
        }
    }

    @Deprecated
    static enum InstantToBpInstantConverter implements Converter<Instant, org.threeten.bp.Instant>
    {
        INSTANCE;


        public org.threeten.bp.Instant convert(Instant source) {
            return org.threeten.bp.Instant.ofEpochMilli((long)source.toEpochMilli());
        }
    }

    @Deprecated
    static enum BpInstantToInstantConverter implements Converter<org.threeten.bp.Instant, Instant>
    {
        INSTANCE;


        public Instant convert(org.threeten.bp.Instant source) {
            return Instant.ofEpochMilli(source.toEpochMilli());
        }
    }

    @Deprecated
    static enum LocalDateTimeToInstantConverter implements Converter<LocalDateTime, Instant>
    {
        INSTANCE;


        public Instant convert(LocalDateTime source) {
            return Instant.ofEpochMilli(source.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        }
    }

    @Deprecated
    public static enum ToBpLocalDateTimeConverter implements Converter<java.time.LocalDateTime, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(java.time.LocalDateTime date) {
            return LocalDateTime.of((int)date.getYear(), (int)date.getMonthValue(), (int)date.getDayOfMonth(), (int)date.getHour(), (int)date.getMinute(), (int)date.getSecond(), (int)date.getNano());
        }
    }

    @ReadingConverter
    @Deprecated
    public static enum FromBpLocalDateTimeConverter implements Converter<LocalDateTime, java.time.LocalDateTime>
    {
        INSTANCE;


        public java.time.LocalDateTime convert(LocalDateTime date) {
            return java.time.LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), date.getSecond(), date.getNano());
        }
    }

    @Deprecated
    public static enum ToBpLocalDateConverter implements Converter<LocalDate, org.threeten.bp.LocalDate>
    {
        INSTANCE;


        public org.threeten.bp.LocalDate convert(LocalDate date) {
            return org.threeten.bp.LocalDate.of((int)date.getYear(), (int)date.getMonthValue(), (int)date.getDayOfMonth());
        }
    }

    @WritingConverter
    @Deprecated
    public static enum FromBpLocalDateConverter implements Converter<org.threeten.bp.LocalDate, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(org.threeten.bp.LocalDate date) {
            return LocalDate.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        }
    }

    @Deprecated
    public static enum ToBpLocalTimeConverter implements Converter<java.time.LocalTime, LocalTime>
    {
        INSTANCE;


        public LocalTime convert(java.time.LocalTime source) {
            return LocalTime.ofNanoOfDay((long)source.toNanoOfDay());
        }
    }

    @WritingConverter
    @Deprecated
    public static enum FromBpLocalTimeConverter implements Converter<LocalTime, java.time.LocalTime>
    {
        INSTANCE;


        public java.time.LocalTime convert(LocalTime source) {
            return java.time.LocalTime.ofNanoOfDay(source.toNanoOfDay());
        }
    }

    @ReadingConverter
    @Deprecated
    public static enum LocalTimeToMillisOfDayConverter implements Converter<LocalTime, Long>
    {
        INSTANCE;


        public Long convert(LocalTime source) {
            return source.getLong((TemporalField)ChronoField.MILLI_OF_DAY);
        }
    }

    @Deprecated
    public static enum MillisOfDayToLocalTimeConverter implements Converter<Long, LocalTime>
    {
        INSTANCE;


        public LocalTime convert(Long source) {
            return LocalTime.ofNanoOfDay((long)TimeUnit.MILLISECONDS.toNanos(source));
        }
    }
}

