/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.cql.Row;
import java.lang.reflect.Constructor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.TypeConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.cassandra.core.cql.BeanPropertyRowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DataClassRowMapper<T>
extends BeanPropertyRowMapper<T> {
    @Nullable
    private Constructor<T> mappedConstructor;
    @Nullable
    private String[] constructorParameterNames;
    @Nullable
    private Class<?>[] constructorParameterTypes;

    public DataClassRowMapper(Class<T> mappedClass) {
        super(mappedClass);
    }

    @Override
    protected void initialize(Class<T> mappedClass) {
        super.initialize(mappedClass);
        this.mappedConstructor = BeanUtils.getResolvableConstructor(mappedClass);
        if (this.mappedConstructor.getParameterCount() > 0) {
            this.constructorParameterNames = BeanUtils.getParameterNames(this.mappedConstructor);
            this.constructorParameterTypes = this.mappedConstructor.getParameterTypes();
        }
    }

    @Override
    protected T constructMappedInstance(Row row, TypeConverter tc) {
        Object[] args;
        Assert.state((this.mappedConstructor != null ? 1 : 0) != 0, (String)"Mapped constructor was not initialized");
        if (this.constructorParameterNames != null && this.constructorParameterTypes != null) {
            args = new Object[this.constructorParameterNames.length];
            for (int i = 0; i < args.length; ++i) {
                String name = this.underscoreName(this.constructorParameterNames[i]);
                Class<?> type = this.constructorParameterTypes[i];
                args[i] = tc.convertIfNecessary(this.getColumnValue(row, row.getColumnDefinitions().firstIndexOf(name), type), type);
            }
        } else {
            args = new Object[]{};
        }
        return (T)BeanUtils.instantiateClass(this.mappedConstructor, (Object[])args);
    }

    public static <T> DataClassRowMapper<T> newInstance(Class<T> mappedClass) {
        return new DataClassRowMapper<T>(mappedClass);
    }

    public static <T> DataClassRowMapper<T> newInstance(Class<T> mappedClass, @Nullable ConversionService conversionService) {
        DataClassRowMapper<T> rowMapper = DataClassRowMapper.newInstance(mappedClass);
        rowMapper.setConversionService(conversionService);
        return rowMapper;
    }
}

