/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.convert.AbstractCassandraConverter;
import org.springframework.data.cassandra.core.convert.CassandraColumnType;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.convert.CassandraValueProvider;
import org.springframework.data.cassandra.core.convert.ColumnType;
import org.springframework.data.cassandra.core.convert.ColumnTypeResolver;
import org.springframework.data.cassandra.core.convert.DefaultColumnTypeResolver;
import org.springframework.data.cassandra.core.convert.RowReaderPropertyAccessor;
import org.springframework.data.cassandra.core.convert.RowValueProvider;
import org.springframework.data.cassandra.core.convert.TupleValueProvider;
import org.springframework.data.cassandra.core.convert.UdtValueProvider;
import org.springframework.data.cassandra.core.convert.Where;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.BasicMapId;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.Embedded;
import org.springframework.data.cassandra.core.mapping.EmbeddedEntityOperations;
import org.springframework.data.cassandra.core.mapping.MapId;
import org.springframework.data.cassandra.core.mapping.MapIdentifiable;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MappingCassandraConverter
extends AbstractCassandraConverter
implements ApplicationContextAware,
BeanClassLoaderAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CassandraMappingContext mappingContext;
    private CodecRegistry codecRegistry;
    private UserTypeResolver userTypeResolver;
    @Nullable
    private ClassLoader beanClassLoader;
    private SpELContext spELContext;
    private final DefaultColumnTypeResolver cassandraTypeResolver;
    private final EmbeddedEntityOperations embeddedEntityOperations;

    public MappingCassandraConverter() {
        super(MappingCassandraConverter.newConversionService());
        CassandraCustomConversions conversions = new CassandraCustomConversions(Collections.emptyList());
        this.mappingContext = MappingCassandraConverter.newDefaultMappingContext(conversions);
        this.codecRegistry = this.mappingContext.getCodecRegistry();
        this.spELContext = new SpELContext((PropertyAccessor)RowReaderPropertyAccessor.INSTANCE);
        this.cassandraTypeResolver = new DefaultColumnTypeResolver((MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty>)this.mappingContext, userTypeName -> this.getUserTypeResolver().resolveType(userTypeName), this::getCodecRegistry, this::getCustomConversions);
        this.setCustomConversions(conversions);
        this.embeddedEntityOperations = new EmbeddedEntityOperations((MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)this.mappingContext);
    }

    public MappingCassandraConverter(CassandraMappingContext mappingContext) {
        super(MappingCassandraConverter.newConversionService());
        Assert.notNull((Object)((Object)mappingContext), (String)"CassandraMappingContext must not be null");
        this.mappingContext = mappingContext;
        this.codecRegistry = mappingContext.getCodecRegistry();
        this.spELContext = new SpELContext((PropertyAccessor)RowReaderPropertyAccessor.INSTANCE);
        this.cassandraTypeResolver = new DefaultColumnTypeResolver((MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty>)mappingContext, userTypeName -> this.getUserTypeResolver().resolveType(userTypeName), this::getCodecRegistry, this::getCustomConversions);
        this.setCustomConversions(mappingContext.getCustomConversions());
        this.embeddedEntityOperations = new EmbeddedEntityOperations((MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)mappingContext);
    }

    private static ConversionService newConversionService() {
        return new DefaultConversionService();
    }

    private static CassandraMappingContext newDefaultMappingContext(CassandraCustomConversions conversions) {
        CassandraMappingContext mappingContext = new CassandraMappingContext();
        mappingContext.setCustomConversions(conversions);
        mappingContext.afterPropertiesSet();
        return mappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    private TypeCodec<Object> getCodec(CassandraPersistentProperty property) {
        return this.getCodecRegistry().codecFor(this.cassandraTypeResolver.resolve(property).getDataType());
    }

    public void setCodecRegistry(CodecRegistry codecRegistry) {
        Assert.notNull((Object)codecRegistry, (String)"CodecRegistry must not be null");
        this.codecRegistry = codecRegistry;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        if (this.codecRegistry == null) {
            return this.mappingContext.getCodecRegistry();
        }
        return this.codecRegistry;
    }

    public void setUserTypeResolver(UserTypeResolver userTypeResolver) {
        Assert.notNull((Object)userTypeResolver, (String)"UserTypeResolver must not be null");
        this.userTypeResolver = userTypeResolver;
    }

    public UserTypeResolver getUserTypeResolver() {
        if (this.userTypeResolver == null) {
            return this.mappingContext.getUserTypeResolver();
        }
        return this.userTypeResolver;
    }

    @Override
    public CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public ColumnTypeResolver getColumnTypeResolver() {
        return this.cassandraTypeResolver;
    }

    private <S> ConvertingPropertyAccessor<S> newConvertingPropertyAccessor(S source, CassandraPersistentEntity<?> entity) {
        PersistentPropertyAccessor propertyAccessor = source instanceof PersistentPropertyAccessor ? (PersistentPropertyAccessor)source : entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(propertyAccessor, this.getConversionService());
    }

    private <S> PersistentEntityParameterValueProvider<CassandraPersistentProperty> newParameterValueProvider(CassandraPersistentEntity<S> entity, CassandraValueProvider valueProvider) {
        return new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new MappingAndConvertingValueProvider(valueProvider), null);
    }

    private <T> Class<T> transformClassToBeanClassLoaderClass(Class<T> entity) {
        try {
            return ClassUtils.forName((String)entity.getName(), (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException | LinkageError ignore) {
            return entity;
        }
    }

    public <R> R read(Class<R> type, Object row) {
        if (row instanceof Row) {
            return this.readRow(type, (Row)row);
        }
        throw new MappingException(String.format("Unknown row object [%s]", ObjectUtils.nullSafeClassName((Object)row)));
    }

    public <R> R readRow(Class<R> type, Row row) {
        Class<R> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(type);
        ClassTypeInformation typeInfo = ClassTypeInformation.from(beanClassLoaderClass);
        Class rawType = typeInfo.getType();
        if (Row.class.isAssignableFrom(rawType)) {
            return (R)row;
        }
        if (this.getCustomConversions().hasCustomReadTarget(Row.class, rawType) || this.getConversionService().canConvert(Row.class, rawType)) {
            return (R)this.getConversionService().convert((Object)row, rawType);
        }
        if (this.getCustomConversions().hasCustomReadTarget(Row.class, rawType) || this.getConversionService().canConvert(Row.class, rawType)) {
            return (R)this.getConversionService().convert((Object)row, rawType);
        }
        if (typeInfo.isCollectionLike() || typeInfo.isMap()) {
            return (R)this.getConversionService().convert((Object)row, type);
        }
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity((TypeInformation)typeInfo);
        return (R)this.readEntityFromRow(persistentEntity, row);
    }

    private <S> S readEntityFromRow(CassandraPersistentEntity<S> entity, Row row) {
        return this.doReadEntity(entity, row, expressionEvaluator -> new RowValueProvider(row, (SpELExpressionEvaluator)expressionEvaluator));
    }

    private <S> S readEntityFromTuple(CassandraPersistentEntity<S> entity, TupleValue tupleValue) {
        return this.doReadEntity(entity, tupleValue, expressionEvaluator -> new TupleValueProvider(tupleValue, (SpELExpressionEvaluator)expressionEvaluator));
    }

    private <S> S readEntityFromUdt(CassandraPersistentEntity<S> entity, UdtValue udtValue) {
        return this.doReadEntity(entity, udtValue, expressionEvaluator -> new UdtValueProvider(udtValue, (SpELExpressionEvaluator)expressionEvaluator));
    }

    private <S> S doReadEntity(CassandraPersistentEntity<S> entity, Object value, Function<SpELExpressionEvaluator, CassandraValueProvider> valueProviderSupplier) {
        DefaultSpELExpressionEvaluator expressionEvaluator = new DefaultSpELExpressionEvaluator(value, this.spELContext);
        CassandraValueProvider valueProvider = valueProviderSupplier.apply((SpELExpressionEvaluator)expressionEvaluator);
        return this.doReadEntity(entity, valueProvider);
    }

    private <S> S doReadEntity(CassandraPersistentEntity<S> entity, CassandraValueProvider valueProvider) {
        Object provider;
        PreferredConstructor persistenceConstructor = entity.getPersistenceConstructor();
        if (persistenceConstructor != null && persistenceConstructor.hasParameters()) {
            DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator(valueProvider.getSource(), this.spELContext);
            PersistentEntityParameterValueProvider<CassandraPersistentProperty> parameterValueProvider = this.newParameterValueProvider(entity, valueProvider);
            provider = new ConverterAwareSpELExpressionParameterValueProvider((SpELExpressionEvaluator)evaluator, this.getConversionService(), (ParameterValueProvider<CassandraPersistentProperty>)parameterValueProvider);
        } else {
            provider = NoOpParameterValueProvider.INSTANCE;
        }
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)provider);
        if (entity.requiresPropertyPopulation()) {
            ConvertingPropertyAccessor<Object> propertyAccessor = this.newConvertingPropertyAccessor(instance, entity);
            this.readProperties(entity, valueProvider, (PersistentPropertyAccessor)propertyAccessor);
            return (S)propertyAccessor.getBean();
        }
        return (S)instance;
    }

    private void readProperties(CassandraPersistentEntity<?> entity, CassandraValueProvider valueProvider, PersistentPropertyAccessor propertyAccessor) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            this.readProperty(entity, property, valueProvider, propertyAccessor);
        }
    }

    private void readProperty(CassandraPersistentEntity<?> entity, CassandraPersistentProperty property, CassandraValueProvider valueProvider, PersistentPropertyAccessor propertyAccessor) {
        if (entity.isConstructorArgument(property)) {
            return;
        }
        if (property.isCompositePrimaryKey() || valueProvider.hasProperty(property) || property.isEmbedded()) {
            propertyAccessor.setProperty((PersistentProperty)property, this.getReadValue(valueProvider, property));
        }
    }

    @Override
    public Object convertToColumnType(Object obj) {
        return this.convertToColumnType(obj, (TypeInformation<?>)ClassTypeInformation.from(obj.getClass()));
    }

    @Override
    public Object convertToColumnType(Object value, ColumnType columnType) {
        return value.getClass().isArray() ? value : this.getWriteValue(value, columnType);
    }

    public void write(Object source, Object sink) {
        Assert.notNull((Object)source, (String)"Value must not be null");
        Class<?> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(source.getClass());
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(beanClassLoaderClass);
        this.write(source, sink, entity);
    }

    @Override
    public void write(Object source, Object sink, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Value must not be null");
        if (entity == null) {
            throw new MappingException("No mapping metadata found for " + source.getClass());
        }
        if (sink instanceof Where) {
            this.writeWhereFromObject(source, (Where)sink, entity);
        } else if (sink instanceof Map) {
            this.writeMapFromWrapper(this.newConvertingPropertyAccessor(source, entity), (Map)sink, entity);
        } else if (sink instanceof TupleValue) {
            this.writeTupleValue(this.newConvertingPropertyAccessor(source, entity), (TupleValue)sink, entity);
        } else if (sink instanceof UdtValue) {
            this.writeUDTValue(this.newConvertingPropertyAccessor(source, entity), (UdtValue)sink, entity);
        } else {
            throw new MappingException(String.format("Unknown write target [%s]", ObjectUtils.nullSafeClassName((Object)sink)));
        }
    }

    private void writeMapFromWrapper(ConvertingPropertyAccessor<?> accessor, Map<CqlIdentifier, Object> sink, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            Object value;
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (property.isCompositePrimaryKey()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Property is a compositeKey");
                }
                if ((value = accessor.getProperty((PersistentProperty)property)) == null) continue;
                CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property);
                this.writeMapFromWrapper(this.newConvertingPropertyAccessor(value, compositePrimaryKey), sink, compositePrimaryKey);
                continue;
            }
            value = this.getWriteValue(property, accessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("doWithProperties Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (!property.isWritable()) continue;
            if (value != null && property.isEmbedded()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Mapping embedded property [{}] - [{}]", (Object)property.getRequiredColumnName(), value);
                }
                this.write(value, sink, this.embeddedEntityOperations.getEntity(property));
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding map.entry [{}] - [{}]", (Object)property.getRequiredColumnName(), value);
            }
            sink.put(property.getRequiredColumnName(), value);
        }
    }

    private void writeWhereFromObject(Object source, Where sink, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Id source must not be null");
        Object id = this.extractId(source, entity);
        Assert.notNull((Object)id, (String)String.format("No Id value found in object %s", source));
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        CassandraPersistentProperty compositeIdProperty = null;
        if (idProperty != null && idProperty.isCompositePrimaryKey()) {
            compositeIdProperty = idProperty;
        }
        if (id instanceof MapId) {
            CassandraPersistentEntity whereEntity = compositeIdProperty != null ? (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(compositeIdProperty) : entity;
            this.writeWhere((MapId)MapId.class.cast(id), sink, whereEntity);
            return;
        }
        if (idProperty == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot obtain where clauses for entity [%s] using [%s]", entity.getName(), source));
        }
        if (compositeIdProperty != null) {
            if (!ClassUtils.isAssignableValue((Class)compositeIdProperty.getType(), (Object)id)) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot use [%s] as composite Id for [%s]", id, entity.getName()));
            }
            CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(compositeIdProperty);
            this.writeWhere(this.newConvertingPropertyAccessor(id, compositePrimaryKey), sink, compositePrimaryKey);
            return;
        }
        Class<?> targetType = this.getTargetType(idProperty);
        sink.put(idProperty.getRequiredColumnName(), this.getPotentiallyConvertedSimpleValue(id, targetType));
    }

    @Nullable
    private Object extractId(Object source, CassandraPersistentEntity<?> entity) {
        if (ClassUtils.isAssignableValue((Class)entity.getType(), (Object)source)) {
            return this.getId(source, entity);
        }
        if (source instanceof MapId) {
            return source;
        }
        if (source instanceof MapIdentifiable) {
            return ((MapIdentifiable)source).getMapId();
        }
        return source;
    }

    private void writeWhere(MapId id, Where sink, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)id, (String)"MapId must not be null");
        for (Map.Entry entry : id.entrySet()) {
            CassandraPersistentProperty persistentProperty = (CassandraPersistentProperty)entity.getPersistentProperty((String)entry.getKey());
            if (persistentProperty == null) {
                throw new IllegalArgumentException(String.format("MapId contains references [%s] that is an unknown property of [%s]", entry.getKey(), entity.getName()));
            }
            Object writeValue = this.getWriteValue(entry.getValue(), this.cassandraTypeResolver.resolve(persistentProperty));
            sink.put(persistentProperty.getRequiredColumnName(), writeValue);
        }
    }

    private void writeWhere(ConvertingPropertyAccessor<?> accessor, Where sink, CassandraPersistentEntity<?> entity) {
        Assert.isTrue((boolean)entity.isCompositePrimaryKey(), (String)String.format("Entity [%s] is not a composite primary key", entity.getName()));
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            TypeCodec<Object> codec = this.getCodec(property);
            Object value = accessor.getProperty((PersistentProperty)property, codec.getJavaType().getRawType());
            sink.put(property.getRequiredColumnName(), value);
        }
    }

    private void writeTupleValue(ConvertingPropertyAccessor<?> propertyAccessor, TupleValue tupleValue, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, propertyAccessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("writeTupleValue Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding tuple value [{}] - [{}]", (Object)property.getOrdinal(), value);
            }
            TypeCodec<Object> typeCodec = this.getCodec(property);
            tupleValue.set(property.getRequiredOrdinal(), value, typeCodec);
        }
    }

    private void writeUDTValue(ConvertingPropertyAccessor<?> propertyAccessor, UdtValue udtValue, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (!property.isWritable()) continue;
            Object value = this.getWriteValue(property, propertyAccessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("writeUDTValueWhereFromObject Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding udt.value [{}] - [{}]", (Object)property.getRequiredColumnName(), value);
            }
            if (property.isEmbedded()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Mapping embedded property [{}] - [{}]", (Object)property.getRequiredColumnName(), value);
                }
                if (value == null) continue;
                CassandraPersistentEntity<?> targetEntity = this.embeddedEntityOperations.getEntity(property);
                this.writeUDTValue(new ConvertingPropertyAccessor(targetEntity.getPropertyAccessor(value), this.getConversionService()), udtValue, targetEntity);
                continue;
            }
            TypeCodec<Object> typeCodec = this.getCodec(property);
            udtValue.set(property.getRequiredColumnName().toString(), value, typeCodec);
        }
    }

    @Override
    public Object getId(Object object, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)object, (String)"Object instance must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        ConvertingPropertyAccessor<Object> propertyAccessor = this.newConvertingPropertyAccessor(object, entity);
        Assert.isTrue((boolean)entity.getType().isAssignableFrom(object.getClass()), (String)String.format("Given instance of type [%s] is not compatible with expected type [%s]", object.getClass().getName(), entity.getType().getName()));
        if (object instanceof MapIdentifiable) {
            return ((MapIdentifiable)object).getMapId();
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            return propertyAccessor.getProperty((PersistentProperty)idProperty, idProperty.isCompositePrimaryKey() ? idProperty.getType() : this.getTargetType(idProperty));
        }
        MapId id = BasicMapId.id();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (!property.isPrimaryKeyColumn()) continue;
            id.with(property.getName(), this.getWriteValue(property, propertyAccessor));
        }
        return id;
    }

    private Class<?> getTargetType(CassandraPersistentProperty property) {
        return this.getCustomConversions().getCustomWriteTarget(property.getType()).orElseGet(() -> this.cassandraTypeResolver.resolve(property).getType());
    }

    @Nullable
    private <T> T getWriteValue(CassandraPersistentProperty property, ConvertingPropertyAccessor propertyAccessor) {
        CassandraColumnType cassandraTypeDescriptor = this.cassandraTypeResolver.resolve(property);
        return (T)this.getWriteValue(propertyAccessor.getProperty((PersistentProperty)property, cassandraTypeDescriptor.getType()), cassandraTypeDescriptor);
    }

    @Nullable
    private Object getWriteValue(@Nullable Object value, ColumnType columnType) {
        if (value == null) {
            return null;
        }
        Class<?> requestedTargetType = columnType.getType();
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass(), requestedTargetType)) {
            Class<?> resolvedTargetType = this.getCustomConversions().getCustomWriteTarget(value.getClass(), requestedTargetType).orElse(requestedTargetType);
            return this.getConversionService().convert(value, resolvedTargetType);
        }
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass())) {
            Class resolvedTargetType = (Class)this.getCustomConversions().getCustomWriteTarget(value.getClass()).orElseThrow(() -> new IllegalStateException(String.format("Unable to determined custom write target for value type [%s]", value.getClass().getName())));
            return this.getConversionService().convert(value, resolvedTargetType);
        }
        if (this.getCustomConversions().isSimpleType(value.getClass())) {
            return this.getPotentiallyConvertedSimpleValue(value, requestedTargetType);
        }
        if (value instanceof Collection) {
            return this.writeCollectionInternal((Collection)value, columnType);
        }
        if (value instanceof Map) {
            return this.writeMapInternal((Map)value, columnType);
        }
        ClassTypeInformation type = ClassTypeInformation.from(value.getClass());
        TypeInformation actualType = type.getRequiredActualType();
        BasicCassandraPersistentEntity entity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(actualType.getType());
        if (entity != null && columnType instanceof CassandraColumnType) {
            CassandraColumnType cassandraType = (CassandraColumnType)columnType;
            if (entity.isTupleType() && cassandraType.isTupleType()) {
                TupleValue tupleValue = ((TupleType)cassandraType.getDataType()).newValue();
                this.write(value, tupleValue, entity);
                return tupleValue;
            }
            if (entity.isUserDefinedType() && cassandraType.isUserDefinedType()) {
                UdtValue udtValue = ((UserDefinedType)cassandraType.getDataType()).newValue();
                this.write(value, udtValue, entity);
                return udtValue;
            }
        }
        return value;
    }

    private Object writeCollectionInternal(Collection<Object> source, ColumnType type) {
        Collection converted = CollectionFactory.createCollection(MappingCassandraConverter.getCollectionType(type), (int)source.size());
        ColumnType componentType = type.getRequiredComponentType();
        for (Object element : source) {
            converted.add(this.getWriteValue(element, componentType));
        }
        return converted;
    }

    private Object writeMapInternal(Map<Object, Object> source, ColumnType type) {
        Map converted = CollectionFactory.createMap(type.getType(), (int)source.size());
        ColumnType keyType = type.getRequiredComponentType();
        ColumnType valueType = type.getRequiredMapValueType();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            converted.put(this.getWriteValue(entry.getKey(), keyType), this.getWriteValue(entry.getValue(), valueType));
        }
        return converted;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleValue(@Nullable Object value, @Nullable Class<?> requestedTargetType) {
        if (value == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(value.getClass())) {
            if (requestedTargetType != null && !requestedTargetType.isEnum() && this.getConversionService().canConvert(value.getClass(), requestedTargetType)) {
                return this.getConversionService().convert(value, requestedTargetType);
            }
            return ((Enum)value).name();
        }
        return value;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (value == null || target == null || target.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (this.getCustomConversions().hasCustomReadTarget(value.getClass(), target)) {
            return this.getConversionService().convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            if (value instanceof Number) {
                int ordinal = ((Number)value).intValue();
                return target.getEnumConstants()[ordinal];
            }
            return Enum.valueOf(target, value.toString());
        }
        return this.getConversionService().convert(value, target);
    }

    private static Class<?> getCollectionType(ColumnType type) {
        return type.getType();
    }

    @Nullable
    private Object getReadValue(CassandraValueProvider valueProvider, CassandraPersistentProperty property) {
        if (property.isCompositePrimaryKey()) {
            CassandraPersistentEntity keyEntity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property);
            return this.doReadEntity(keyEntity, valueProvider);
        }
        if (property.isEmbedded()) {
            CassandraPersistentEntity<?> targetEntity = this.embeddedEntityOperations.getEntity(property);
            return this.isNullEmbedded(targetEntity, property, valueProvider) ? null : this.doReadEntity(targetEntity, valueProvider);
        }
        if (!valueProvider.hasProperty(property)) {
            return null;
        }
        Object value = valueProvider.getPropertyValue(property);
        return value == null ? null : this.convertReadValue(value, property.getTypeInformation());
    }

    private boolean isNullEmbedded(CassandraPersistentEntity<?> entity, CassandraPersistentProperty property, CassandraValueProvider valueProvider) {
        if (Embedded.OnEmpty.USE_EMPTY.equals((Object)((Embedded)property.getRequiredAnnotation(Embedded.class)).onEmpty())) {
            return false;
        }
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty embeddedProperty = (CassandraPersistentProperty)iterator.next();
            if (!valueProvider.hasProperty(embeddedProperty) || valueProvider.getPropertyValue(embeddedProperty) == null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private Object convertReadValue(Object value, TypeInformation<?> typeInformation) {
        BasicCassandraPersistentEntity udtEntity;
        BasicCassandraPersistentEntity tupleEntity;
        if (typeInformation.isCollectionLike() && value instanceof Collection) {
            return this.readCollectionOrArrayInternal((Collection)value, typeInformation);
        }
        if (typeInformation.isMap() && value instanceof Map) {
            return this.readMapInternal((Map)value, typeInformation);
        }
        if (value instanceof TupleValue && (tupleEntity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(typeInformation.getRequiredActualType())) != null) {
            return this.readEntityFromTuple(tupleEntity, (TupleValue)value);
        }
        if (value instanceof UdtValue && (udtEntity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(typeInformation.getRequiredActualType())) != null && udtEntity.isUserDefinedType()) {
            return this.readEntityFromUdt(udtEntity, (UdtValue)value);
        }
        return this.getPotentiallyConvertedSimpleRead(value, typeInformation.getType());
    }

    @Nullable
    private Object readCollectionOrArrayInternal(Collection<?> source, TypeInformation<?> targetType) {
        ArrayList<Object> collection;
        Assert.notNull(targetType, (String)"Target type must not be null");
        Class<?> collectionType = this.resolveCollectionType(targetType);
        Class<?> elementType = this.resolveElementType(targetType);
        Collection<Object> collection2 = collection = targetType.getType().isArray() ? new ArrayList<Object>() : CollectionFactory.createCollection(collectionType, elementType, (int)source.size());
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(collection, collectionType);
        }
        BasicCassandraPersistentEntity entity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(elementType);
        if (entity != null && entity.isUserDefinedType()) {
            for (Object element : source) {
                collection.add(this.readEntityFromUdt(entity, (UdtValue)element));
            }
        } else if (entity != null && entity.isTupleType()) {
            for (Object element : source) {
                collection.add(this.readEntityFromTuple(entity, (TupleValue)element));
            }
        } else {
            for (Object element : source) {
                collection.add(this.getPotentiallyConvertedSimpleRead(element, elementType));
            }
        }
        return this.getPotentiallyConvertedSimpleRead(collection, targetType.getType());
    }

    private Class<?> resolveCollectionType(TypeInformation typeInformation) {
        Class<List> collectionType = typeInformation.getType();
        return Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
    }

    private Class<?> resolveElementType(TypeInformation typeInformation) {
        TypeInformation componentType = typeInformation.getComponentType();
        return componentType != null ? componentType.getType() : Object.class;
    }

    private Object readMapInternal(Map<Object, Object> source, TypeInformation<?> targetType) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        TypeInformation keyType = targetType.getComponentType();
        TypeInformation valueType = targetType.getMapValueType();
        Class rawKeyType = keyType != null ? keyType.getType() : null;
        Map map = CollectionFactory.createMap(this.resolveMapType(targetType), (Class)rawKeyType, (int)source.size());
        if (source.isEmpty()) {
            return map;
        }
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            Object key = entry.getKey();
            if (key != null && rawKeyType != null && !rawKeyType.isAssignableFrom(key.getClass())) {
                key = this.convertReadValue(key, keyType);
            }
            Object value = entry.getValue();
            map.put(key, this.convertReadValue(value, valueType));
        }
        return map;
    }

    private Class<?> resolveMapType(TypeInformation<?> typeInformation) {
        Class<Map> mapType = typeInformation.getType();
        return Map.class.isAssignableFrom(mapType) ? mapType : Map.class;
    }

    class MappingAndConvertingValueProvider
    implements CassandraValueProvider {
        private final CassandraValueProvider parent;

        public MappingAndConvertingValueProvider(CassandraValueProvider parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasProperty(CassandraPersistentProperty property) {
            return this.parent.hasProperty(property);
        }

        @Nullable
        public <T> T getPropertyValue(CassandraPersistentProperty property) {
            return (T)MappingCassandraConverter.this.getReadValue(this.parent, property);
        }

        @Override
        public Object getSource() {
            return this.parent.getSource();
        }
    }

    private class ConverterAwareSpELExpressionParameterValueProvider
    extends SpELExpressionParameterValueProvider<CassandraPersistentProperty> {
        public ConverterAwareSpELExpressionParameterValueProvider(SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<CassandraPersistentProperty> delegate) {
            super(evaluator, conversionService, delegate);
        }

        protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, CassandraPersistentProperty> parameter) {
            return (T)MappingCassandraConverter.this.convertReadValue(object, parameter.getType());
        }
    }

    static enum NoOpParameterValueProvider implements ParameterValueProvider<CassandraPersistentProperty>
    {
        INSTANCE;


        public <T> T getParameterValue(PreferredConstructor.Parameter<T, CassandraPersistentProperty> parameter) {
            return null;
        }
    }
}

