/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class CassandraPersistentEntitySchemaDropper {
    private final CassandraAdminOperations cassandraAdminOperations;
    private final CassandraMappingContext mappingContext;

    public CassandraPersistentEntitySchemaDropper(CassandraMappingContext mappingContext, CassandraAdminOperations cassandraAdminOperations) {
        Assert.notNull((Object)cassandraAdminOperations, (String)"CassandraAdminOperations must not be null");
        Assert.notNull((Object)((Object)mappingContext), (String)"CassandraMappingContext must not be null");
        this.cassandraAdminOperations = cassandraAdminOperations;
        this.mappingContext = mappingContext;
    }

    public void dropTables(boolean dropUnused) {
        this.cassandraAdminOperations.getKeyspaceMetadata().getTables().values().stream().map(RelationMetadata::getName).filter(table -> dropUnused || this.mappingContext.usesTable((CqlIdentifier)table)).forEach(this.cassandraAdminOperations::dropTable);
    }

    public void dropUserTypes(boolean dropUnused) {
        Set canRecreate = this.mappingContext.getUserDefinedTypeEntities().stream().map(CassandraPersistentEntity::getTableName).collect(Collectors.toSet());
        Collection<UserDefinedType> userTypes = this.cassandraAdminOperations.getKeyspaceMetadata().getUserDefinedTypes().values();
        this.getUserTypesToDrop(userTypes).stream().filter(it -> canRecreate.contains(it) || dropUnused && !this.mappingContext.usesUserType((CqlIdentifier)it)).forEach(this.cassandraAdminOperations::dropUserType);
    }

    private List<CqlIdentifier> getUserTypesToDrop(Collection<UserDefinedType> knownUserTypes) {
        ArrayList<CqlIdentifier> toDrop = new ArrayList<CqlIdentifier>();
        UserTypeDependencyGraphBuilder builder = new UserTypeDependencyGraphBuilder();
        knownUserTypes.forEach(builder::addUserType);
        UserTypeDependencyGraph dependencyGraph = builder.build();
        LinkedHashSet globalSeen = new LinkedHashSet();
        knownUserTypes.forEach(userType -> toDrop.addAll(dependencyGraph.getDropOrder(userType.getName(), globalSeen::add)));
        return toDrop;
    }

    static class UserTypeDependencyGraph {
        private final MultiValueMap<CqlIdentifier, CqlIdentifier> dependencies;

        UserTypeDependencyGraph(MultiValueMap<CqlIdentifier, CqlIdentifier> dependencies) {
            this.dependencies = dependencies;
        }

        List<CqlIdentifier> getDropOrder(CqlIdentifier typeName, Predicate<CqlIdentifier> typeFilter) {
            ArrayList<CqlIdentifier> toDrop = new ArrayList<CqlIdentifier>();
            if (typeFilter.test(typeName)) {
                List dependants = (List)this.dependencies.getOrDefault((Object)typeName, Collections.emptyList());
                dependants.stream().map(dependant -> this.getDropOrder((CqlIdentifier)dependant, typeFilter)).forEach(toDrop::addAll);
                toDrop.add(typeName);
            }
            return toDrop;
        }
    }

    static class UserTypeDependencyGraphBuilder {
        private final MultiValueMap<CqlIdentifier, CqlIdentifier> dependencies = new LinkedMultiValueMap();

        UserTypeDependencyGraphBuilder() {
        }

        void addUserType(UserDefinedType userType) {
            LinkedHashSet seen = new LinkedHashSet();
            this.visitTypes(userType, seen::add);
        }

        UserTypeDependencyGraph build() {
            return new UserTypeDependencyGraph((MultiValueMap<CqlIdentifier, CqlIdentifier>)new LinkedMultiValueMap(this.dependencies));
        }

        private void visitTypes(UserDefinedType userType, Predicate<CqlIdentifier> typeFilter) {
            CqlIdentifier typeName = userType.getName();
            if (!typeFilter.test(typeName)) {
                return;
            }
            for (DataType fieldType : userType.getFieldTypes()) {
                if (fieldType instanceof UserDefinedType) {
                    this.addDependency((UserDefinedType)fieldType, typeName, typeFilter);
                    return;
                }
                UserTypeDependencyGraphBuilder.doWithTypeArguments(fieldType, it -> {
                    if (it instanceof UserDefinedType) {
                        this.addDependency((UserDefinedType)it, typeName, typeFilter);
                    }
                });
            }
        }

        private void addDependency(UserDefinedType userType, CqlIdentifier requiredBy, Predicate<CqlIdentifier> typeFilter) {
            this.dependencies.add((Object)userType.getName(), (Object)requiredBy);
            this.visitTypes(userType, typeFilter);
        }

        private static void doWithTypeArguments(DataType type, Consumer<DataType> callback) {
            if (type instanceof MapType) {
                MapType mapType = (MapType)type;
                callback.accept(mapType.getKeyType());
                UserTypeDependencyGraphBuilder.doWithTypeArguments(mapType.getKeyType(), callback);
                callback.accept(mapType.getValueType());
                UserTypeDependencyGraphBuilder.doWithTypeArguments(mapType.getValueType(), callback);
            }
            if (type instanceof ListType) {
                ListType listType = (ListType)type;
                callback.accept(listType.getElementType());
                UserTypeDependencyGraphBuilder.doWithTypeArguments(listType.getElementType(), callback);
            }
            if (type instanceof SetType) {
                SetType setType = (SetType)type;
                callback.accept(setType.getElementType());
                UserTypeDependencyGraphBuilder.doWithTypeArguments(setType.getElementType(), callback);
            }
            if (type instanceof TupleType) {
                TupleType tupleType = (TupleType)type;
                tupleType.getComponentTypes().forEach(nested -> {
                    callback.accept((DataType)nested);
                    UserTypeDependencyGraphBuilder.doWithTypeArguments(nested, callback);
                });
            }
        }
    }
}

