/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.AsyncCqlOperations;
import org.springframework.data.cassandra.core.cql.AsyncPreparedStatementCreator;
import org.springframework.data.cassandra.core.cql.AsyncResultSetExtractor;
import org.springframework.data.cassandra.core.cql.AsyncResultStream;
import org.springframework.data.cassandra.core.cql.AsyncRowMapperResultSetExtractor;
import org.springframework.data.cassandra.core.cql.AsyncSessionCallback;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.ExceptionTranslatingListenableFutureAdapter;
import org.springframework.data.cassandra.core.cql.PreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.PreparedStatementCallback;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.data.cassandra.core.cql.RowCallbackHandler;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.util.CassandraFutureAdapter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureAdapter;
import org.springframework.util.concurrent.SettableListenableFuture;

public class AsyncCqlTemplate
extends CassandraAccessor
implements AsyncCqlOperations {
    public AsyncCqlTemplate() {
    }

    public AsyncCqlTemplate(CqlSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.setSession(session);
    }

    public AsyncCqlTemplate(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"SessionFactory must not be null");
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public <T> ListenableFuture<T> execute(AsyncSessionCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        try {
            return action.doInSession(this.getCurrentSession());
        }
        catch (DriverException e) {
            throw this.translateException("SessionCallback", AsyncCqlTemplate.toCql(action), e);
        }
    }

    @Override
    public ListenableFuture<Boolean> execute(String cql) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return new MappingListenableFutureAdapter(this.queryForResultSet(cql), AsyncResultSet::wasApplied);
    }

    @Override
    public <T> ListenableFuture<T> query(String cql, AsyncResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(resultSetExtractor, (String)"AsyncResultSetExtractor must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing CQL statement [{}]", (Object)cql);
            }
            CompletionStage results = this.getCurrentSession().executeAsync(this.applyStatementSettings((Statement<?>)this.newStatement(cql))).thenApply(resultSetExtractor::extractData).thenCompose(ListenableFuture::completable);
            return new CassandraFutureAdapter(results, ex -> this.translateExceptionIfPossible("Query", cql, ex));
        }
        catch (DriverException e) {
            throw this.translateException("Query", cql, e);
        }
    }

    @Override
    public ListenableFuture<Void> query(String cql, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        ListenableFuture<Void> results = this.query(cql, this.newAsyncResultSetExtractor(rowCallbackHandler));
        return new MappingListenableFutureAdapter(results, o -> null);
    }

    @Override
    public <T> ListenableFuture<List<T>> query(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(cql, this.newAsyncResultSetExtractor(rowMapper));
    }

    @Override
    public ListenableFuture<List<Map<String, Object>>> queryForList(String cql) throws DataAccessException {
        return this.query(cql, this.newAsyncResultSetExtractor(this.newColumnMapRowMapper()));
    }

    @Override
    public <T> ListenableFuture<List<T>> queryForList(String cql, Class<T> elementType) throws DataAccessException {
        return this.query(cql, this.newAsyncResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public ListenableFuture<Map<String, Object>> queryForMap(String cql) throws DataAccessException {
        return this.queryForObject(cql, this.newColumnMapRowMapper());
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(String cql, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(cql, this.newSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        ListenableFuture<T> results = this.query(cql, this.newAsyncResultSetExtractor(rowMapper));
        return new ExceptionTranslatingListenableFutureAdapter(new MappingListenableFutureAdapter(results, DataAccessUtils::requiredSingleResult), this.getExceptionTranslator());
    }

    @Override
    public ListenableFuture<AsyncResultSet> queryForResultSet(String cql) throws DataAccessException {
        return this.query(cql, AsyncCqlTemplate::toResultSet);
    }

    @Override
    public ListenableFuture<Boolean> execute(Statement<?> statement) throws DataAccessException {
        Assert.notNull(statement, (String)"CQL Statement must not be null");
        return new MappingListenableFutureAdapter(this.queryForResultSet(statement), AsyncResultSet::wasApplied);
    }

    @Override
    public <T> ListenableFuture<T> query(Statement<?> statement, AsyncResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.notNull(statement, (String)"CQL Statement must not be null");
        Assert.notNull(resultSetExtractor, (String)"AsyncResultSetExtractor must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing statement [{}]", (Object)QueryExtractorDelegate.getCql(statement));
            }
            CompletionStage results = this.getCurrentSession().executeAsync(this.applyStatementSettings(statement)).thenApply(resultSetExtractor::extractData).thenCompose(ListenableFuture::completable);
            return new CassandraFutureAdapter(results, ex -> this.translateExceptionIfPossible("Query", statement.toString(), ex));
        }
        catch (DriverException e) {
            throw this.translateException("Query", statement.toString(), e);
        }
    }

    @Override
    public ListenableFuture<Void> query(Statement<?> statement, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        ListenableFuture<Void> result = this.query(statement, this.newAsyncResultSetExtractor(rowCallbackHandler));
        return new ExceptionTranslatingListenableFutureAdapter<Void>((ListenableFuture<Void>)new MappingListenableFutureAdapter(result, o -> null), this.getExceptionTranslator());
    }

    @Override
    public <T> ListenableFuture<List<T>> query(Statement<?> statement, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(statement, this.newAsyncResultSetExtractor(rowMapper));
    }

    @Override
    public ListenableFuture<List<Map<String, Object>>> queryForList(Statement<?> statement) throws DataAccessException {
        return this.query(statement, this.newAsyncResultSetExtractor(this.newColumnMapRowMapper()));
    }

    @Override
    public <T> ListenableFuture<List<T>> queryForList(Statement<?> statement, Class<T> elementType) throws DataAccessException {
        return this.query(statement, this.newAsyncResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public ListenableFuture<Map<String, Object>> queryForMap(Statement<?> statement) throws DataAccessException {
        return this.queryForObject(statement, this.newColumnMapRowMapper());
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(Statement<?> statement, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(statement, this.newSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(Statement<?> statement, RowMapper<T> rowMapper) throws DataAccessException {
        ListenableFuture<T> results = this.query(statement, this.newAsyncResultSetExtractor(rowMapper));
        return new ExceptionTranslatingListenableFutureAdapter(new MappingListenableFutureAdapter(results, DataAccessUtils::requiredSingleResult), this.getExceptionTranslator());
    }

    @Override
    public ListenableFuture<AsyncResultSet> queryForResultSet(Statement<?> statement) throws DataAccessException {
        return this.query(statement, AsyncCqlTemplate::toResultSet);
    }

    @Override
    public ListenableFuture<Boolean> execute(AsyncPreparedStatementCreator preparedStatementCreator) throws DataAccessException {
        return new MappingListenableFutureAdapter(this.query(preparedStatementCreator, AsyncCqlTemplate::toResultSet), AsyncResultSet::wasApplied);
    }

    @Override
    public ListenableFuture<Boolean> execute(String cql, Object ... args) throws DataAccessException {
        return this.execute(cql, this.newPreparedStatementBinder(args));
    }

    @Override
    public ListenableFuture<Boolean> execute(String cql, @Nullable PreparedStatementBinder psb) throws DataAccessException {
        return new MappingListenableFutureAdapter(this.query(this.newAsyncPreparedStatementCreator(cql), psb, AsyncCqlTemplate::toResultSet), AsyncResultSet::wasApplied);
    }

    @Override
    public <T> ListenableFuture<T> execute(String cql, PreparedStatementCallback<T> action) throws DataAccessException {
        return this.execute(this.newAsyncPreparedStatementCreator(cql), action);
    }

    @Override
    public <T> ListenableFuture<T> execute(AsyncPreparedStatementCreator preparedStatementCreator, PreparedStatementCallback<T> action) throws DataAccessException {
        Assert.notNull((Object)preparedStatementCreator, (String)"PreparedStatementCreator must not be null");
        Assert.notNull(action, (String)"PreparedStatementCallback object must not be null");
        PersistenceExceptionTranslator exceptionTranslator = ex -> this.translateExceptionIfPossible("PreparedStatementCallback", AsyncCqlTemplate.toCql(preparedStatementCreator), ex);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Preparing statement [{}] using {}", (Object)AsyncCqlTemplate.toCql(preparedStatementCreator), (Object)preparedStatementCreator);
            }
            CqlSession currentSession = this.getCurrentSession();
            return new ExceptionTranslatingListenableFutureAdapter(new MappingListenableFutureAdapter(preparedStatementCreator.createPreparedStatement(currentSession), preparedStatement -> {
                try {
                    return action.doInPreparedStatement(currentSession, (PreparedStatement)preparedStatement);
                }
                catch (DriverException e) {
                    throw AsyncCqlTemplate.translateException(exceptionTranslator, e);
                }
            }), this.getExceptionTranslator());
        }
        catch (DriverException e) {
            throw AsyncCqlTemplate.translateException(exceptionTranslator, e);
        }
    }

    @Override
    public <T> ListenableFuture<T> query(AsyncPreparedStatementCreator preparedStatementCreator, AsyncResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        return this.query(preparedStatementCreator, null, resultSetExtractor);
    }

    @Override
    public ListenableFuture<Void> query(AsyncPreparedStatementCreator preparedStatementCreator, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        ListenableFuture<Void> results = this.query(preparedStatementCreator, null, this.newAsyncResultSetExtractor(rowCallbackHandler));
        return new ExceptionTranslatingListenableFutureAdapter<Void>((ListenableFuture<Void>)new MappingListenableFutureAdapter(results, o -> null), this.getExceptionTranslator());
    }

    @Override
    public <T> ListenableFuture<List<T>> query(AsyncPreparedStatementCreator preparedStatementCreator, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(preparedStatementCreator, null, this.newAsyncResultSetExtractor(rowMapper));
    }

    @Override
    public <T> ListenableFuture<T> query(AsyncPreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, AsyncResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.notNull((Object)preparedStatementCreator, (String)"AsyncPreparedStatementCreator must not be null");
        Assert.notNull(resultSetExtractor, (String)"AsyncResultSetExtractor object must not be null");
        PersistenceExceptionTranslator exceptionTranslator = ex -> this.translateExceptionIfPossible("Query", AsyncCqlTemplate.toCql(preparedStatementCreator), ex);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Preparing statement [{}] using {}", (Object)AsyncCqlTemplate.toCql(preparedStatementCreator), (Object)preparedStatementCreator);
            }
            CqlSession session = this.getCurrentSession();
            MappingListenableFutureAdapter statementFuture = new MappingListenableFutureAdapter(preparedStatementCreator.createPreparedStatement(session), preparedStatement -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Executing prepared statement [{}]", (Object)QueryExtractorDelegate.getCql(preparedStatement));
                }
                return this.applyStatementSettings((Statement<?>)(psb != null ? psb.bindValues((PreparedStatement)preparedStatement) : preparedStatement.bind(new Object[0])));
            });
            CompletionStage result = ((CompletableFuture)((CompletableFuture)statementFuture.completable().thenCompose(arg_0 -> ((CqlSession)session).executeAsync(arg_0))).thenApply(resultSetExtractor::extractData)).thenCompose(ListenableFuture::completable);
            return new CassandraFutureAdapter(result, exceptionTranslator);
        }
        catch (DriverException e) {
            throw AsyncCqlTemplate.translateException(exceptionTranslator, e);
        }
    }

    @Override
    public ListenableFuture<Void> query(AsyncPreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        ListenableFuture<Void> results = this.query(preparedStatementCreator, psb, this.newAsyncResultSetExtractor(rowCallbackHandler));
        return new ExceptionTranslatingListenableFutureAdapter<Void>((ListenableFuture<Void>)new MappingListenableFutureAdapter(results, o -> null), this.getExceptionTranslator());
    }

    @Override
    public <T> ListenableFuture<List<T>> query(AsyncPreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(preparedStatementCreator, psb, this.newAsyncResultSetExtractor(rowMapper));
    }

    @Override
    public <T> ListenableFuture<T> query(String cql, AsyncResultSetExtractor<T> resultSetExtractor, Object ... args) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), resultSetExtractor);
    }

    @Override
    public ListenableFuture<Void> query(String cql, RowCallbackHandler rowCallbackHandler, Object ... args) throws DataAccessException {
        ListenableFuture<Void> results = this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newAsyncResultSetExtractor(rowCallbackHandler));
        return new ExceptionTranslatingListenableFutureAdapter<Void>((ListenableFuture<Void>)new MappingListenableFutureAdapter(results, o -> null), this.getExceptionTranslator());
    }

    @Override
    public <T> ListenableFuture<List<T>> query(String cql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newAsyncResultSetExtractor(rowMapper));
    }

    @Override
    public <T> ListenableFuture<T> query(String cql, @Nullable PreparedStatementBinder psb, AsyncResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), psb, resultSetExtractor);
    }

    @Override
    public ListenableFuture<Void> query(String cql, @Nullable PreparedStatementBinder psb, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        ListenableFuture<Void> results = this.query(this.newAsyncPreparedStatementCreator(cql), psb, this.newAsyncResultSetExtractor(rowCallbackHandler));
        return new ExceptionTranslatingListenableFutureAdapter<Void>((ListenableFuture<Void>)new MappingListenableFutureAdapter(results, o -> null), this.getExceptionTranslator());
    }

    @Override
    public <T> ListenableFuture<List<T>> query(String cql, @Nullable PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), psb, this.newAsyncResultSetExtractor(rowMapper));
    }

    @Override
    public ListenableFuture<List<Map<String, Object>>> queryForList(String cql, Object ... args) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newAsyncResultSetExtractor(this.newColumnMapRowMapper()));
    }

    @Override
    public <T> ListenableFuture<List<T>> queryForList(String cql, Class<T> elementType, Object ... args) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newAsyncResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public ListenableFuture<Map<String, Object>> queryForMap(String cql, Object ... args) throws DataAccessException {
        return this.queryForObject(cql, this.newColumnMapRowMapper(), args);
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(String cql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return this.queryForObject(cql, this.newSingleColumnRowMapper(requiredType), args);
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(String cql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        ListenableFuture<T> results = this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newAsyncResultSetExtractor(rowMapper));
        return new ExceptionTranslatingListenableFutureAdapter(new MappingListenableFutureAdapter(results, DataAccessUtils::requiredSingleResult), this.getExceptionTranslator());
    }

    @Override
    public ListenableFuture<AsyncResultSet> queryForResultSet(String cql, Object ... args) throws DataAccessException {
        return this.query(cql, AsyncCqlTemplate::toResultSet, args);
    }

    protected DataAccessException translateException(String task, @Nullable String cql, DriverException ex) {
        return this.translate(task, cql, (RuntimeException)((Object)ex));
    }

    @Nullable
    protected DataAccessException translateExceptionIfPossible(String task, @Nullable String cql, RuntimeException ex) {
        return this.translate(task, cql, ex);
    }

    protected AsyncPreparedStatementCreator newAsyncPreparedStatementCreator(String cql) {
        return new SimpleAsyncPreparedStatementCreator((SimpleStatement)this.applyStatementSettings((Statement<?>)SimpleStatement.newInstance((String)cql)), ex -> this.translateExceptionIfPossible("PrepareStatement", cql, ex));
    }

    protected AsyncRowCallbackHandlerResultSetExtractor newAsyncResultSetExtractor(RowCallbackHandler rowCallbackHandler) {
        return new AsyncRowCallbackHandlerResultSetExtractor(rowCallbackHandler);
    }

    protected <T> AsyncRowMapperResultSetExtractor<T> newAsyncResultSetExtractor(RowMapper<T> rowMapper) {
        return new AsyncRowMapperResultSetExtractor<T>(rowMapper);
    }

    private CqlSession getCurrentSession() {
        SessionFactory sessionFactory = this.getSessionFactory();
        Assert.state((sessionFactory != null ? 1 : 0) != 0, (String)"SessionFactory is null");
        return sessionFactory.getSession();
    }

    private static ListenableFuture<AsyncResultSet> toResultSet(AsyncResultSet resultSet) {
        SettableListenableFuture future = new SettableListenableFuture();
        future.set((Object)resultSet);
        return future;
    }

    private static RuntimeException translateException(PersistenceExceptionTranslator exceptionTranslator, DriverException e) {
        DataAccessException translated = exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
        return translated == null ? e : translated;
    }

    private static class MappingListenableFutureAdapter<T, S>
    extends ListenableFutureAdapter<T, S> {
        private final Function<S, T> mapper;

        private MappingListenableFutureAdapter(ListenableFuture<S> adaptee, Function<S, T> mapper) {
            super(adaptee);
            this.mapper = mapper;
        }

        protected T adapt(S adapteeResult) throws ExecutionException {
            return this.mapper.apply(adapteeResult);
        }
    }

    protected static class AsyncRowCallbackHandlerResultSetExtractor
    implements AsyncResultSetExtractor<Void> {
        private final RowCallbackHandler rowCallbackHandler;

        protected AsyncRowCallbackHandlerResultSetExtractor(RowCallbackHandler rowCallbackHandler) {
            this.rowCallbackHandler = rowCallbackHandler;
        }

        @Override
        @Nullable
        public ListenableFuture<Void> extractData(AsyncResultSet resultSet) {
            return AsyncResultStream.from(resultSet).forEach(this.rowCallbackHandler::processRow);
        }
    }

    private static class SimpleAsyncPreparedStatementCreator
    implements AsyncPreparedStatementCreator,
    CqlProvider {
        private final PersistenceExceptionTranslator exceptionTranslator;
        private final SimpleStatement statement;

        private SimpleAsyncPreparedStatementCreator(SimpleStatement statement, PersistenceExceptionTranslator exceptionTranslator) {
            this.statement = statement;
            this.exceptionTranslator = exceptionTranslator;
        }

        @Override
        public ListenableFuture<PreparedStatement> createPreparedStatement(CqlSession session) throws DriverException {
            return new CassandraFutureAdapter<PreparedStatement>(session.prepareAsync(this.statement), this.exceptionTranslator);
        }

        @Override
        public String getCql() {
            return this.statement.getQuery();
        }
    }
}

