/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.data.util.Lazy;

public class ReactiveCassandraQueryMethod
extends CassandraQueryMethod {
    private final Lazy<Boolean> isCollectionQuery = Lazy.of(() -> !this.isPageQuery() && !this.isSliceQuery() && ReactiveWrappers.isMultiValueType((Class)metadata.getReturnType(method).getType()) || super.isCollectionQuery());

    public ReactiveCassandraQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext) {
        super(method, metadata, projectionFactory, mappingContext);
    }

    public boolean isCollectionQuery() {
        return (Boolean)this.isCollectionQuery.get();
    }

    public boolean isStreamQuery() {
        return true;
    }

    public boolean hasReactiveWrapperParameter() {
        Iterator iterator = this.getParameters().iterator();
        while (iterator.hasNext()) {
            CassandraParameters.CassandraParameter cassandraParameter = (CassandraParameters.CassandraParameter)((Object)iterator.next());
            if (!ReactiveWrapperConverters.supports(cassandraParameter.getType())) continue;
            return true;
        }
        return false;
    }
}

