/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.condition.ConditionBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.relation.ColumnRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.OngoingAssignment;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import com.datastax.oss.driver.api.querybuilder.update.UpdateWithAssignments;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.DeleteOptions;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.convert.Where;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.QueryOptionsUtil;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.cql.util.StatementBuilder;
import org.springframework.data.cassandra.core.cql.util.TermFactory;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.query.Columns;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Filter;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class StatementFactory {
    private final CassandraConverter cassandraConverter;
    private final QueryMapper queryMapper;
    private final UpdateMapper updateMapper;
    private final ProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();

    public StatementFactory(CassandraConverter converter) {
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.cassandraConverter = converter;
        UpdateMapper updateMapper = new UpdateMapper(converter);
        this.queryMapper = updateMapper;
        this.updateMapper = updateMapper;
    }

    public StatementFactory(UpdateMapper updateMapper) {
        this(updateMapper, updateMapper);
    }

    public StatementFactory(QueryMapper queryMapper, UpdateMapper updateMapper) {
        Assert.notNull((Object)queryMapper, (String)"QueryMapper must not be null");
        Assert.notNull((Object)updateMapper, (String)"UpdateMapper must not be null");
        this.cassandraConverter = queryMapper.getConverter();
        this.queryMapper = queryMapper;
        this.updateMapper = updateMapper;
    }

    protected QueryMapper getQueryMapper() {
        return this.queryMapper;
    }

    protected UpdateMapper getUpdateMapper() {
        return this.updateMapper;
    }

    public StatementBuilder<Select> count(Query query2, CassandraPersistentEntity<?> persistentEntity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(persistentEntity, (String)"CassandraPersistentEntity must not be null");
        return this.count(query2, persistentEntity, persistentEntity.getTableName());
    }

    public StatementBuilder<Select> count(Query query2, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Filter filter = this.getQueryMapper().getMappedObject(query2, entity);
        List<Columns.Selector> selectors = Collections.singletonList(Columns.FunctionCall.from("COUNT", 1L));
        return this.createSelect(query2, entity, filter, selectors, tableName);
    }

    StatementBuilder<Select> selectOneById(Object id, CassandraPersistentEntity<?> persistentEntity, CqlIdentifier tableName) {
        Where where = new Where();
        this.cassandraConverter.write(id, where, persistentEntity);
        return StatementBuilder.of(QueryBuilder.selectFrom((CqlIdentifier)tableName).all().limit(1)).bind((statement, factory) -> (Select)statement.where(StatementFactory.toRelations(where, factory)));
    }

    public StatementBuilder<Select> select(Query query2, CassandraPersistentEntity<?> persistentEntity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(persistentEntity, (String)"CassandraPersistentEntity must not be null");
        return this.select(query2, persistentEntity, persistentEntity.getTableName());
    }

    public StatementBuilder<Select> select(Query query2, CassandraPersistentEntity<?> persistentEntity, CqlIdentifier tableName) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(persistentEntity, (String)"CassandraPersistentEntity must not be null");
        Assert.notNull(persistentEntity, (String)"Table name must not be null");
        Filter filter = this.getQueryMapper().getMappedObject(query2, persistentEntity);
        List<Columns.Selector> selectors = this.getQueryMapper().getMappedSelectors(query2.getColumns(), persistentEntity);
        return this.createSelect(query2, persistentEntity, filter, selectors, tableName);
    }

    public StatementBuilder<RegularInsert> insert(Object objectToInsert, WriteOptions options) {
        Assert.notNull((Object)objectToInsert, (String)"Object to builder must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.cassandraConverter.getMappingContext().getRequiredPersistentEntity(objectToInsert.getClass());
        return this.insert(objectToInsert, options, persistentEntity, persistentEntity.getTableName());
    }

    StatementBuilder<RegularInsert> insert(Object objectToInsert, WriteOptions options, CassandraPersistentEntity<?> persistentEntity, CqlIdentifier tableName) {
        boolean insertNulls;
        Assert.notNull((Object)tableName, (String)"TableName must not be null");
        Assert.notNull((Object)objectToInsert, (String)"Object to insert must not be null");
        Assert.notNull(persistentEntity, (String)"CassandraPersistentEntity must not be null");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        if (options instanceof InsertOptions) {
            InsertOptions insertOptions = (InsertOptions)options;
            insertNulls = insertOptions.isInsertNulls();
        } else {
            insertNulls = false;
        }
        LinkedHashMap object = new LinkedHashMap();
        this.cassandraConverter.write(objectToInsert, object, persistentEntity);
        StatementBuilder<RegularInsert> builder = StatementBuilder.of(QueryBuilder.insertInto((CqlIdentifier)tableName).valuesByIds(Collections.emptyMap())).bind((statement, factory) -> {
            Map<CqlIdentifier, Term> values = StatementFactory.createTerms(insertNulls, object, factory);
            return statement.valuesByIds(values);
        }).apply(statement -> (RegularInsert)StatementFactory.addWriteOptions((Insert)statement, options));
        builder.transform(statement -> QueryOptionsUtil.addQueryOptions(statement, options));
        return builder;
    }

    private static Map<CqlIdentifier, Term> createTerms(boolean insertNulls, Map<CqlIdentifier, Object> object, TermFactory factory) {
        LinkedHashMap<CqlIdentifier, Term> values = new LinkedHashMap<CqlIdentifier, Term>(object.size());
        object.forEach((cqlIdentifier, o) -> {
            if (o == null && !insertNulls) {
                return;
            }
            values.put((CqlIdentifier)cqlIdentifier, factory.create(o));
        });
        return values;
    }

    public StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update(Query query2, Update update, CassandraPersistentEntity<?> persistentEntity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(persistentEntity, (String)"CassandraPersistentEntity must not be null");
        return this.update(query2, update, persistentEntity, persistentEntity.getTableName());
    }

    StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update(Query query2, Update update, CassandraPersistentEntity<?> persistentEntity, CqlIdentifier tableName) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(persistentEntity, (String)"CassandraPersistentEntity must not be null");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        Filter filter = this.getQueryMapper().getMappedObject(query2, persistentEntity);
        Update mappedUpdate = this.getUpdateMapper().getMappedObject(update, persistentEntity);
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> builder = StatementFactory.update(tableName, mappedUpdate, filter);
        query2.getQueryOptions().filter(UpdateOptions.class::isInstance).map(UpdateOptions.class::cast).map(UpdateOptions::getIfCondition).ifPresent(criteriaDefinitions -> StatementFactory.applyUpdateIfCondition(builder, criteriaDefinitions));
        query2.getQueryOptions().filter(WriteOptions.class::isInstance).map(WriteOptions.class::cast).ifPresent(writeOptions -> builder.apply(statement -> StatementFactory.addWriteOptions(statement, writeOptions)));
        query2.getQueryOptions().ifPresent(options -> builder.transform(statementBuilder -> QueryOptionsUtil.addQueryOptions(statementBuilder, options)));
        return builder;
    }

    public StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update(Object objectToUpdate, WriteOptions options) {
        Assert.notNull((Object)objectToUpdate, (String)"Object to builder must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.cassandraConverter.getMappingContext().getRequiredPersistentEntity(objectToUpdate.getClass());
        return this.update(objectToUpdate, options, persistentEntity, persistentEntity.getTableName());
    }

    StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update(Object objectToUpdate, WriteOptions options, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Assert.notNull((Object)tableName, (String)"TableName must not be null");
        Assert.notNull((Object)objectToUpdate, (String)"Object to builder must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        Where where = new Where();
        this.cassandraConverter.write(objectToUpdate, where, entity);
        LinkedHashMap object = new LinkedHashMap();
        this.cassandraConverter.write(objectToUpdate, object, entity);
        where.forEach((cqlIdentifier, o) -> object.remove(cqlIdentifier));
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> builder = StatementBuilder.of((BuildableQuery)QueryBuilder.update((CqlIdentifier)tableName).set(new Assignment[0]).where(new Relation[0])).bind((statement, factory) -> (com.datastax.oss.driver.api.querybuilder.update.Update)((UpdateWithAssignments)statement).set(StatementFactory.toAssignments(object, factory)).where(StatementFactory.toRelations(where, factory))).apply(update -> StatementFactory.addWriteOptions(update, options));
        Optional.of(options).filter(UpdateOptions.class::isInstance).map(UpdateOptions.class::cast).map(UpdateOptions::getIfCondition).ifPresent(criteriaDefinitions -> StatementFactory.applyUpdateIfCondition(builder, criteriaDefinitions));
        builder.transform(statement -> QueryOptionsUtil.addQueryOptions(statement, options));
        return builder;
    }

    StatementBuilder<Delete> deleteById(Object id, CassandraPersistentEntity<?> persistentEntity, CqlIdentifier tableName) {
        Where where = new Where();
        this.cassandraConverter.write(id, where, persistentEntity);
        return StatementBuilder.of((BuildableQuery)QueryBuilder.deleteFrom((CqlIdentifier)tableName).where(new Relation[0])).bind((statement, factory) -> (Delete)statement.where(StatementFactory.toRelations(where, factory)));
    }

    public StatementBuilder<Delete> delete(Query query2, CassandraPersistentEntity<?> persistentEntity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(persistentEntity, (String)"CassandraPersistentEntity must not be null");
        return this.delete(query2, persistentEntity, persistentEntity.getTableName());
    }

    public StatementBuilder<Delete> delete(Query query2, CassandraPersistentEntity<?> persistentEntity, CqlIdentifier tableName) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(persistentEntity, (String)"CassandraPersistentEntity must not be null");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        Filter filter = this.getQueryMapper().getMappedObject(query2, persistentEntity);
        List<CqlIdentifier> columnNames = this.getQueryMapper().getMappedColumnNames(query2.getColumns(), persistentEntity);
        StatementBuilder<Delete> builder = this.delete(columnNames, tableName, filter);
        query2.getQueryOptions().filter(DeleteOptions.class::isInstance).map(DeleteOptions.class::cast).map(DeleteOptions::getIfCondition).ifPresent(criteriaDefinitions -> StatementFactory.applyDeleteIfCondition(builder, criteriaDefinitions));
        query2.getQueryOptions().filter(WriteOptions.class::isInstance).map(WriteOptions.class::cast).ifPresent(writeOptions -> builder.apply(statement -> StatementFactory.addWriteOptions(statement, writeOptions)));
        query2.getQueryOptions().ifPresent(options -> builder.transform(statement -> QueryOptionsUtil.addQueryOptions(statement, options)));
        return builder;
    }

    StatementBuilder<Delete> delete(Object entity, QueryOptions options, EntityWriter<Object, Object> entityWriter, CqlIdentifier tableName) {
        Assert.notNull((Object)tableName, (String)"TableName must not be null");
        Assert.notNull((Object)entity, (String)"Object to builder must not be null");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Where where = new Where();
        entityWriter.write(entity, (Object)where);
        StatementBuilder<Delete> builder = StatementBuilder.of((BuildableQuery)QueryBuilder.deleteFrom((CqlIdentifier)tableName).where(new Relation[0])).bind((statement, factory) -> (Delete)statement.where(StatementFactory.toRelations(where, factory)));
        Optional.of(options).filter(WriteOptions.class::isInstance).map(WriteOptions.class::cast).ifPresent(it -> builder.apply(statement -> StatementFactory.addWriteOptions(statement, it)));
        Optional.of(options).filter(DeleteOptions.class::isInstance).map(DeleteOptions.class::cast).map(DeleteOptions::getIfCondition).ifPresent(criteriaDefinitions -> StatementFactory.applyDeleteIfCondition(builder, criteriaDefinitions));
        builder.transform(statement -> QueryOptionsUtil.addQueryOptions(statement, options));
        return builder;
    }

    Columns computeColumnsForProjection(Columns columns, PersistentEntity<?, ?> persistentEntity, Class<?> returnType) {
        Columns projectedColumns;
        block4: {
            block3: {
                if (!columns.isEmpty() || ClassUtils.isAssignable((Class)persistentEntity.getType(), returnType)) {
                    return columns;
                }
                projectedColumns = Columns.empty();
                if (!returnType.isInterface()) break block3;
                ProjectionInformation projectionInformation = this.projectionFactory.getProjectionInformation(returnType);
                if (!projectionInformation.isClosed()) break block4;
                for (PropertyDescriptor inputProperty : projectionInformation.getInputProperties()) {
                    projectedColumns = projectedColumns.include(inputProperty.getName());
                }
                break block4;
            }
            for (PersistentProperty property : persistentEntity) {
                projectedColumns = projectedColumns.include(property.getName());
            }
        }
        return projectedColumns;
    }

    private StatementBuilder<Select> createSelect(Query query2, CassandraPersistentEntity<?> entity, Filter filter, List<Columns.Selector> selectors, CqlIdentifier tableName) {
        Sort sort = Optional.of(query2.getSort()).map(querySort -> this.getQueryMapper().getMappedSort((Sort)querySort, entity)).orElse(Sort.unsorted());
        StatementBuilder<Select> select2 = StatementFactory.createSelectAndOrder(selectors, tableName, filter, sort);
        if (query2.getLimit() > 0L) {
            select2.apply(it -> it.limit(Math.toIntExact(query2.getLimit())));
        }
        if (query2.isAllowFiltering()) {
            select2.apply(Select::allowFiltering);
        }
        select2.onBuild(statementBuilder -> query2.getPagingState().ifPresent(arg_0 -> ((SimpleStatementBuilder)statementBuilder).setPagingState(arg_0)));
        query2.getQueryOptions().ifPresent(it -> select2.transform(statement -> QueryOptionsUtil.addQueryOptions(statement, it)));
        return select2;
    }

    private static StatementBuilder<Select> createSelectAndOrder(List<Columns.Selector> selectors, CqlIdentifier from, Filter filter, Sort sort) {
        Select select2;
        if (selectors.isEmpty()) {
            select2 = QueryBuilder.selectFrom((CqlIdentifier)from).all();
        } else {
            List mappedSelectors = selectors.stream().map(selector -> selector.getAlias().map(it -> StatementFactory.getSelection(selector).as(it)).orElseGet(() -> StatementFactory.getSelection(selector))).collect(Collectors.toList());
            select2 = QueryBuilder.selectFrom((CqlIdentifier)from).selectors(mappedSelectors);
        }
        StatementBuilder<Select> builder = StatementBuilder.of(select2);
        builder.bind((statement, factory) -> (Select)statement.where((Iterable)filter.stream().map(it -> StatementFactory.toClause(it, factory)).collect(Collectors.toList())));
        if (sort.isSorted()) {
            builder.apply(statement -> {
                Map<String, ClusteringOrder> ordering = sort.stream().collect(Collectors.toMap(Sort.Order::getProperty, order -> order.isAscending() ? ClusteringOrder.ASC : ClusteringOrder.DESC));
                return statement.orderBy(ordering);
            });
        }
        return builder;
    }

    private static Selector getSelection(Columns.Selector selector) {
        if (selector instanceof Columns.FunctionCall) {
            Selector[] arguments = (Selector[])((Columns.FunctionCall)selector).getParameters().stream().map(param -> {
                if (param instanceof Columns.ColumnSelector) {
                    return Selector.column((String)((Columns.ColumnSelector)param).getExpression());
                }
                return new SimpleSelector(param.toString());
            }).toArray(Selector[]::new);
            return Selector.function((String)selector.getExpression(), (Selector[])arguments);
        }
        return Selector.column((CqlIdentifier)CqlIdentifier.fromInternal((String)selector.getExpression()));
    }

    private static StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update(CqlIdentifier table, Update mappedUpdate, Filter filter) {
        UpdateStart updateStart = QueryBuilder.update((CqlIdentifier)table);
        return StatementBuilder.of((com.datastax.oss.driver.api.querybuilder.update.Update)updateStart).bind((statement, factory) -> {
            List assignments = mappedUpdate.getUpdateOperations().stream().map(assignmentOp -> StatementFactory.getAssignment(assignmentOp, factory)).collect(Collectors.toList());
            return (com.datastax.oss.driver.api.querybuilder.update.Update)((OngoingAssignment)statement).set(assignments);
        }).bind((statement, factory) -> {
            List relations = filter.stream().map(criteriaDefinition -> StatementFactory.toClause(criteriaDefinition, factory)).collect(Collectors.toList());
            return (com.datastax.oss.driver.api.querybuilder.update.Update)statement.where(relations);
        });
    }

    static Iterable<Relation> toRelations(Where where, TermFactory factory) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        where.forEach((cqlIdentifier, termValue) -> relations.add((Relation)Relation.column((CqlIdentifier)cqlIdentifier).isEqualTo(factory.create(termValue))));
        return relations;
    }

    static Iterable<Assignment> toAssignments(Map<CqlIdentifier, Object> object, TermFactory factory) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        object.forEach((cqlIdentifier, termValue) -> assignments.add(Assignment.setColumn((CqlIdentifier)cqlIdentifier, (Term)factory.create(termValue))));
        return assignments;
    }

    private static void applyUpdateIfCondition(StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update, Filter criteriaDefinitions) {
        update.bind((statement, factory) -> {
            List conditions = criteriaDefinitions.stream().map(it -> StatementFactory.toCondition(it, factory)).collect(Collectors.toList());
            return (com.datastax.oss.driver.api.querybuilder.update.Update)statement.if_(conditions);
        });
    }

    private static void applyDeleteIfCondition(StatementBuilder<Delete> delete, Filter criteriaDefinitions) {
        delete.bind((statement, factory) -> {
            List conditions = criteriaDefinitions.stream().map(it -> StatementFactory.toCondition(it, factory)).collect(Collectors.toList());
            return (Delete)statement.if_(conditions);
        });
    }

    private static Assignment getAssignment(Update.AssignmentOp assignmentOp, TermFactory termFactory) {
        if (assignmentOp instanceof Update.SetOp) {
            return StatementFactory.getAssignment((Update.SetOp)assignmentOp, termFactory);
        }
        if (assignmentOp instanceof Update.RemoveOp) {
            return StatementFactory.getAssignment((Update.RemoveOp)assignmentOp, termFactory);
        }
        if (assignmentOp instanceof Update.IncrOp) {
            return StatementFactory.getAssignment((Update.IncrOp)assignmentOp, termFactory);
        }
        if (assignmentOp instanceof Update.AddToOp) {
            return StatementFactory.getAssignment((Update.AddToOp)assignmentOp, termFactory);
        }
        if (assignmentOp instanceof Update.AddToMapOp) {
            return StatementFactory.getAssignment((Update.AddToMapOp)assignmentOp, termFactory);
        }
        throw new IllegalArgumentException(String.format("UpdateOp %s not supported", assignmentOp));
    }

    private static Assignment getAssignment(Update.IncrOp incrOp, TermFactory termFactory) {
        return incrOp.getValue().longValue() > 0L ? Assignment.increment((CqlIdentifier)incrOp.toCqlIdentifier(), (Term)termFactory.create(Math.abs(incrOp.getValue().longValue()))) : Assignment.decrement((CqlIdentifier)incrOp.toCqlIdentifier(), (Term)termFactory.create(Math.abs(incrOp.getValue().longValue())));
    }

    private static Assignment getAssignment(Update.SetOp updateOp, TermFactory termFactory) {
        if (updateOp instanceof Update.SetAtIndexOp) {
            return Assignment.setListValue((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(((Update.SetAtIndexOp)updateOp).getIndex()), (Term)termFactory.create(updateOp.getValue()));
        }
        if (updateOp instanceof Update.SetAtKeyOp) {
            Update.SetAtKeyOp op = (Update.SetAtKeyOp)updateOp;
            return Assignment.setMapValue((CqlIdentifier)op.toCqlIdentifier(), (Term)termFactory.create(op.getKey()), (Term)termFactory.create(op.getValue()));
        }
        return Assignment.setColumn((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(updateOp.getValue()));
    }

    private static Assignment getAssignment(Update.RemoveOp updateOp, TermFactory termFactory) {
        if (updateOp.getValue() instanceof Set) {
            Collection collection = (Collection)updateOp.getValue();
            Assert.isTrue((collection.size() == 1 ? 1 : 0) != 0, (String)"RemoveOp must contain a single set element");
            return Assignment.removeSetElement((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(collection.iterator().next()));
        }
        if (updateOp.getValue() instanceof List) {
            Collection collection = (Collection)updateOp.getValue();
            Assert.isTrue((collection.size() == 1 ? 1 : 0) != 0, (String)"RemoveOp must contain a single list element");
            return Assignment.removeListElement((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(collection.iterator().next()));
        }
        return Assignment.remove((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(updateOp.getValue()));
    }

    private static Assignment getAssignment(Update.AddToOp updateOp, TermFactory termFactory) {
        if (updateOp.getValue() instanceof Set) {
            return Assignment.append((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(updateOp.getValue()));
        }
        return Update.AddToOp.Mode.PREPEND.equals((Object)updateOp.getMode()) ? Assignment.prepend((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(updateOp.getValue())) : Assignment.append((String)updateOp.getColumnName().toCql(), (Term)termFactory.create(updateOp.getValue()));
    }

    private static Assignment getAssignment(Update.AddToMapOp updateOp, TermFactory termFactory) {
        return Assignment.append((CqlIdentifier)updateOp.toCqlIdentifier(), (Term)termFactory.create(updateOp.getValue()));
    }

    private StatementBuilder<Delete> delete(List<CqlIdentifier> columnNames, CqlIdentifier from, Filter filter) {
        DeleteSelection select2 = QueryBuilder.deleteFrom((CqlIdentifier)from);
        for (CqlIdentifier columnName : columnNames) {
            select2 = select2.column(columnName);
        }
        return StatementBuilder.of((BuildableQuery)select2.where(new Relation[0])).bind((statement, factory) -> {
            List relations = filter.stream().map(criteriaDefinition -> StatementFactory.toClause(criteriaDefinition, factory)).collect(Collectors.toList());
            return (Delete)statement.where(relations);
        });
    }

    static Insert addWriteOptions(Insert insert, WriteOptions writeOptions) {
        InsertOptions insertOptions;
        Assert.notNull((Object)insert, (String)"Insert must not be null");
        if (writeOptions instanceof InsertOptions && (insertOptions = (InsertOptions)writeOptions).isIfNotExists()) {
            insert = insert.ifNotExists();
        }
        return QueryOptionsUtil.addWriteOptions(insert, writeOptions);
    }

    static com.datastax.oss.driver.api.querybuilder.update.Update addWriteOptions(com.datastax.oss.driver.api.querybuilder.update.Update update, WriteOptions writeOptions) {
        UpdateOptions updateOptions;
        Assert.notNull((Object)update, (String)"Update must not be null");
        com.datastax.oss.driver.api.querybuilder.update.Update updateToUse = QueryOptionsUtil.addWriteOptions(update, writeOptions);
        if (writeOptions instanceof UpdateOptions && (updateOptions = (UpdateOptions)writeOptions).isIfExists()) {
            updateToUse = (com.datastax.oss.driver.api.querybuilder.update.Update)updateToUse.ifExists();
        }
        return updateToUse;
    }

    static Delete addWriteOptions(Delete delete, WriteOptions writeOptions) {
        DeleteOptions deleteOptions;
        Assert.notNull((Object)delete, (String)"Delete must not be null");
        Delete deleteToUse = QueryOptionsUtil.addWriteOptions(delete, writeOptions);
        if (writeOptions instanceof DeleteOptions && (deleteOptions = (DeleteOptions)writeOptions).isIfExists()) {
            deleteToUse = (Delete)((Delete)deleteToUse.where(new Relation[0])).ifExists();
        }
        return deleteToUse;
    }

    private static Relation toClause(CriteriaDefinition criteriaDefinition, TermFactory factory) {
        CqlIdentifier columnName = criteriaDefinition.getColumnName().getCqlIdentifier().orElseGet(() -> CqlIdentifier.fromInternal((String)criteriaDefinition.getColumnName().toCql()));
        CriteriaDefinition.Predicate predicate = criteriaDefinition.getPredicate();
        CriteriaDefinition.Operators predicateOperator = CriteriaDefinition.Operators.from(predicate.getOperator().toString()).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown operator [%s]", predicate.getOperator())));
        ColumnRelationBuilder column = Relation.column((CqlIdentifier)columnName);
        switch (predicateOperator) {
            case EQ: {
                return (Relation)column.isEqualTo(factory.create(predicate.getValue()));
            }
            case NE: {
                return (Relation)column.isNotEqualTo(factory.create(predicate.getValue()));
            }
            case GT: {
                return (Relation)column.isGreaterThan(factory.create(predicate.getValue()));
            }
            case GTE: {
                return (Relation)column.isGreaterThanOrEqualTo(factory.create(predicate.getValue()));
            }
            case LT: {
                return (Relation)column.isLessThan(factory.create(predicate.getValue()));
            }
            case LTE: {
                return (Relation)column.isLessThanOrEqualTo(factory.create(predicate.getValue()));
            }
            case IN: {
                if (predicate.getValue() instanceof List) {
                    List literals = ((List)predicate.getValue()).stream().map(QueryBuilder::literal).collect(Collectors.toList());
                    return (Relation)column.in(literals);
                }
                if (predicate.getValue() != null && predicate.getValue().getClass().isArray()) {
                    List literals = Arrays.stream((Object[])predicate.getValue()).map(QueryBuilder::literal).collect(Collectors.toList());
                    return (Relation)column.in(literals);
                }
                return (Relation)column.in(new Term[]{factory.create(predicate.getValue())});
            }
            case LIKE: {
                return (Relation)column.like(factory.create(predicate.getValue()));
            }
            case IS_NOT_NULL: {
                return (Relation)column.isNotNull();
            }
            case CONTAINS: {
                Assert.state((predicate.getValue() != null ? 1 : 0) != 0, () -> String.format("CONTAINS value for column %s is null", columnName));
                return (Relation)column.contains(factory.create(predicate.getValue()));
            }
            case CONTAINS_KEY: {
                Assert.state((predicate.getValue() != null ? 1 : 0) != 0, () -> String.format("CONTAINS KEY value for column %s is null", columnName));
                return (Relation)column.containsKey(factory.create(predicate.getValue()));
            }
        }
        throw new IllegalArgumentException(String.format("Criteria %s %s %s not supported", columnName, predicate.getOperator(), predicate.getValue()));
    }

    private static Condition toCondition(CriteriaDefinition criteriaDefinition, TermFactory factory) {
        String columnName = criteriaDefinition.getColumnName().toCql();
        CriteriaDefinition.Predicate predicate = criteriaDefinition.getPredicate();
        CriteriaDefinition.Operators predicateOperator = CriteriaDefinition.Operators.from(predicate.getOperator().toString()).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown operator [%s]", predicate.getOperator())));
        ConditionBuilder column = Condition.column((String)columnName);
        switch (predicateOperator) {
            case EQ: {
                return (Condition)column.isEqualTo(factory.create(predicate.getValue()));
            }
            case NE: {
                return (Condition)column.isNotEqualTo(factory.create(predicate.getValue()));
            }
            case GT: {
                return (Condition)column.isGreaterThan(factory.create(predicate.getValue()));
            }
            case GTE: {
                return (Condition)column.isGreaterThanOrEqualTo(factory.create(predicate.getValue()));
            }
            case LT: {
                return (Condition)column.isLessThan(factory.create(predicate.getValue()));
            }
            case LTE: {
                return (Condition)column.isLessThanOrEqualTo(factory.create(predicate.getValue()));
            }
            case IN: {
                if (predicate.getValue() instanceof List) {
                    List literals = ((List)predicate.getValue()).stream().map(QueryBuilder::literal).collect(Collectors.toList());
                    return (Condition)column.in(literals);
                }
                if (predicate.getValue() != null && predicate.getValue().getClass().isArray()) {
                    List literals = Arrays.stream((Object[])predicate.getValue()).map(QueryBuilder::literal).collect(Collectors.toList());
                    return (Condition)column.in(literals);
                }
                return (Condition)column.in(new Term[]{factory.create(predicate.getValue())});
            }
        }
        throw new IllegalArgumentException(String.format("Criteria %s %s %s not supported for IF Conditions", columnName, predicate.getOperator(), predicate.getValue()));
    }

    static class SimpleSelector
    implements Selector {
        private final String selector;

        SimpleSelector(String selector) {
            this.selector = selector;
        }

        @NonNull
        public Selector as(@NonNull CqlIdentifier alias) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public CqlIdentifier getAlias() {
            return null;
        }

        public void appendTo(@NonNull StringBuilder builder) {
            builder.append(this.selector);
        }
    }
}

