/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.truncate.Truncate;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.AsyncCassandraOperations;
import org.springframework.data.cassandra.core.EntityOperations;
import org.springframework.data.cassandra.core.EntityQueryUtils;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.cql.AsyncCqlOperations;
import org.springframework.data.cassandra.core.cql.AsyncCqlTemplate;
import org.springframework.data.cassandra.core.cql.AsyncSessionCallback;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlExceptionTranslator;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.data.cassandra.core.cql.util.CassandraFutureAdapter;
import org.springframework.data.cassandra.core.cql.util.StatementBuilder;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.event.AfterConvertEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterLoadEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.cassandra.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.CassandraMappingEvent;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Slice;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureAdapter;

public class AsyncCassandraTemplate
implements AsyncCassandraOperations,
ApplicationEventPublisherAware,
ApplicationContextAware {
    private final AsyncCqlOperations cqlOperations;
    private final CassandraConverter converter;
    private final CqlExceptionTranslator exceptionTranslator;
    private final EntityOperations entityOperations;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    private final StatementFactory statementFactory;
    @Nullable
    private ApplicationEventPublisher eventPublisher;
    @Nullable
    private EntityCallbacks entityCallbacks;

    public AsyncCassandraTemplate(CqlSession session) {
        this(session, (CassandraConverter)AsyncCassandraTemplate.newConverter());
    }

    public AsyncCassandraTemplate(CqlSession session, CassandraConverter converter) {
        this(new DefaultSessionFactory(session), converter);
    }

    public AsyncCassandraTemplate(SessionFactory sessionFactory, CassandraConverter converter) {
        this(new AsyncCqlTemplate(sessionFactory), converter);
    }

    public AsyncCassandraTemplate(AsyncCqlTemplate asyncCqlTemplate, CassandraConverter converter) {
        Assert.notNull((Object)asyncCqlTemplate, (String)"AsyncCqlTemplate must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.cqlOperations = asyncCqlTemplate;
        this.entityOperations = new EntityOperations((MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)converter.getMappingContext());
        this.exceptionTranslator = asyncCqlTemplate.getExceptionTranslator();
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.statementFactory = new StatementFactory(converter);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
        this.projectionFactory.setBeanFactory((BeanFactory)applicationContext);
        this.projectionFactory.setBeanClassLoader(applicationContext.getClassLoader());
    }

    public void setEntityCallbacks(@Nullable EntityCallbacks entityCallbacks) {
        this.entityCallbacks = entityCallbacks;
    }

    @Override
    public AsyncCqlOperations getAsyncCqlOperations() {
        return this.cqlOperations;
    }

    @Override
    public CassandraConverter getConverter() {
        return this.converter;
    }

    protected EntityOperations getEntityOperations() {
        return this.entityOperations;
    }

    protected SpelAwareProxyProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    private CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityType) {
        return this.getEntityOperations().getRequiredPersistentEntity(entityType);
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    private CqlIdentifier getTableName(Class<?> entityClass) {
        return this.getEntityOperations().getTableName(entityClass);
    }

    @Override
    public <T> ListenableFuture<List<T>> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return this.select((Statement<?>)SimpleStatement.newInstance((String)cql), entityClass);
    }

    @Override
    public <T> ListenableFuture<Void> select(String cql, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement<?>)SimpleStatement.newInstance((String)cql), entityConsumer, entityClass);
    }

    @Override
    public <T> ListenableFuture<T> selectOne(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement<?>)SimpleStatement.newInstance((String)cql), entityClass);
    }

    @Override
    public <T> ListenableFuture<List<T>> select(Statement<?> statement, Class<T> entityClass) {
        Assert.notNull(statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement));
        return this.getAsyncCqlOperations().query(statement, (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> ListenableFuture<Void> select(Statement<?> statement, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.notNull(statement, (String)"Statement must not be null");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement));
        return this.getAsyncCqlOperations().query(statement, row -> entityConsumer.accept(mapper.apply(row)));
    }

    @Override
    public <T> ListenableFuture<T> selectOne(Statement<?> statement, Class<T> entityClass) {
        return new MappingListenableFutureAdapter<Object, List>(this.select(statement, entityClass), list -> list.isEmpty() ? null : list.get(0));
    }

    @Override
    public <T> ListenableFuture<Slice<T>> slice(Statement<?> statement, Class<T> entityClass) {
        Assert.notNull(statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        ListenableFuture<AsyncResultSet> resultSet = this.getAsyncCqlOperations().queryForResultSet(statement);
        Function mapper = this.getMapper(entityClass, entityClass, EntityQueryUtils.getTableName(statement));
        return new MappingListenableFutureAdapter<Slice, AsyncResultSet>(resultSet, rs -> EntityQueryUtils.readSlice(rs, (row, rowNum) -> mapper.apply(row), 0, this.getEffectivePageSize(statement)));
    }

    @Override
    public <T> ListenableFuture<List<T>> select(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement<?>)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)).build(), entityClass);
    }

    @Override
    public <T> ListenableFuture<Void> select(Query query2, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement<?>)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)).build(), entityConsumer, entityClass);
    }

    @Override
    public <T> ListenableFuture<T> selectOne(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement<?>)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)).build(), entityClass);
    }

    @Override
    public <T> ListenableFuture<Slice<T>> slice(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.slice((Statement<?>)this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass)).build(), entityClass);
    }

    @Override
    public ListenableFuture<Boolean> update(Query query2, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getAsyncCqlOperations().execute((Statement<?>)this.getStatementFactory().update(query2, update, this.getRequiredPersistentEntity(entityClass)).build());
    }

    @Override
    public ListenableFuture<Boolean> delete(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doDelete(query2, entityClass, this.getTableName(entityClass));
    }

    private ListenableFuture<Boolean> doDelete(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        StatementBuilder<Delete> builder = this.getStatementFactory().delete(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        SimpleStatement delete = builder.build();
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement<?>)delete, entityClass, tableName));
        ListenableFuture<Boolean> future = this.getAsyncCqlOperations().execute((Statement<?>)delete);
        future.addCallback(success -> this.maybeEmitEvent(new AfterDeleteEvent((Statement<?>)delete, entityClass, tableName)), e -> {});
        return future;
    }

    @Override
    public ListenableFuture<Long> count(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doCount(Query.empty(), entityClass, this.getTableName(entityClass));
    }

    @Override
    public ListenableFuture<Long> count(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doCount(query2, entityClass, this.getTableName(entityClass));
    }

    ListenableFuture<Long> doCount(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        StatementBuilder<Select> countStatement = this.getStatementFactory().count(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        SimpleStatement statement = countStatement.build();
        ListenableFuture<Long> result = this.getAsyncCqlOperations().queryForObject((Statement<?>)statement, Long.class);
        return new MappingListenableFutureAdapter<Long, Long>(result, it -> it != null ? it : 0L);
    }

    @Override
    public ListenableFuture<Boolean> exists(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        StatementBuilder<Select> select2 = this.getStatementFactory().selectOneById(id, entity, entity.getTableName());
        return new MappingListenableFutureAdapter<Boolean, AsyncResultSet>(this.getAsyncCqlOperations().queryForResultSet((Statement<?>)select2.build()), resultSet -> resultSet.one() != null);
    }

    @Override
    public ListenableFuture<Boolean> exists(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        StatementBuilder<Select> select2 = this.getStatementFactory().select(query2.limit(1L), this.getRequiredPersistentEntity(entityClass), this.getTableName(entityClass));
        return new MappingListenableFutureAdapter<Boolean, AsyncResultSet>(this.getAsyncCqlOperations().queryForResultSet((Statement<?>)select2.build()), resultSet -> resultSet.one() != null);
    }

    @Override
    public <T> ListenableFuture<T> selectOneById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        StatementBuilder<Select> select2 = this.getStatementFactory().selectOneById(id, entity, tableName);
        Function mapper = this.getMapper(entityClass, entityClass, tableName);
        return new MappingListenableFutureAdapter<Object, List>(this.getAsyncCqlOperations().query((Statement<?>)select2.build(), (row, rowNum) -> mapper.apply(row)), it -> it.isEmpty() ? null : it.get(0));
    }

    @Override
    public <T> ListenableFuture<T> insert(T entity) {
        return new MappingListenableFutureAdapter<Object, EntityWriteResult>(this.insert(entity, InsertOptions.empty()), EntityWriteResult::getEntity);
    }

    @Override
    public <T> ListenableFuture<EntityWriteResult<T>> insert(T entity, InsertOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"InsertOptions must not be null");
        return this.doInsert(entity, options, this.getTableName(entity.getClass()));
    }

    private <T> ListenableFuture<EntityWriteResult<T>> doInsert(T entity, WriteOptions options, CqlIdentifier tableName) {
        EntityOperations.AdaptibleEntity<T> source = this.getEntityOperations().forEntity(this.maybeCallBeforeConvert(entity, tableName), this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        T entityToUse = source.isVersionedEntity() ? source.initializeVersionProperty() : entity;
        StatementBuilder<RegularInsert> builder = this.getStatementFactory().insert(entityToUse, options, persistentEntity, tableName);
        if (source.isVersionedEntity()) {
            builder.apply(Insert::ifNotExists);
            return this.doInsertVersioned(builder.build(), entityToUse, source, tableName);
        }
        return this.doInsert(builder.build(), entityToUse, source, tableName);
    }

    private <T> ListenableFuture<EntityWriteResult<T>> doInsertVersioned(SimpleStatement insert, T entity, EntityOperations.AdaptibleEntity<T> source, CqlIdentifier tableName) {
        return this.executeSave(entity, tableName, insert, result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot insert entity %s with version %s into table %s as it already exists", entity, source.getVersion(), tableName));
            }
        });
    }

    private <T> ListenableFuture<EntityWriteResult<T>> doInsert(SimpleStatement insert, T entity, EntityOperations.AdaptibleEntity<T> source, CqlIdentifier tableName) {
        return this.executeSave(entity, tableName, insert);
    }

    @Override
    public <T> ListenableFuture<T> update(T entity) {
        return new MappingListenableFutureAdapter<Object, EntityWriteResult>(this.update(entity, UpdateOptions.empty()), EntityWriteResult::getEntity);
    }

    @Override
    public <T> ListenableFuture<EntityWriteResult<T>> update(T entity, UpdateOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"UpdateOptions must not be null");
        EntityOperations.AdaptibleEntity<T> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        T entityToUpdate = this.maybeCallBeforeConvert(entity, tableName);
        return source.isVersionedEntity() ? this.doUpdateVersioned(entityToUpdate, options, tableName, persistentEntity) : this.doUpdate(entityToUpdate, options, tableName, persistentEntity);
    }

    private <T> ListenableFuture<EntityWriteResult<T>> doUpdateVersioned(T entity, UpdateOptions options, CqlIdentifier tableName, CassandraPersistentEntity<?> persistentEntity) {
        EntityOperations.AdaptibleEntity source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        Number previousVersion = source.getVersion();
        Object toSave = source.incrementVersion();
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update = this.getStatementFactory().update(toSave, options, persistentEntity, tableName);
        source.appendVersionCondition(update, previousVersion);
        return this.executeSave(toSave, tableName, update.build(), result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot save entity %s with version %s to table %s. Has it been modified meanwhile?", toSave, source.getVersion(), tableName));
            }
        });
    }

    private <T> ListenableFuture<EntityWriteResult<T>> doUpdate(T entity, UpdateOptions options, CqlIdentifier tableName, CassandraPersistentEntity<?> persistentEntity) {
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> update = this.getStatementFactory().update(entity, options, persistentEntity, tableName);
        return this.executeSave(entity, tableName, update.build());
    }

    @Override
    public <T> ListenableFuture<T> delete(T entity) {
        return new MappingListenableFutureAdapter<Object, WriteResult>(this.delete(entity, QueryOptions.empty()), writeResult -> entity);
    }

    @Override
    public ListenableFuture<WriteResult> delete(Object entity, QueryOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        EntityOperations.AdaptibleEntity<Object> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        return source.isVersionedEntity() ? this.doDeleteVersioned(entity, options, source, tableName) : this.doDelete(entity, options, tableName);
    }

    private ListenableFuture<WriteResult> doDeleteVersioned(Object entity, QueryOptions options, EntityOperations.AdaptibleEntity<Object> source, CqlIdentifier tableName) {
        StatementBuilder<Delete> delete = this.getStatementFactory().delete(entity, options, (EntityWriter<Object, Object>)this.getConverter(), tableName);
        return this.executeDelete(entity, tableName, source.appendVersionCondition(delete).build(), result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot delete entity %s with version %s in table %s. Has it been modified meanwhile?", entity, source.getVersion(), tableName));
            }
        });
    }

    private ListenableFuture<WriteResult> doDelete(Object entity, QueryOptions options, CqlIdentifier tableName) {
        StatementBuilder<Delete> delete = this.getStatementFactory().delete(entity, options, (EntityWriter<Object, Object>)this.getConverter(), tableName);
        return this.executeDelete(entity, tableName, delete.build(), result -> {});
    }

    @Override
    public ListenableFuture<Boolean> deleteById(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        StatementBuilder<Delete> builder = this.getStatementFactory().deleteById(id, entity, tableName);
        SimpleStatement delete = builder.build();
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement<?>)delete, entityClass, tableName));
        ListenableFuture<Boolean> future = this.getAsyncCqlOperations().execute((Statement<?>)delete);
        future.addCallback(success -> this.maybeEmitEvent(new AfterDeleteEvent((Statement<?>)delete, entityClass, tableName)), e -> {});
        return future;
    }

    @Override
    public ListenableFuture<Void> truncate(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CqlIdentifier tableName = this.getTableName(entityClass);
        Truncate truncate = QueryBuilder.truncate((CqlIdentifier)tableName);
        SimpleStatement statement = truncate.build();
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement<?>)statement, entityClass, tableName));
        ListenableFuture<Boolean> future = this.getAsyncCqlOperations().execute((Statement<?>)statement);
        future.addCallback(success -> this.maybeEmitEvent(new AfterDeleteEvent((Statement<?>)statement, entityClass, tableName)), e -> {});
        return new MappingListenableFutureAdapter<Void, Boolean>(future, aBoolean -> null);
    }

    private <T> ListenableFuture<EntityWriteResult<T>> executeSave(T entity, CqlIdentifier tableName, SimpleStatement statement) {
        return this.executeSave(entity, tableName, statement, ignore -> {});
    }

    private <T> ListenableFuture<EntityWriteResult<T>> executeSave(T entity, CqlIdentifier tableName, SimpleStatement statement, Consumer<WriteResult> beforeAfterSaveEvent) {
        this.maybeEmitEvent(new BeforeSaveEvent<T>(entity, tableName, (Statement<?>)statement));
        Object entityToSave = this.maybeCallBeforeSave(entity, tableName, (Statement<?>)statement);
        ListenableFuture<AsyncResultSet> result = this.getAsyncCqlOperations().execute(new AsyncStatementCallback(statement));
        return new MappingListenableFutureAdapter<EntityWriteResult, AsyncResultSet>(result, resultSet -> {
            EntityWriteResult<Object> writeResult = new EntityWriteResult<Object>(Collections.singletonList(resultSet.getExecutionInfo()), resultSet.wasApplied(), AsyncCassandraTemplate.getFirstPage(resultSet), entityToSave);
            beforeAfterSaveEvent.accept(writeResult);
            this.maybeEmitEvent(new AfterSaveEvent<Object>(entityToSave, tableName));
            return writeResult;
        });
    }

    private ListenableFuture<WriteResult> executeDelete(Object entity, CqlIdentifier tableName, SimpleStatement statement, Consumer<WriteResult> resultConsumer) {
        this.maybeEmitEvent(new BeforeDeleteEvent((Statement<?>)statement, entity.getClass(), tableName));
        ListenableFuture<AsyncResultSet> result = this.getAsyncCqlOperations().execute(new AsyncStatementCallback(statement));
        return new MappingListenableFutureAdapter<WriteResult, AsyncResultSet>(result, resultSet -> {
            WriteResult writeResult = new WriteResult(Collections.singletonList(resultSet.getExecutionInfo()), resultSet.wasApplied(), AsyncCassandraTemplate.getFirstPage(resultSet));
            resultConsumer.accept(writeResult);
            this.maybeEmitEvent(new AfterDeleteEvent((Statement<?>)statement, entity.getClass(), tableName));
            return writeResult;
        });
    }

    private static List<Row> getFirstPage(AsyncResultSet resultSet) {
        return StreamSupport.stream(resultSet.currentPage().spliterator(), false).collect(Collectors.toList());
    }

    private static int getConfiguredPageSize(CqlSession session) {
        return session.getContext().getConfig().getDefaultProfile().getInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, 5000);
    }

    private int getEffectivePageSize(Statement<?> statement) {
        CassandraAccessor accessor;
        if (statement.getPageSize() > 0) {
            return statement.getPageSize();
        }
        if (this.getAsyncCqlOperations() instanceof CassandraAccessor && (accessor = (CassandraAccessor)((Object)this.getAsyncCqlOperations())).getFetchSize() != -1) {
            return accessor.getFetchSize();
        }
        return (Integer)this.getAsyncCqlOperations().execute(session -> AsyncResult.forValue((Object)AsyncCassandraTemplate.getConfiguredPageSize(session))).completable().join();
    }

    private <T> Function<Row, T> getMapper(Class<?> entityType, Class<T> targetType, CqlIdentifier tableName) {
        Class<?> typeToRead = this.resolveTypeToRead(entityType, targetType);
        return row -> {
            Object result;
            this.maybeEmitEvent(new AfterLoadEvent((Row)row, targetType, tableName));
            Object source = this.getConverter().read(typeToRead, row);
            Object object = result = targetType.isInterface() ? this.getProjectionFactory().createProjection(targetType, source) : source;
            if (result != null) {
                this.maybeEmitEvent(new AfterConvertEvent<Object>((Row)row, result, tableName));
            }
            return result;
        };
    }

    private Class<?> resolveTypeToRead(Class<?> entityType, Class<?> targetType) {
        return targetType.isInterface() || targetType.isAssignableFrom(entityType) ? entityType : targetType;
    }

    private static MappingCassandraConverter newConverter() {
        MappingCassandraConverter converter = new MappingCassandraConverter();
        converter.afterPropertiesSet();
        return converter;
    }

    protected <E extends CassandraMappingEvent<T>, T> void maybeEmitEvent(E event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    protected <T> T maybeCallBeforeConvert(T object, CqlIdentifier tableName) {
        if (null != this.entityCallbacks) {
            return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, object, new Object[]{tableName});
        }
        return object;
    }

    protected <T> T maybeCallBeforeSave(T object, CqlIdentifier tableName, Statement<?> statement) {
        if (null != this.entityCallbacks) {
            return (T)this.entityCallbacks.callback(BeforeSaveCallback.class, object, new Object[]{tableName, statement});
        }
        return object;
    }

    class AsyncStatementCallback
    implements AsyncSessionCallback<AsyncResultSet>,
    CqlProvider {
        SimpleStatement statement;

        AsyncStatementCallback(SimpleStatement statement) {
            this.statement = statement;
        }

        @Override
        public ListenableFuture<AsyncResultSet> doInSession(CqlSession session) throws DriverException, DataAccessException {
            return new CassandraFutureAdapter<AsyncResultSet>(session.executeAsync((Statement)this.statement), e -> e instanceof DriverException ? AsyncCassandraTemplate.this.exceptionTranslator.translate("AsyncStatementCallback", this.getCql(), e) : AsyncCassandraTemplate.this.exceptionTranslator.translateExceptionIfPossible(e));
        }

        @Override
        public String getCql() {
            return this.statement.getQuery();
        }
    }

    static class MappingListenableFutureAdapter<T, S>
    extends ListenableFutureAdapter<T, S> {
        private final Function<S, T> mapper;

        MappingListenableFutureAdapter(ListenableFuture<S> adaptee, Function<S, T> mapper) {
            super(adaptee);
            this.mapper = mapper;
        }

        protected T adapt(@Nullable S adapteeResult) {
            return this.mapper.apply(adapteeResult);
        }
    }
}

