/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class ExpressionEvaluatingParameterBinder {
    private final SpelExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    ExpressionEvaluatingParameterBinder(SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)expressionParser, (String)"ExpressionParser must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null");
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public List<Object> bind(CassandraParameterAccessor parameterAccessor, BindingContext bindingContext) {
        if (!bindingContext.hasBindings()) {
            return Collections.emptyList();
        }
        ArrayList<Object> parameters = new ArrayList<Object>(bindingContext.getBindings().size());
        bindingContext.getBindings().stream().map(binding -> this.getParameterValueForBinding(parameterAccessor, bindingContext.getParameters(), (ParameterBinding)binding)).forEach(parameters::add);
        return parameters;
    }

    @Nullable
    private Object getParameterValueForBinding(CassandraParameterAccessor parameterAccessor, CassandraParameters parameters, ParameterBinding binding) {
        if (binding.isExpression()) {
            return this.evaluateExpression(binding.getExpression(), parameters, parameterAccessor.getValues());
        }
        return binding.isNamed() ? parameterAccessor.getBindableValue(this.getParameterIndex(parameters, binding.getParameterName())) : parameterAccessor.getBindableValue(binding.getParameterIndex());
    }

    private int getParameterIndex(CassandraParameters parameters, String parameterName) {
        return parameters.stream().filter(cassandraParameter -> cassandraParameter.getName().filter(s -> s.equals(parameterName)).isPresent()).mapToInt(Parameter::getIndex).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid parameter name; Cannot resolve parameter [%s]", parameterName)));
    }

    @Nullable
    private Object evaluateExpression(String expressionString, CassandraParameters parameters, Object[] parameterValues) {
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext((Parameters)parameters, parameterValues);
        Expression expression = this.expressionParser.parseExpression(expressionString);
        return expression.getValue(evaluationContext, Object.class);
    }

    static class ParameterBinding {
        private final boolean quoted;
        private final int parameterIndex;
        @Nullable
        private final String expression;
        @Nullable
        private final String parameterName;

        private ParameterBinding(int parameterIndex, boolean quoted, @Nullable String expression, @Nullable String parameterName) {
            this.parameterIndex = parameterIndex;
            this.quoted = quoted;
            this.expression = expression;
            this.parameterName = parameterName;
        }

        static ParameterBinding expression(String expression, boolean quoted) {
            return new ParameterBinding(-1, quoted, expression, null);
        }

        static ParameterBinding indexed(int parameterIndex) {
            return new ParameterBinding(parameterIndex, false, null, null);
        }

        static ParameterBinding named(String name) {
            return new ParameterBinding(-1, false, null, name);
        }

        boolean isNamed() {
            return this.parameterName != null;
        }

        int getParameterIndex() {
            return this.parameterIndex;
        }

        String getParameter() {
            return "?" + (this.isExpression() ? "expr" : "") + this.parameterIndex;
        }

        @Nullable
        String getExpression() {
            return this.expression;
        }

        boolean isExpression() {
            return this.expression != null;
        }

        @Nullable
        String getParameterName() {
            return this.parameterName;
        }
    }

    static class BindingContext {
        final CassandraQueryMethod queryMethod;
        final List<ParameterBinding> bindings;

        public BindingContext(CassandraQueryMethod queryMethod, List<ParameterBinding> bindings) {
            this.queryMethod = queryMethod;
            this.bindings = bindings;
        }

        boolean hasBindings() {
            return !CollectionUtils.isEmpty(this.bindings);
        }

        List<ParameterBinding> getBindings() {
            return Collections.unmodifiableList(this.bindings);
        }

        CassandraParameters getParameters() {
            return this.queryMethod.getParameters();
        }

        CassandraQueryMethod getQueryMethod() {
            return this.queryMethod;
        }
    }
}

