/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

final class ProjectionUtil {
    private static final Set<DataType> NUMERIC_TYPES = new HashSet<DataType>(Arrays.asList(DataTypes.BIGINT, DataTypes.VARINT, DataTypes.SMALLINT, DataTypes.INT, DataTypes.COUNTER, DataTypes.TINYINT));

    static boolean hasAmbiguousProjectionFlags(Boolean ... flags) {
        return Arrays.stream(flags).filter(Boolean::booleanValue).count() > 1L;
    }

    static boolean qualifiesAsCountProjection(Row row) {
        ColumnDefinitions columnDefinitions = row.getColumnDefinitions();
        return columnDefinitions.size() == 1 && NUMERIC_TYPES.contains(columnDefinitions.get(0).getType());
    }

    private ProjectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

