/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import java.util.Collections;
import lombok.NonNull;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.util.Assert;

public abstract class AbstractCassandraConverter
implements CassandraConverter,
InitializingBean {
    private final ConversionService conversionService;
    private CustomConversions conversions = new CassandraCustomConversions(Collections.emptyList());
    EntityInstantiators instantiators = new EntityInstantiators();

    protected AbstractCassandraConverter(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.conversionService = conversionService;
    }

    public void setInstantiators(EntityInstantiators instantiators) {
        Assert.notNull((Object)instantiators, (String)"EntityInstantiators must not be null");
        this.instantiators = instantiators;
    }

    @NonNull
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setCustomConversions(CustomConversions conversions) {
        this.conversions = conversions;
    }

    @Override
    public CustomConversions getCustomConversions() {
        return this.conversions;
    }

    public void afterPropertiesSet() {
        this.initializeConverters();
    }

    private void initializeConverters() {
        ConversionService conversionService = this.getConversionService();
        if (conversionService instanceof GenericConversionService) {
            this.getCustomConversions().registerConvertersIn((ConverterRegistry)((GenericConversionService)conversionService));
        }
    }
}

