/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.type.DataType;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;

class ConvertingParameterAccessor
implements CassandraParameterAccessor {
    private final CassandraConverter converter;
    private final CassandraParameterAccessor delegate;

    ConvertingParameterAccessor(CassandraConverter converter, CassandraParameterAccessor delegate) {
        this.converter = converter;
        this.delegate = delegate;
    }

    public Pageable getPageable() {
        return this.delegate.getPageable();
    }

    public Sort getSort() {
        return this.delegate.getSort();
    }

    public Optional<Class<?>> getDynamicProjection() {
        return this.delegate.getDynamicProjection();
    }

    @Nullable
    public Class<?> findDynamicProjection() {
        return this.delegate.findDynamicProjection();
    }

    public Object getBindableValue(int index) {
        return this.potentiallyConvert(index, this.delegate.getBindableValue(index), null);
    }

    @Override
    public CassandraType findCassandraType(int index) {
        return this.delegate.findCassandraType(index);
    }

    @Override
    public DataType getDataType(int index) {
        return this.delegate.getDataType(index);
    }

    @Override
    public Class<?> getParameterType(int index) {
        return this.delegate.getParameterType(index);
    }

    @Override
    @Nullable
    public QueryOptions getQueryOptions() {
        return this.delegate.getQueryOptions();
    }

    public boolean hasBindableNullValue() {
        return this.delegate.hasBindableNullValue();
    }

    public Iterator<Object> iterator() {
        return new ConvertingIterator(this.delegate.iterator());
    }

    @Override
    public Object[] getValues() {
        return this.delegate.getValues();
    }

    @Nullable
    Object potentiallyConvert(int index, @Nullable Object bindableValue, @Nullable CassandraPersistentProperty property) {
        if (bindableValue == null) {
            return null;
        }
        CassandraType cassandraType = this.delegate.findCassandraType(index);
        if (cassandraType != null) {
            this.converter.convertToColumnType(bindableValue, this.converter.getColumnTypeResolver().resolve(cassandraType));
        }
        if (property != null && (property.isCollectionLike() && bindableValue instanceof Collection || !property.isCollectionLike() && !(bindableValue instanceof Collection))) {
            return this.converter.convertToColumnType(bindableValue, this.converter.getColumnTypeResolver().resolve(property));
        }
        return this.converter.convertToColumnType(bindableValue, this.converter.getColumnTypeResolver().resolve(bindableValue));
    }

    static interface PotentiallyConvertingIterator
    extends Iterator<Object> {
        @Nullable
        public Object nextConverted(CassandraPersistentProperty var1);
    }

    private class ConvertingIterator
    implements PotentiallyConvertingIterator {
        private final Iterator<Object> delegate;
        private int index = 0;

        ConvertingIterator(Iterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        @Nullable
        public Object next() {
            return ConvertingParameterAccessor.this.potentiallyConvert(this.index++, this.delegate.next(), null);
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        @Nullable
        public Object nextConverted(CassandraPersistentProperty property) {
            return ConvertingParameterAccessor.this.potentiallyConvert(this.index++, this.delegate.next(), property);
        }
    }
}

