/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.cassandra.config.KeyspaceActions;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.config.SessionBuilderConfigurer;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.core.CassandraPersistentEntitySchemaCreator;
import org.springframework.data.cassandra.core.CassandraPersistentEntitySchemaDropper;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.CassandraExceptionTranslator;
import org.springframework.data.cassandra.core.cql.generator.AlterKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.CreateKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.AlterKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceActionSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceOptionsSpecification;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CqlSessionFactoryBean
implements FactoryBean<CqlSession>,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    private static final boolean DEFAULT_CREATE_IF_NOT_EXISTS = false;
    private static final boolean DEFAULT_DROP_TABLES = false;
    private static final boolean DEFAULT_DROP_UNUSED_TABLES = false;
    public static final int DEFAULT_PORT = 9042;
    private static final CassandraExceptionTranslator EXCEPTION_TRANSLATOR = new CassandraExceptionTranslator();
    public static final String CASSANDRA_SYSTEM_SESSION = "system";
    public static final String DEFAULT_CONTACT_POINTS = "localhost";
    private int port = 9042;
    @Nullable
    private CassandraConverter converter;
    @Nullable
    private CqlSession session;
    @Nullable
    private CqlSession systemSession;
    private List<KeyspaceActions> keyspaceActions = new ArrayList<KeyspaceActions>();
    private List<AlterKeyspaceSpecification> keyspaceAlterations = new ArrayList<AlterKeyspaceSpecification>();
    private List<CreateKeyspaceSpecification> keyspaceCreations = new ArrayList<CreateKeyspaceSpecification>();
    private List<DropKeyspaceSpecification> keyspaceDrops = new ArrayList<DropKeyspaceSpecification>();
    private List<String> keyspaceStartupScripts = new ArrayList<String>();
    private List<String> keyspaceShutdownScripts = new ArrayList<String>();
    private List<String> startupScripts = Collections.emptyList();
    private List<String> shutdownScripts = Collections.emptyList();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<KeyspaceActionSpecification> keyspaceSpecifications = new HashSet<KeyspaceActionSpecification>();
    private SchemaAction schemaAction = SchemaAction.NONE;
    @Nullable
    private SessionBuilderConfigurer sessionBuilderConfigurer;
    private String contactPoints = "localhost";
    @Nullable
    private String keyspaceName;
    @Nullable
    private String localDatacenter;
    @Nullable
    private String password;
    @Nullable
    private String username;

    public boolean isConnected() {
        CqlSession session = this.getObject();
        return session != null && !session.isClosed();
    }

    public void setContactPoints(String contactPoints) {
        this.contactPoints = contactPoints;
    }

    public void setLocalDatacenter(@Nullable String localDatacenter) {
        this.localDatacenter = localDatacenter;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public void setConverter(CassandraConverter converter) {
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
    }

    @Nullable
    public CassandraConverter getConverter() {
        return this.converter;
    }

    public void setKeyspaceActions(List<KeyspaceActions> keyspaceActions) {
        this.keyspaceActions = new ArrayList<KeyspaceActions>(keyspaceActions);
    }

    public List<KeyspaceActions> getKeyspaceActions() {
        return Collections.unmodifiableList(this.keyspaceActions);
    }

    public void setKeyspaceAlterations(List<AlterKeyspaceSpecification> specifications) {
        this.keyspaceAlterations = new ArrayList<AlterKeyspaceSpecification>(specifications);
    }

    public void setKeyspaceCreations(List<CreateKeyspaceSpecification> specifications) {
        this.keyspaceCreations = new ArrayList<CreateKeyspaceSpecification>(specifications);
    }

    public void setKeyspaceDrops(List<DropKeyspaceSpecification> specifications) {
        this.keyspaceDrops = new ArrayList<DropKeyspaceSpecification>(specifications);
    }

    public void setKeyspaceName(@Nullable String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    @Nullable
    protected String getKeyspaceName() {
        return this.keyspaceName;
    }

    public void setKeyspaceSpecifications(List<? extends KeyspaceActionSpecification> keyspaceSpecifications) {
        this.keyspaceSpecifications = new LinkedHashSet<KeyspaceActionSpecification>(keyspaceSpecifications);
    }

    public Set<KeyspaceActionSpecification> getKeyspaceSpecifications() {
        return Collections.unmodifiableSet(this.keyspaceSpecifications);
    }

    public void setKeyspaceStartupScripts(List<String> scripts) {
        this.keyspaceStartupScripts = new ArrayList<String>(scripts);
    }

    public void setKeyspaceShutdownScripts(List<String> scripts) {
        this.keyspaceShutdownScripts = new ArrayList<String>(scripts);
    }

    protected CassandraMappingContext getMappingContext() {
        CassandraConverter converter = this.getConverter();
        Assert.state((converter != null ? 1 : 0) != 0, (String)"CassandraConverter was not properly initialized");
        return converter.getMappingContext();
    }

    @Deprecated
    public void setSchemaAction(SchemaAction schemaAction) {
        Assert.notNull((Object)((Object)schemaAction), (String)"SchemaAction must not be null");
        this.schemaAction = schemaAction;
    }

    public SchemaAction getSchemaAction() {
        return this.schemaAction;
    }

    protected CqlSession getSession() {
        CqlSession session = this.getObject();
        Assert.state((session != null ? 1 : 0) != 0, (String)"Session was not properly initialized");
        return session;
    }

    public void setSessionBuilderConfigurer(@Nullable SessionBuilderConfigurer sessionBuilderConfigurer) {
        this.sessionBuilderConfigurer = sessionBuilderConfigurer;
    }

    @Deprecated
    public void setStartupScripts(@Nullable List<String> scripts) {
        this.startupScripts = scripts != null ? new ArrayList<String>(scripts) : Collections.emptyList();
    }

    @Deprecated
    public List<String> getStartupScripts() {
        return Collections.unmodifiableList(this.startupScripts);
    }

    @Deprecated
    public void setShutdownScripts(@Nullable List<String> scripts) {
        this.shutdownScripts = scripts != null ? new ArrayList<String>(scripts) : Collections.emptyList();
    }

    @Deprecated
    public List<String> getShutdownScripts() {
        return Collections.unmodifiableList(this.shutdownScripts);
    }

    public void afterPropertiesSet() {
        CqlSessionBuilder sessionBuilder = this.buildBuilder();
        this.systemSession = this.buildSystemSession(sessionBuilder);
        this.initializeCluster(this.systemSession);
        this.session = this.buildSession(sessionBuilder);
        this.executeCql(this.getStartupScripts().stream(), this.session);
        this.performSchemaAction();
        this.systemSession.refreshSchema();
        this.session.refreshSchema();
    }

    protected CqlSessionBuilder buildBuilder() {
        Assert.hasText((String)this.contactPoints, (String)"At least one server is required");
        CqlSessionBuilder sessionBuilder = CqlSession.builder();
        StringUtils.commaDelimitedListToSet((String)this.contactPoints).forEach(host -> {
            CqlSessionBuilder cfr_ignored_0 = (CqlSessionBuilder)sessionBuilder.addContactPoint(InetSocketAddress.createUnresolved(host, this.port));
        });
        if (StringUtils.hasText((String)this.username)) {
            sessionBuilder.withAuthCredentials(this.username, this.password);
        }
        if (StringUtils.hasText((String)this.localDatacenter)) {
            sessionBuilder.withLocalDatacenter(this.localDatacenter);
        }
        return this.sessionBuilderConfigurer != null ? this.sessionBuilderConfigurer.configure(sessionBuilder) : sessionBuilder;
    }

    protected CqlSession buildSystemSession(CqlSessionBuilder sessionBuilder) {
        return (CqlSession)((CqlSessionBuilder)sessionBuilder.withKeyspace(CASSANDRA_SYSTEM_SESSION)).build();
    }

    protected CqlSession buildSession(CqlSessionBuilder sessionBuilder) {
        if (StringUtils.hasText((String)this.getKeyspaceName())) {
            sessionBuilder.withKeyspace(this.getKeyspaceName());
        }
        return (CqlSession)sessionBuilder.build();
    }

    private void initializeCluster(CqlSession session) {
        this.generateSpecificationsFromFactoryBeanDeclarations();
        ArrayList<KeyspaceOptionsSpecification> keyspaceStartupSpecifications = new ArrayList<KeyspaceOptionsSpecification>(this.keyspaceCreations.size() + this.keyspaceAlterations.size());
        keyspaceStartupSpecifications.addAll(this.keyspaceCreations);
        keyspaceStartupSpecifications.addAll(this.keyspaceAlterations);
        this.executeSpecificationsAndScripts(keyspaceStartupSpecifications, this.keyspaceStartupScripts, session);
    }

    private void generateSpecificationsFromFactoryBeanDeclarations() {
        this.generateSpecifications(this.keyspaceSpecifications);
        this.keyspaceActions.forEach(actions -> this.generateSpecifications(actions.getActions()));
    }

    private void generateSpecifications(Collection<KeyspaceActionSpecification> specifications) {
        specifications.forEach(specification -> {
            if (specification instanceof AlterKeyspaceSpecification) {
                this.keyspaceAlterations.add((AlterKeyspaceSpecification)specification);
            } else if (specification instanceof CreateKeyspaceSpecification) {
                this.keyspaceCreations.add((CreateKeyspaceSpecification)specification);
            } else if (specification instanceof DropKeyspaceSpecification) {
                this.keyspaceDrops.add((DropKeyspaceSpecification)specification);
            }
        });
    }

    protected void performSchemaAction() {
        boolean create = false;
        boolean drop = false;
        boolean dropUnused = false;
        boolean ifNotExists = false;
        switch (this.schemaAction) {
            case RECREATE_DROP_UNUSED: {
                dropUnused = true;
            }
            case RECREATE: {
                drop = true;
            }
            case CREATE_IF_NOT_EXISTS: {
                ifNotExists = SchemaAction.CREATE_IF_NOT_EXISTS.equals((Object)this.schemaAction);
            }
            case CREATE: {
                create = true;
            }
        }
        if (create) {
            this.createTables(drop, dropUnused, ifNotExists);
        }
    }

    protected void createTables(boolean drop, boolean dropUnused, boolean ifNotExists) {
        CassandraAdminTemplate adminTemplate = new CassandraAdminTemplate(this.session, this.converter);
        this.performSchemaActions(drop, dropUnused, ifNotExists, adminTemplate);
    }

    private void performSchemaActions(boolean drop, boolean dropUnused, boolean ifNotExists, CassandraAdminOperations adminOperations) {
        CassandraPersistentEntitySchemaCreator schemaCreator = new CassandraPersistentEntitySchemaCreator(this.getMappingContext(), adminOperations);
        if (drop) {
            CassandraPersistentEntitySchemaDropper schemaDropper = new CassandraPersistentEntitySchemaDropper(this.getMappingContext(), adminOperations);
            schemaDropper.dropTables(dropUnused);
            schemaDropper.dropUserTypes(dropUnused);
        }
        schemaCreator.createUserTypes(ifNotExists);
        schemaCreator.createTables(ifNotExists);
        schemaCreator.createIndexes(ifNotExists);
    }

    public void destroy() {
        if (this.session != null) {
            this.executeCql(this.getShutdownScripts().stream(), this.session);
            this.executeSpecificationsAndScripts(this.keyspaceDrops, this.keyspaceShutdownScripts, this.systemSession);
            this.closeSession();
            this.closeSystemSession();
        }
    }

    protected void closeSession() {
        this.session.close();
    }

    protected void closeSystemSession() {
        this.systemSession.close();
    }

    public CqlSession getObject() {
        return this.session;
    }

    public Class<? extends CqlSession> getObjectType() {
        return CqlSession.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void executeCql(Stream<String> cql, CqlSession session) {
        cql.forEach(query2 -> {
            this.logger.info("Executing CQL [{}]", query2);
            session.execute(query2);
        });
    }

    private void executeSpecificationsAndScripts(List<? extends KeyspaceActionSpecification> keyspaceActionSpecifications, List<String> keyspaceCqlScripts, CqlSession session) {
        if (!CollectionUtils.isEmpty(keyspaceActionSpecifications) || !CollectionUtils.isEmpty(keyspaceCqlScripts)) {
            Stream<String> keyspaceActionSpecificationsStream = keyspaceActionSpecifications.stream().map(this::toCql);
            Stream keyspaceCqlScriptsStream = keyspaceCqlScripts.stream();
            Stream<String> cql = Stream.concat(keyspaceActionSpecificationsStream, keyspaceCqlScriptsStream);
            this.executeCql(cql, session);
        }
    }

    private String toCql(KeyspaceActionSpecification specification) {
        if (specification instanceof AlterKeyspaceSpecification) {
            return new AlterKeyspaceCqlGenerator((AlterKeyspaceSpecification)specification).toCql();
        }
        if (specification instanceof CreateKeyspaceSpecification) {
            return new CreateKeyspaceCqlGenerator((CreateKeyspaceSpecification)specification).toCql();
        }
        if (specification instanceof DropKeyspaceSpecification) {
            return new DropKeyspaceCqlGenerator((DropKeyspaceSpecification)specification).toCql();
        }
        throw new IllegalArgumentException(String.format("Unsupported specification type: %s", ClassUtils.getQualifiedName(specification.getClass())));
    }

    @Nullable
    public DataAccessException translateExceptionIfPossible(RuntimeException e) {
        return EXCEPTION_TRANSLATOR.translateExceptionIfPossible(e);
    }
}

