/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleType;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentTupleMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.TupleTypeFactory;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class BasicCassandraPersistentTupleEntity<T>
extends BasicCassandraPersistentEntity<T> {
    private final Lazy<TupleType> tupleType;

    public BasicCassandraPersistentTupleEntity(TypeInformation<T> information, TupleTypeFactory tupleTypeFactory) {
        super(information, CassandraPersistentTupleMetadataVerifier.INSTANCE, TuplePropertyComparator.INSTANCE);
        Assert.notNull((Object)tupleTypeFactory, (String)"TupleTypeFactory must not be null");
        this.tupleType = Lazy.of(() -> tupleTypeFactory.create(this.getTupleFieldDataTypes()));
    }

    private List<DataType> getTupleFieldDataTypes() {
        return StreamSupport.stream(this.spliterator(), false).sorted(TuplePropertyComparator.INSTANCE).map(CassandraPersistentProperty::getDataType).collect(Collectors.toList());
    }

    @Override
    public void verify() throws MappingException {
        super.verify();
        CassandraPersistentTupleMetadataVerifier.INSTANCE.verify(this);
    }

    @Override
    public boolean isTupleType() {
        return true;
    }

    @Override
    public TupleType getTupleType() {
        return (TupleType)this.tupleType.get();
    }

    static enum TuplePropertyComparator implements Comparator<CassandraPersistentProperty>
    {
        INSTANCE;


        @Override
        public int compare(CassandraPersistentProperty propertyOne, CassandraPersistentProperty propertyTwo) {
            return Integer.compare(propertyOne.getRequiredOrdinal(), propertyTwo.getRequiredOrdinal());
        }
    }
}

