/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class PoolingOptionsFactoryBean
implements FactoryBean<PoolingOptions>,
InitializingBean {
    private static final PoolingOptions DEFAULT = new PoolingOptions();
    private static final Optional<Method> SET_MAX_QUEUE_SIZE = Optional.ofNullable(ReflectionUtils.findMethod(PoolingOptions.class, (String)"setMaxQueueSize", (Class[])new Class[]{Integer.TYPE}));
    private static final Optional<Method> GET_MAX_QUEUE_SIZE = Optional.ofNullable(ReflectionUtils.findMethod(PoolingOptions.class, (String)"getMaxQueueSize"));
    @Nullable
    private Executor initializationExecutor;
    private int heartbeatIntervalSeconds;
    private int idleTimeoutSeconds;
    @Nullable
    private Integer localCoreConnections;
    @Nullable
    private Integer localMaxConnections;
    @Nullable
    private Integer localMaxSimultaneousRequests;
    @Nullable
    private Integer localMinSimultaneousRequests;
    private int poolTimeoutMilliseconds;
    private int maxQueueSize;
    @Nullable
    private Integer remoteCoreConnections;
    @Nullable
    private Integer remoteMaxConnections;
    @Nullable
    private Integer remoteMaxSimultaneousRequests;
    @Nullable
    private Integer remoteMinSimultaneousRequests;
    @Nullable
    private PoolingOptions poolingOptions;

    public void afterPropertiesSet() throws Exception {
        this.poolingOptions = this.configureRemoteHostDistancePoolingOptions(this.configureLocalHostDistancePoolingOptions(this.newPoolingOptions()));
        if (this.heartbeatIntervalSeconds != DEFAULT.getHeartbeatIntervalSeconds()) {
            this.poolingOptions.setHeartbeatIntervalSeconds(this.heartbeatIntervalSeconds);
        }
        if (this.idleTimeoutSeconds != DEFAULT.getIdleTimeoutSeconds()) {
            this.poolingOptions.setIdleTimeoutSeconds(this.idleTimeoutSeconds);
        }
        if (this.initializationExecutor != null) {
            this.poolingOptions.setInitializationExecutor(this.initializationExecutor);
        }
        if (this.poolTimeoutMilliseconds != DEFAULT.getPoolTimeoutMillis()) {
            this.poolingOptions.setPoolTimeoutMillis(this.poolTimeoutMilliseconds);
        }
        if (!this.isDefaultMaxQueueSize()) {
            SET_MAX_QUEUE_SIZE.ifPresent(method -> ReflectionUtils.invokeMethod((Method)method, (Object)this.poolingOptions, (Object[])new Object[]{this.maxQueueSize}));
        }
    }

    private boolean isDefaultMaxQueueSize() {
        return GET_MAX_QUEUE_SIZE.map(method -> {
            Integer defaultMaxQueueSize = (Integer)ReflectionUtils.invokeMethod((Method)method, (Object)this.poolingOptions);
            return defaultMaxQueueSize != null && defaultMaxQueueSize == this.maxQueueSize;
        }).orElse(false);
    }

    PoolingOptions newPoolingOptions() {
        return new PoolingOptions();
    }

    protected HostDistancePoolingOptions newLocalHostDistancePoolingOptions() {
        return new LocalHostDistancePoolingOptions(this.getLocalCoreConnections(), this.getLocalMaxConnections(), this.getLocalMaxSimultaneousRequests(), this.getLocalMinSimultaneousRequests());
    }

    protected HostDistancePoolingOptions newRemoteHostDistancePoolingOptions() {
        return new RemoteHostDistancePoolingOptions(this.getRemoteCoreConnections(), this.getRemoteMaxConnections(), this.getRemoteMaxSimultaneousRequests(), this.getRemoteMinSimultaneousRequests());
    }

    protected PoolingOptions configureLocalHostDistancePoolingOptions(PoolingOptions poolingOptions) {
        return this.newLocalHostDistancePoolingOptions().configure(poolingOptions);
    }

    protected PoolingOptions configureRemoteHostDistancePoolingOptions(PoolingOptions poolingOptions) {
        return this.newRemoteHostDistancePoolingOptions().configure(poolingOptions);
    }

    public PoolingOptions getObject() throws Exception {
        return this.poolingOptions;
    }

    public Class<?> getObjectType() {
        return this.poolingOptions != null ? this.poolingOptions.getClass() : PoolingOptions.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setHeartbeatIntervalSeconds(int heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }

    public int getHeartbeatIntervalSeconds() {
        return this.heartbeatIntervalSeconds;
    }

    public void setIdleTimeoutSeconds(int idleTimeoutSeconds) {
        this.idleTimeoutSeconds = idleTimeoutSeconds;
    }

    public int getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public void setInitializationExecutor(Executor initializationExecutor) {
        this.initializationExecutor = initializationExecutor;
    }

    @Nullable
    public Executor getInitializationExecutor() {
        return this.initializationExecutor;
    }

    public void setPoolTimeoutMilliseconds(int poolTimeoutMilliseconds) {
        this.poolTimeoutMilliseconds = poolTimeoutMilliseconds;
    }

    public int getPoolTimeoutMilliseconds() {
        return this.poolTimeoutMilliseconds;
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setLocalCoreConnections(@Nullable Integer localCoreConnections) {
        this.localCoreConnections = localCoreConnections;
    }

    @Nullable
    public Integer getLocalCoreConnections() {
        return this.localCoreConnections;
    }

    public void setLocalMaxConnections(@Nullable Integer localMaxConnections) {
        this.localMaxConnections = localMaxConnections;
    }

    @Nullable
    public Integer getLocalMaxConnections() {
        return this.localMaxConnections;
    }

    public void setLocalMaxSimultaneousRequests(@Nullable Integer localMaxSimultaneousRequests) {
        this.localMaxSimultaneousRequests = localMaxSimultaneousRequests;
    }

    @Nullable
    public Integer getLocalMaxSimultaneousRequests() {
        return this.localMaxSimultaneousRequests;
    }

    public void setLocalMinSimultaneousRequests(@Nullable Integer localMinSimultaneousRequests) {
        this.localMinSimultaneousRequests = localMinSimultaneousRequests;
    }

    @Nullable
    public Integer getLocalMinSimultaneousRequests() {
        return this.localMinSimultaneousRequests;
    }

    public void setRemoteCoreConnections(@Nullable Integer remoteCoreConnections) {
        this.remoteCoreConnections = remoteCoreConnections;
    }

    @Nullable
    public Integer getRemoteCoreConnections() {
        return this.remoteCoreConnections;
    }

    public void setRemoteMaxConnections(@Nullable Integer remoteMaxConnections) {
        this.remoteMaxConnections = remoteMaxConnections;
    }

    @Nullable
    public Integer getRemoteMaxConnections() {
        return this.remoteMaxConnections;
    }

    public void setRemoteMaxSimultaneousRequests(@Nullable Integer remoteMaxSimultaneousRequests) {
        this.remoteMaxSimultaneousRequests = remoteMaxSimultaneousRequests;
    }

    @Nullable
    public Integer getRemoteMaxSimultaneousRequests() {
        return this.remoteMaxSimultaneousRequests;
    }

    public void setRemoteMinSimultaneousRequests(@Nullable Integer remoteMinSimultaneousRequests) {
        this.remoteMinSimultaneousRequests = remoteMinSimultaneousRequests;
    }

    @Nullable
    public Integer getRemoteMinSimultaneousRequests() {
        return this.remoteMinSimultaneousRequests;
    }

    static class RemoteHostDistancePoolingOptions
    extends HostDistancePoolingOptions {
        RemoteHostDistancePoolingOptions(@Nullable Integer coreConnectionsPerHost, @Nullable Integer maxConnectionsPerHost, @Nullable Integer maxRequestsPerConnection, @Nullable Integer newConnectionThreshold) {
            super(coreConnectionsPerHost, maxConnectionsPerHost, maxRequestsPerConnection, newConnectionThreshold);
        }

        @Override
        protected HostDistance getHostDistance() {
            return HostDistance.REMOTE;
        }
    }

    static class LocalHostDistancePoolingOptions
    extends HostDistancePoolingOptions {
        LocalHostDistancePoolingOptions(@Nullable Integer coreConnectionsPerHost, @Nullable Integer maxConnectionsPerHost, @Nullable Integer maxRequestsPerConnection, @Nullable Integer newConnectionThreshold) {
            super(coreConnectionsPerHost, maxConnectionsPerHost, maxRequestsPerConnection, newConnectionThreshold);
        }

        @Override
        protected HostDistance getHostDistance() {
            return HostDistance.LOCAL;
        }
    }

    protected static abstract class HostDistancePoolingOptions {
        @Nullable
        private final Integer coreConnectionsPerHost;
        @Nullable
        private final Integer maxConnectionsPerHost;
        @Nullable
        private final Integer maxRequestsPerConnection;
        @Nullable
        private final Integer newConnectionThreshold;

        protected HostDistancePoolingOptions(@Nullable Integer coreConnectionsPerHost, @Nullable Integer maxConnectionsPerHost, @Nullable Integer maxRequestsPerConnection, @Nullable Integer newConnectionThreshold) {
            this.coreConnectionsPerHost = coreConnectionsPerHost;
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            this.maxRequestsPerConnection = maxRequestsPerConnection;
            this.newConnectionThreshold = newConnectionThreshold;
        }

        protected abstract HostDistance getHostDistance();

        void setCoreConnectionsPerHost(PoolingOptions poolingOptions) {
            if (this.coreConnectionsPerHost != null) {
                poolingOptions.setCoreConnectionsPerHost(this.getHostDistance(), this.coreConnectionsPerHost.intValue());
            }
        }

        @Nullable
        protected Integer getCoreConnectionsPerHost() {
            return this.coreConnectionsPerHost;
        }

        void setMaxConnectionsPerHost(PoolingOptions poolingOptions) {
            if (this.maxConnectionsPerHost != null) {
                poolingOptions.setMaxConnectionsPerHost(this.getHostDistance(), this.maxConnectionsPerHost.intValue());
            }
        }

        @Nullable
        protected Integer getMaxConnectionsPerHost() {
            return this.maxConnectionsPerHost;
        }

        void setMaxRequestsPerConnection(PoolingOptions poolingOptions) {
            if (this.maxRequestsPerConnection != null) {
                poolingOptions.setMaxRequestsPerConnection(this.getHostDistance(), this.maxRequestsPerConnection.intValue());
            }
        }

        @Nullable
        protected Integer getMaxRequestsPerConnection() {
            return this.maxRequestsPerConnection;
        }

        void setNewConnectionThreshold(PoolingOptions poolingOptions) {
            int currentNewConnectionThreshold;
            if (this.newConnectionThreshold != null && (currentNewConnectionThreshold = poolingOptions.getNewConnectionThreshold(this.getHostDistance())) < this.newConnectionThreshold) {
                poolingOptions.setNewConnectionThreshold(this.getHostDistance(), this.newConnectionThreshold.intValue());
            }
        }

        @Nullable
        protected Integer getNewConnectionThreshold() {
            return this.newConnectionThreshold;
        }

        PoolingOptions configure(PoolingOptions poolingOptions) {
            this.setMaxConnectionsPerHost(poolingOptions);
            this.setCoreConnectionsPerHost(poolingOptions);
            this.setMaxRequestsPerConnection(poolingOptions);
            this.setNewConnectionThreshold(poolingOptions);
            return poolingOptions;
        }
    }
}

