/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.DataType;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.lang.Nullable;

public class CassandraParametersParameterAccessor
extends ParametersParameterAccessor
implements CassandraParameterAccessor {
    public CassandraParametersParameterAccessor(CassandraQueryMethod method, Object ... values) {
        super((Parameters)method.getParameters(), values);
    }

    @Override
    public DataType getDataType(int index) {
        CassandraType cassandraType = this.findCassandraType(index);
        return cassandraType != null ? CassandraSimpleTypeHolder.getDataTypeFor(cassandraType.type()) : CassandraSimpleTypeHolder.getDataTypeFor(this.getParameterType(index));
    }

    @Override
    @Nullable
    public CassandraType findCassandraType(int index) {
        return ((CassandraParameters.CassandraParameter)this.getParameters().getParameter(index)).getCassandraType();
    }

    @Override
    public Class<?> getParameterType(int index) {
        return ((CassandraParameters.CassandraParameter)this.getParameters().getParameter(index)).getType();
    }

    public CassandraParameters getParameters() {
        return (CassandraParameters)super.getParameters();
    }

    @Override
    public Object[] getValues() {
        return super.getValues();
    }

    @Override
    @Nullable
    public QueryOptions getQueryOptions() {
        int queryOptionsIndex = this.getParameters().getQueryOptionsIndex();
        Object value = queryOptionsIndex != -1 ? this.getValue(queryOptionsIndex) : null;
        return (QueryOptions)value;
    }
}

