/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import lombok.NonNull;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.ExecutableDeleteOperation;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ExecutableDeleteOperationSupport
implements ExecutableDeleteOperation {
    @NonNull
    private final CassandraTemplate template;

    @Override
    public ExecutableDeleteOperation.ExecutableDelete delete(Class<?> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableDeleteSupport(this.template, domainType, Query.empty(), null);
    }

    public ExecutableDeleteOperationSupport(@NonNull CassandraTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        this.template = template;
    }

    static class ExecutableDeleteSupport
    implements ExecutableDeleteOperation.ExecutableDelete,
    ExecutableDeleteOperation.TerminatingDelete {
        @NonNull
        private final CassandraTemplate template;
        @NonNull
        private final Class<?> domainType;
        @NonNull
        private final Query query;
        @Nullable
        private final CqlIdentifier tableName;

        @Override
        public ExecutableDeleteOperation.DeleteWithQuery inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ExecutableDeleteSupport(this.template, this.domainType, this.query, tableName);
        }

        @Override
        public ExecutableDeleteOperation.TerminatingDelete matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ExecutableDeleteSupport(this.template, this.domainType, query2, this.tableName);
        }

        @Override
        public WriteResult all() {
            return this.template.doDelete(this.query, this.domainType, this.getTableName());
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }

        public ExecutableDeleteSupport(@NonNull CassandraTemplate template, @NonNull Class<?> domainType, @NonNull Query query2, @Nullable CqlIdentifier tableName) {
            if (template == null) {
                throw new NullPointerException("template is marked non-null but is null");
            }
            if (domainType == null) {
                throw new NullPointerException("domainType is marked non-null but is null");
            }
            if (query2 == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.query = query2;
            this.tableName = tableName;
        }
    }
}

