/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.ArgumentPreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.CassandraExceptionTranslator;
import org.springframework.data.cassandra.core.cql.ColumnMapRowMapper;
import org.springframework.data.cassandra.core.cql.CqlExceptionTranslator;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.PreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.ResultSetExtractor;
import org.springframework.data.cassandra.core.cql.RowCallbackHandler;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.RowMapperResultSetExtractor;
import org.springframework.data.cassandra.core.cql.SingleColumnRowMapper;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CassandraAccessor
implements InitializingBean {
    private static final Statement DEFAULTS = QueryBuilder.select().from("DEFAULT");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CqlExceptionTranslator exceptionTranslator = new CassandraExceptionTranslator();
    private int fetchSize = -1;
    @Nullable
    private ConsistencyLevel consistencyLevel;
    @Nullable
    private RetryPolicy retryPolicy;
    @Nullable
    private SessionFactory sessionFactory;

    public void afterPropertiesSet() {
        Assert.state((this.sessionFactory != null ? 1 : 0) != 0, (String)"SessionFactory must not be null");
    }

    public void setConsistencyLevel(@Nullable ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    @Nullable
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setExceptionTranslator(CqlExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)exceptionTranslator, (String)"CQLExceptionTranslator must not be null");
        this.exceptionTranslator = exceptionTranslator;
    }

    public CqlExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Nullable
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.setSessionFactory(new DefaultSessionFactory(session));
    }

    @Deprecated
    public Session getSession() {
        Assert.state((this.getSessionFactory() != null ? 1 : 0) != 0, (String)"SessionFactory was not properly initialized");
        return this.getSessionFactory().getSession();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"SessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }

    @Nullable
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected <T extends PreparedStatement> T applyStatementSettings(T statement) {
        RetryPolicy retryPolicy;
        ConsistencyLevel consistencyLevel = this.getConsistencyLevel();
        if (consistencyLevel != null) {
            statement.setConsistencyLevel(consistencyLevel);
        }
        if ((retryPolicy = this.getRetryPolicy()) != null) {
            statement.setRetryPolicy(retryPolicy);
        }
        return statement;
    }

    protected <T extends Statement> T applyStatementSettings(T statement) {
        RetryPolicy retryPolicy;
        int fetchSize;
        ConsistencyLevel consistencyLevel = this.getConsistencyLevel();
        if (consistencyLevel != null && statement.getConsistencyLevel() == DEFAULTS.getConsistencyLevel()) {
            statement.setConsistencyLevel(consistencyLevel);
        }
        if ((fetchSize = this.getFetchSize()) != -1 && statement.getFetchSize() == DEFAULTS.getFetchSize()) {
            statement.setFetchSize(fetchSize);
        }
        if ((retryPolicy = this.getRetryPolicy()) != null && statement.getRetryPolicy() == DEFAULTS.getRetryPolicy()) {
            statement.setRetryPolicy(retryPolicy);
        }
        return statement;
    }

    @Nullable
    protected DataAccessException translateExceptionIfPossible(DriverException ex) {
        Assert.notNull((Object)ex, (String)"DriverException must not be null");
        return this.getExceptionTranslator().translateExceptionIfPossible((RuntimeException)ex);
    }

    protected DataAccessException translate(String task, @Nullable String cql, DriverException ex) {
        Assert.notNull((Object)ex, (String)"DriverException must not be null");
        return this.getExceptionTranslator().translate(task, cql, ex);
    }

    protected PreparedStatementBinder newPreparedStatementBinder(Object[] args) {
        return new ArgumentPreparedStatementBinder(args);
    }

    protected RowCallbackHandlerResultSetExtractor newResultSetExtractor(RowCallbackHandler rowCallbackHandler) {
        return new RowCallbackHandlerResultSetExtractor(rowCallbackHandler);
    }

    protected <T> RowMapperResultSetExtractor<T> newResultSetExtractor(RowMapper<T> rowMapper) {
        return new RowMapperResultSetExtractor<T>(rowMapper);
    }

    protected <T> RowMapperResultSetExtractor<T> newResultSetExtractor(RowMapper<T> rowMapper, int rowsExpected) {
        return new RowMapperResultSetExtractor<T>(rowMapper, rowsExpected);
    }

    protected RowMapper<Map<String, Object>> newColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected <T> RowMapper<T> newSingleColumnRowMapper(Class<T> requiredType) {
        return SingleColumnRowMapper.newInstance(requiredType);
    }

    @Nullable
    protected static String toCql(@Nullable Object cqlProvider) {
        return Optional.ofNullable(cqlProvider).filter(o -> o instanceof CqlProvider).map(o -> (CqlProvider)o).map(CqlProvider::getCql).orElse(null);
    }

    protected static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor<Object> {
        private final RowCallbackHandler rowCallbackHandler;

        protected RowCallbackHandlerResultSetExtractor(RowCallbackHandler rowCallbackHandler) {
            this.rowCallbackHandler = rowCallbackHandler;
        }

        @Override
        @Nullable
        public Object extractData(ResultSet resultSet) {
            StreamSupport.stream(resultSet.spliterator(), false).forEach(this.rowCallbackHandler::processRow);
            return null;
        }
    }
}

