/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.cassandra.config.EnableCassandraAuditing;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.event.AuditingEntityCallback;
import org.springframework.data.cassandra.core.mapping.event.ReactiveAuditingEntityCallback;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class CassandraAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    private static boolean PROJECT_REACTOR_AVAILABLE = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", (ClassLoader)CassandraAuditingRegistrar.class.getClassLoader());

    CassandraAuditingRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableCassandraAuditing.class;
    }

    protected String getAuditingHandlerBeanName() {
        return "cassandraAuditingHandler";
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)annotationMetadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        super.registerBeanDefinitions(annotationMetadata, registry);
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"AuditingConfiguration must not be null!");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(IsNewAwareAuditingHandler.class);
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(CassandraMappingContextLookup.class);
        definition.setAutowireMode(3);
        builder.addConstructorArgValue((Object)definition.getBeanDefinition());
        return this.configureDefaultAuditHandlerAttributes(configuration, builder);
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)auditingHandlerDefinition, (String)"BeanDefinition must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        BeanDefinitionBuilder listenerBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(AuditingEntityCallback.class);
        listenerBeanDefinitionBuilder.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)this.getAuditingHandlerBeanName(), (Object)registry));
        this.registerInfrastructureBeanWithId(listenerBeanDefinitionBuilder.getBeanDefinition(), AuditingEntityCallback.class.getName(), registry);
        if (PROJECT_REACTOR_AVAILABLE) {
            this.registerReactiveAuditingEntityCallback(registry, auditingHandlerDefinition.getSource());
        }
    }

    private void registerReactiveAuditingEntityCallback(BeanDefinitionRegistry registry, Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ReactiveAuditingEntityCallback.class);
        builder.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)this.getAuditingHandlerBeanName(), (Object)registry));
        builder.getRawBeanDefinition().setSource(source);
        this.registerInfrastructureBeanWithId(builder.getBeanDefinition(), ReactiveAuditingEntityCallback.class.getName(), registry);
    }

    static class CassandraMappingContextLookup
    implements FactoryBean<MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>> {
        private final CassandraConverter converter;

        public CassandraMappingContextLookup(CassandraConverter converter) {
            this.converter = converter;
        }

        public MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> getObject() throws Exception {
            return this.converter.getMappingContext();
        }

        public Class<?> getObjectType() {
            return MappingContext.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

