/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TypeCodec;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

class ConvertingParameterAccessor
implements CassandraParameterAccessor {
    private static final TypeInformation<Set> SET = ClassTypeInformation.from(Set.class);
    private final CassandraConverter converter;
    private final CassandraParameterAccessor delegate;

    ConvertingParameterAccessor(CassandraConverter converter, CassandraParameterAccessor delegate) {
        this.converter = converter;
        this.delegate = delegate;
    }

    public Pageable getPageable() {
        return this.delegate.getPageable();
    }

    public Sort getSort() {
        return this.delegate.getSort();
    }

    public Optional<Class<?>> getDynamicProjection() {
        return this.delegate.getDynamicProjection();
    }

    public Object getBindableValue(int index) {
        return this.potentiallyConvert(index, this.delegate.getBindableValue(index));
    }

    @Override
    public CassandraType findCassandraType(int index) {
        return this.delegate.findCassandraType(index);
    }

    @Override
    public DataType getDataType(int index) {
        return this.delegate.getDataType(index);
    }

    @Override
    public Class<?> getParameterType(int index) {
        return this.delegate.getParameterType(index);
    }

    @Override
    @Nullable
    public QueryOptions getQueryOptions() {
        return this.delegate.getQueryOptions();
    }

    public boolean hasBindableNullValue() {
        return this.delegate.hasBindableNullValue();
    }

    public Iterator<Object> iterator() {
        return new ConvertingIterator(this.delegate.iterator());
    }

    @Override
    public Object[] getValues() {
        return this.delegate.getValues();
    }

    @Nullable
    private Object potentiallyConvert(int index, @Nullable Object bindableValue) {
        if (bindableValue == null) {
            return null;
        }
        return this.converter.convertToColumnType(bindableValue, this.findTypeInformation(index, bindableValue, null));
    }

    @Nullable
    private Object potentiallyConvert(int index, @Nullable Object bindableValue, CassandraPersistentProperty property) {
        return bindableValue == null ? null : this.converter.convertToColumnType(bindableValue, this.findTypeInformation(index, bindableValue, property));
    }

    private TypeInformation<?> findTypeInformation(int index, Object bindableValue, @Nullable CassandraPersistentProperty property) {
        if (this.delegate.findCassandraType(index) != null) {
            TypeCodec typeCodec = CodecRegistry.DEFAULT_INSTANCE.codecFor(this.getDataType(index, property));
            if (typeCodec.getJavaType().getType() instanceof Class) {
                return ClassTypeInformation.from((Class)((Class)typeCodec.getJavaType().getType()));
            }
            return ClassTypeInformation.from((Class)typeCodec.getJavaType().getRawType());
        }
        if (property == null) {
            return ClassTypeInformation.from(bindableValue.getClass());
        }
        return property.getTypeInformation();
    }

    DataType getDataType(int index, @Nullable CassandraPersistentProperty property) {
        CassandraType cassandraType = this.delegate.findCassandraType(index);
        if (cassandraType != null) {
            return CassandraSimpleTypeHolder.getDataTypeFor(cassandraType.type());
        }
        CassandraMappingContext mappingContext = this.converter.getMappingContext();
        ClassTypeInformation typeInformation = ClassTypeInformation.from(this.getParameterType(index));
        if (property == null) {
            return mappingContext.getDataType(typeInformation.getType());
        }
        return this.getDataType(mappingContext, (TypeInformation<?>)typeInformation, property);
    }

    private DataType getDataType(CassandraMappingContext mappingContext, TypeInformation<?> typeInformation, CassandraPersistentProperty property) {
        DataType.CollectionType collectionType;
        DataType dataType = mappingContext.getDataType(property);
        if (property.isCollectionLike() && !typeInformation.isCollectionLike() && dataType instanceof DataType.CollectionType && (collectionType = (DataType.CollectionType)dataType).getTypeArguments().size() == 1) {
            return (DataType)collectionType.getTypeArguments().get(0);
        }
        if (!property.isCollectionLike() && typeInformation.isCollectionLike()) {
            if (typeInformation.isAssignableFrom(SET)) {
                return DataType.set((DataType)dataType);
            }
            return DataType.list((DataType)dataType);
        }
        if (property.isMap() && dataType instanceof DataType.CollectionType && (collectionType = (DataType.CollectionType)dataType).getTypeArguments().size() == 2) {
            return (DataType)collectionType.getTypeArguments().get(0);
        }
        return mappingContext.getDataType(property);
    }

    static interface PotentiallyConvertingIterator
    extends Iterator<Object> {
        @Nullable
        public Object nextConverted(CassandraPersistentProperty var1);
    }

    private class ConvertingIterator
    implements PotentiallyConvertingIterator {
        private final Iterator<Object> delegate;
        private int index = 0;

        ConvertingIterator(Iterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        @Nullable
        public Object next() {
            return ConvertingParameterAccessor.this.potentiallyConvert(this.index++, this.delegate.next());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        @Nullable
        public Object nextConverted(CassandraPersistentProperty property) {
            return ConvertingParameterAccessor.this.potentiallyConvert(this.index++, this.delegate.next(), property);
        }
    }
}

