/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.QueryOptionsUtil;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.query.CassandraPageRequest;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class QueryUtils {
    private static final Pattern FROM_REGEX = Pattern.compile(" FROM ([\"]?[\\w]*[\\\\.]?[\\w]*[\"]?)[\\s]?", 2);

    QueryUtils() {
    }

    static Insert createInsertQuery(String tableName, Object objectToInsert, WriteOptions options, CassandraConverter entityWriter, CassandraPersistentEntity<?> entity) {
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull((Object)objectToInsert, (String)"Object to insert must not be null");
        Assert.notNull((Object)entityWriter, (String)"CassandraConverter must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        Insert insert = QueryUtils.addWriteOptions(QueryBuilder.insertInto((String)tableName), options);
        boolean insertNulls = false;
        if (options instanceof InsertOptions) {
            InsertOptions insertOptions = (InsertOptions)options;
            insertNulls = insertOptions.isInsertNulls();
        }
        if (insertNulls) {
            LinkedHashMap toInsert = new LinkedHashMap();
            entityWriter.write(objectToInsert, toInsert, entity);
            for (Map.Entry entry : toInsert.entrySet()) {
                insert.value((String)entry.getKey(), entry.getValue());
            }
        } else {
            entityWriter.write(objectToInsert, insert);
        }
        return insert;
    }

    static Update createUpdateQuery(String tableName, Object objectToUpdate, WriteOptions options, EntityWriter<Object, Object> entityWriter) {
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull((Object)objectToUpdate, (String)"Object to update must not be null");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Update update = QueryUtils.addWriteOptions(QueryBuilder.update((String)tableName), options);
        entityWriter.write(objectToUpdate, (Object)update);
        return update;
    }

    static Delete createDeleteQuery(String tableName, Object objectToDelete, QueryOptions options, EntityWriter<Object, Object> entityWriter) {
        Assert.hasText((String)tableName, (String)"TableName must not be empty");
        Assert.notNull((Object)objectToDelete, (String)"Object to delete must not be null");
        Assert.notNull(entityWriter, (String)"EntityWriter must not be null");
        Delete.Selection deleteSelection = QueryBuilder.delete();
        Delete delete = deleteSelection.from(tableName);
        if (options instanceof WriteOptions) {
            QueryOptionsUtil.addWriteOptions(delete, (WriteOptions)options);
        } else {
            QueryOptionsUtil.addQueryOptions(delete, options);
        }
        Delete.Where where = delete.where();
        entityWriter.write(objectToDelete, (Object)where);
        return delete;
    }

    static <T> Slice<T> readSlice(ResultSet resultSet, RowMapper<T> mapper, int page, int pageSize) {
        int toRead = resultSet.getAvailableWithoutFetching();
        return QueryUtils.readSlice(() -> Iterators.limit((Iterator)resultSet.iterator(), (int)toRead), resultSet.getExecutionInfo().getPagingState(), mapper, page, pageSize);
    }

    static <T> Slice<T> readSlice(Iterable<Row> rows, @Nullable PagingState pagingState, RowMapper<T> mapper, int page, int pageSize) {
        ArrayList<T> result = new ArrayList<T>(pageSize);
        Iterator<Row> iterator = rows.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            T element = mapper.mapRow(iterator.next(), index++);
            result.add(element);
        }
        CassandraPageRequest pageRequest = CassandraPageRequest.of((Pageable)PageRequest.of((int)page, (int)pageSize), pagingState);
        return new SliceImpl(result, (Pageable)pageRequest, pagingState != null);
    }

    static CqlIdentifier getTableName(Statement statement) {
        Select select2;
        DirectFieldAccessor accessor;
        String table;
        if (statement instanceof Select && (table = (String)(accessor = new DirectFieldAccessor((Object)(select2 = (Select)statement))).getPropertyValue("table")) != null) {
            return CqlIdentifier.of(table);
        }
        String cql = statement.toString();
        Matcher matcher = FROM_REGEX.matcher(cql);
        if (matcher.find()) {
            String cqlTableName = matcher.group(1);
            if (cqlTableName.startsWith("\"")) {
                return CqlIdentifier.quoted(cqlTableName.substring(1, cqlTableName.length() - 1));
            }
            int separator = cqlTableName.indexOf(46);
            if (separator != -1) {
                return CqlIdentifier.of(cqlTableName.substring(separator + 1));
            }
            return CqlIdentifier.of(cqlTableName);
        }
        return CqlIdentifier.of("unknown");
    }

    static Insert addWriteOptions(Insert insert, WriteOptions writeOptions) {
        InsertOptions insertOptions;
        Assert.notNull((Object)insert, (String)"Insert must not be null");
        if (writeOptions instanceof InsertOptions && (insertOptions = (InsertOptions)writeOptions).isIfNotExists()) {
            insert = insert.ifNotExists();
        }
        QueryOptionsUtil.addWriteOptions(insert, writeOptions);
        return insert;
    }

    static Update addWriteOptions(Update update, WriteOptions writeOptions) {
        UpdateOptions updateOptions;
        Assert.notNull((Object)update, (String)"Update must not be null");
        QueryOptionsUtil.addWriteOptions(update, writeOptions);
        if (writeOptions instanceof UpdateOptions && (updateOptions = (UpdateOptions)writeOptions).isIfExists()) {
            update.where().ifExists();
        }
        return update;
    }

    static Delete addWriteOptions(Delete delete, WriteOptions writeOptions) {
        Assert.notNull((Object)delete, (String)"Delete must not be null");
        QueryOptionsUtil.addQueryOptions(delete, writeOptions);
        return delete;
    }
}

