/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleValue;
import org.springframework.data.cassandra.core.convert.CassandraValueProvider;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CassandraTupleValueProvider
implements CassandraValueProvider {
    private final CodecRegistry codecRegistry;
    private final SpELExpressionEvaluator evaluator;
    private final TupleValue tupleValue;

    public CassandraTupleValueProvider(TupleValue tupleValue, CodecRegistry codecRegistry, SpELExpressionEvaluator evaluator) {
        Assert.notNull((Object)tupleValue, (String)"TupleValue must not be null");
        Assert.notNull((Object)codecRegistry, (String)"CodecRegistry must not be null");
        Assert.notNull((Object)evaluator, (String)"SpELExpressionEvaluator must not be null");
        this.tupleValue = tupleValue;
        this.codecRegistry = codecRegistry;
        this.evaluator = evaluator;
    }

    @Nullable
    public <T> T getPropertyValue(CassandraPersistentProperty property) {
        String spelExpression = property.getSpelExpression();
        if (spelExpression != null) {
            return (T)this.evaluator.evaluate(spelExpression);
        }
        int ordinal = property.getRequiredOrdinal();
        DataType elementType = (DataType)this.tupleValue.getType().getComponentTypes().get(ordinal);
        return (T)this.tupleValue.get(ordinal, this.codecRegistry.codecFor(elementType));
    }

    @Override
    public boolean hasProperty(CassandraPersistentProperty property) {
        return this.tupleValue.getType().getComponentTypes().size() >= property.getRequiredOrdinal();
    }
}

