/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Truncate;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.ReactiveResultSet;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.data.cassandra.ReactiveSessionFactory;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.QueryUtils;
import org.springframework.data.cassandra.core.ReactiveCassandraBatchOperations;
import org.springframework.data.cassandra.core.ReactiveCassandraBatchTemplate;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.ReactiveDeleteOperation;
import org.springframework.data.cassandra.core.ReactiveDeleteOperationSupport;
import org.springframework.data.cassandra.core.ReactiveInsertOperation;
import org.springframework.data.cassandra.core.ReactiveInsertOperationSupport;
import org.springframework.data.cassandra.core.ReactiveSelectOperation;
import org.springframework.data.cassandra.core.ReactiveSelectOperationSupport;
import org.springframework.data.cassandra.core.ReactiveUpdateOperation;
import org.springframework.data.cassandra.core.ReactiveUpdateOperationSupport;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.ReactiveCqlOperations;
import org.springframework.data.cassandra.core.cql.ReactiveCqlTemplate;
import org.springframework.data.cassandra.core.cql.ReactiveSessionCallback;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.cql.session.DefaultReactiveSessionFactory;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.event.AfterConvertEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterLoadEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveCassandraTemplate
implements ReactiveCassandraOperations,
ApplicationEventPublisherAware {
    private final CassandraConverter converter;
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final ReactiveCqlOperations cqlOperations;
    private final StatementFactory statementFactory;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    @Nullable
    private ApplicationEventPublisher eventPublisher;

    public ReactiveCassandraTemplate(ReactiveSession session) {
        this(session, (CassandraConverter)ReactiveCassandraTemplate.newConverter());
    }

    public ReactiveCassandraTemplate(ReactiveSession session, CassandraConverter converter) {
        this(new DefaultReactiveSessionFactory(session), converter);
    }

    public ReactiveCassandraTemplate(ReactiveSessionFactory sessionFactory, CassandraConverter converter) {
        this(new ReactiveCqlTemplate(sessionFactory), converter);
    }

    public ReactiveCassandraTemplate(ReactiveCqlOperations reactiveCqlOperations, CassandraConverter converter) {
        Assert.notNull((Object)reactiveCqlOperations, (String)"ReactiveCqlOperations must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.cqlOperations = reactiveCqlOperations;
        this.mappingContext = this.converter.getMappingContext();
        this.statementFactory = new StatementFactory(new QueryMapper(converter), new UpdateMapper(converter));
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
    }

    @Override
    public ReactiveCassandraBatchOperations batchOps() {
        return new ReactiveCassandraBatchTemplate(this);
    }

    @Override
    public CassandraConverter getConverter() {
        return this.converter;
    }

    @Override
    public ReactiveCqlOperations getReactiveCqlOperations() {
        return this.cqlOperations;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    @Override
    public <T> Flux<T> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        return this.select((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> Mono<T> selectOne(String cql, Class<T> entityClass) {
        return this.select(cql, entityClass).next();
    }

    @Override
    public <T> Flux<T> select(Statement cql, Class<T> entityClass) {
        Assert.notNull((Object)cql, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(entityClass, entityClass, QueryUtils.getTableName(cql));
        return this.getReactiveCqlOperations().query(cql, (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> Mono<Slice<T>> slice(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Mono<ReactiveResultSet> resultSetMono = this.getReactiveCqlOperations().queryForResultSet(statement);
        Mono<Integer> effectiveFetchSizeMono = this.getEffectiveFetchSize(statement);
        RowMapper<Object> rowMapper = (row, i) -> this.getConverter().read(entityClass, row);
        return resultSetMono.zipWith(effectiveFetchSizeMono).flatMap(tuple -> {
            ReactiveResultSet resultSet = (ReactiveResultSet)tuple.getT1();
            Integer effectiveFetchSize = (Integer)tuple.getT2();
            return resultSet.availableRows().collectList().map(it -> QueryUtils.readSlice(it, resultSet.getExecutionInfo().getPagingState(), rowMapper, 1, effectiveFetchSize));
        }).defaultIfEmpty((Object)new SliceImpl(Collections.emptyList()));
    }

    @Override
    public <T> Mono<T> selectOne(Statement statement, Class<T> entityClass) {
        return this.select(statement, entityClass).next();
    }

    @Override
    public <T> Flux<T> select(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doSelect(query2, entityClass, this.getTableName(entityClass), entityClass);
    }

    <T> Flux<T> doSelect(Query query2, Class<?> entityClass, CqlIdentifier tableName, Class<T> returnType) {
        RegularStatement select2 = this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        Function mapper = this.getMapper(entityClass, returnType, tableName);
        return this.getReactiveCqlOperations().query((Statement)select2, (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> Mono<Slice<T>> slice(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        RegularStatement select2 = this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass));
        return this.slice((Statement)select2, entityClass);
    }

    @Override
    public <T> Mono<T> selectOne(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select(query2, entityClass).next();
    }

    @Override
    public Mono<Boolean> update(Query query2, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doUpdate(query2, update, entityClass, this.getTableName(entityClass)).map(WriteResult::wasApplied);
    }

    Mono<WriteResult> doUpdate(Query query2, Update update, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement statement = this.getStatementFactory().update(query2, update, this.getRequiredPersistentEntity(entityClass), tableName);
        return this.getReactiveCqlOperations().execute(new StatementCallback((Statement)statement)).next();
    }

    @Override
    public Mono<Boolean> delete(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doDelete(query2, entityClass, this.getTableName(entityClass)).map(WriteResult::wasApplied);
    }

    Mono<WriteResult> doDelete(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement delete = this.getStatementFactory().delete(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        Mono writeResult = this.getReactiveCqlOperations().execute(new StatementCallback((Statement)delete)).doOnSubscribe(it -> this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entityClass, tableName))).next();
        return writeResult.doOnNext(it -> this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entityClass, tableName)));
    }

    @Override
    public Mono<Long> count(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Select select2 = QueryBuilder.select().countAll().from(this.getTableName(entityClass).toCql());
        return this.getReactiveCqlOperations().queryForObject((Statement)select2, Long.class);
    }

    @Override
    public Mono<Long> count(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doCount(query2, entityClass, this.getTableName(entityClass));
    }

    Mono<Long> doCount(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement count = this.getStatementFactory().count(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        return this.getReactiveCqlOperations().queryForObject((Statement)count, Long.class).switchIfEmpty(Mono.just((Object)0L));
    }

    @Override
    public Mono<Boolean> exists(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        Select select2 = QueryBuilder.select().from(entity.getTableName().toCql());
        this.getConverter().write(id, select2.where(), entity);
        return this.getReactiveCqlOperations().queryForRows((Statement)select2).hasElements();
    }

    @Override
    public Mono<Boolean> exists(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doExists(query2, entityClass, this.getTableName(entityClass));
    }

    Mono<Boolean> doExists(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        RegularStatement select2 = this.getStatementFactory().select(query2.limit(1L), this.getRequiredPersistentEntity(entityClass), tableName);
        return this.getReactiveCqlOperations().queryForRows((Statement)select2).hasElements();
    }

    @Override
    public <T> Mono<T> selectOneById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        Select select2 = QueryBuilder.select().all().from(entity.getTableName().toCql());
        this.getConverter().write(id, select2.where(), entity);
        return this.selectOne((Statement)select2, entityClass);
    }

    @Override
    public <T> Mono<T> insert(T entity) {
        return this.insert(entity, InsertOptions.empty()).map(EntityWriteResult::getEntity);
    }

    @Override
    public <T> Mono<EntityWriteResult<T>> insert(T entity, InsertOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"InsertOptions must not be null");
        return this.doInsert(entity, options, this.getTableName(entity));
    }

    <T> Mono<EntityWriteResult<T>> doInsert(T entity, WriteOptions options, CqlIdentifier tableName) {
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        Insert insert = QueryUtils.createInsertQuery(tableName.toCql(), entity, options, this.getConverter(), persistentEntity);
        Mono result = this.getReactiveCqlOperations().execute(new StatementCallback((Statement)insert)).doOnSubscribe(it -> this.maybeEmitEvent(new BeforeSaveEvent<Object>(entity, tableName, (Statement)insert))).map(it -> EntityWriteResult.of(it, entity)).next();
        return result.doOnNext(it -> this.maybeEmitEvent(new AfterSaveEvent<Object>(entity, tableName)));
    }

    @Override
    public <T> Mono<T> update(T entity) {
        return this.update(entity, UpdateOptions.empty()).map(writeResult -> entity);
    }

    @Override
    public <T> Mono<EntityWriteResult<T>> update(T entity, UpdateOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"UpdateOptions must not be null");
        CqlIdentifier tableName = this.getTableName(entity);
        com.datastax.driver.core.querybuilder.Update update = QueryUtils.createUpdateQuery(tableName.toCql(), entity, options, (EntityWriter<Object, Object>)this.getConverter());
        Mono result = this.getReactiveCqlOperations().execute(new StatementCallback((Statement)update)).doOnSubscribe(it -> this.maybeEmitEvent(new BeforeSaveEvent<Object>(entity, tableName, (Statement)update))).map(it -> EntityWriteResult.of(it, entity)).next();
        return result.doOnNext(it -> this.maybeEmitEvent(new AfterSaveEvent<Object>(entity, tableName)));
    }

    @Override
    public <T> Mono<T> delete(T entity) {
        return this.delete(entity, QueryOptions.empty()).map(reactiveWriteResult -> entity);
    }

    @Override
    public Mono<WriteResult> delete(Object entity, QueryOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        CqlIdentifier tableName = this.getTableName(entity);
        Delete delete = QueryUtils.createDeleteQuery(tableName.toCql(), entity, options, (EntityWriter<Object, Object>)this.getConverter());
        Mono result = this.getReactiveCqlOperations().execute(new StatementCallback((Statement)delete)).doOnSubscribe(it -> this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entity.getClass(), tableName))).next();
        return result.doOnNext(it -> this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entity.getClass(), tableName)));
    }

    @Override
    public Mono<Boolean> deleteById(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        Delete delete = QueryBuilder.delete().from(tableName.toCql());
        this.getConverter().write(id, delete.where(), entity);
        Mono result = this.getReactiveCqlOperations().execute((Statement)delete).doOnSubscribe(it -> this.maybeEmitEvent(new BeforeDeleteEvent((Statement)delete, entityClass, tableName)));
        return result.doOnNext(it -> this.maybeEmitEvent(new AfterDeleteEvent((Statement)delete, entityClass, tableName)));
    }

    @Override
    public Mono<Void> truncate(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CqlIdentifier tableName = this.getTableName(entityClass);
        Truncate truncate = QueryBuilder.truncate((String)tableName.toCql());
        Mono result = this.getReactiveCqlOperations().execute((Statement)truncate).doOnSubscribe(it -> this.maybeEmitEvent(new BeforeDeleteEvent((Statement)truncate, entityClass, tableName)));
        return result.doOnNext(it -> this.maybeEmitEvent(new AfterDeleteEvent((Statement)truncate, entityClass, tableName))).then();
    }

    @Override
    public <T> ReactiveSelectOperation.ReactiveSelect<T> query(Class<T> domainType) {
        return new ReactiveSelectOperationSupport(this).query(domainType);
    }

    @Override
    public <T> ReactiveInsertOperation.ReactiveInsert<T> insert(Class<T> domainType) {
        return new ReactiveInsertOperationSupport(this).insert(domainType);
    }

    @Override
    public ReactiveUpdateOperation.ReactiveUpdate update(Class<?> domainType) {
        return new ReactiveUpdateOperationSupport(this).update(domainType);
    }

    @Override
    public ReactiveDeleteOperation.ReactiveDelete delete(Class<?> domainType) {
        return new ReactiveDeleteOperationSupport(this).delete(domainType);
    }

    protected MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected SpelAwareProxyProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    CqlIdentifier getTableName(Class<?> entityClass) {
        return this.getRequiredPersistentEntity(entityClass).getTableName();
    }

    private CqlIdentifier getTableName(Object entity) {
        return this.getRequiredPersistentEntity(entity.getClass()).getTableName();
    }

    private CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityType) {
        return (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entityType));
    }

    private <T> Function<Row, T> getMapper(Class<?> entityType, Class<T> targetType, CqlIdentifier tableName) {
        Class<?> typeToRead = this.resolveTypeToRead(entityType, targetType);
        return row -> {
            Object result;
            this.maybeEmitEvent(new AfterLoadEvent((Row)row, targetType, tableName));
            Object source = this.getConverter().read(typeToRead, row);
            Object object = result = targetType.isInterface() ? this.getProjectionFactory().createProjection(targetType, source) : source;
            if (result != null) {
                this.maybeEmitEvent(new AfterConvertEvent<Object>((Row)row, result, tableName));
            }
            return result;
        };
    }

    private Class<?> resolveTypeToRead(Class<?> entityType, Class<?> targetType) {
        return targetType.isInterface() || targetType.isAssignableFrom(entityType) ? entityType : targetType;
    }

    private void maybeEmitEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    private static MappingCassandraConverter newConverter() {
        MappingCassandraConverter converter = new MappingCassandraConverter();
        converter.afterPropertiesSet();
        return converter;
    }

    private Mono<Integer> getEffectiveFetchSize(Statement statement) {
        CassandraAccessor accessor;
        if (statement.getFetchSize() > 0) {
            return Mono.just((Object)statement.getFetchSize());
        }
        if (this.getReactiveCqlOperations() instanceof CassandraAccessor && (accessor = (CassandraAccessor)((Object)this.getReactiveCqlOperations())).getFetchSize() != -1) {
            return Mono.just((Object)accessor.getFetchSize());
        }
        return this.getReactiveCqlOperations().execute(session -> Mono.just((Object)session.getCluster().getConfiguration().getQueryOptions().getFetchSize())).single();
    }

    static final class StatementCallback
    implements ReactiveSessionCallback<WriteResult>,
    CqlProvider {
        @NonNull
        private final Statement statement;

        @Override
        public Publisher<WriteResult> doInSession(ReactiveSession session) throws DriverException, DataAccessException {
            return session.execute(this.statement).flatMap(StatementCallback::toWriteResult);
        }

        @Override
        public String getCql() {
            return this.statement.toString();
        }

        private static Mono<WriteResult> toWriteResult(ReactiveResultSet resultSet) {
            return resultSet.rows().collectList().map(rows -> new WriteResult(resultSet.getAllExecutionInfo(), resultSet.wasApplied(), (List<Row>)rows));
        }

        public StatementCallback(@NonNull Statement statement) {
            if (statement == null) {
                throw new NullPointerException("statement is marked @NonNull but is null");
            }
            this.statement = statement;
        }

        @NonNull
        public Statement getStatement() {
            return this.statement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementCallback)) {
                return false;
            }
            StatementCallback other = (StatementCallback)o;
            Statement this$statement = this.getStatement();
            Statement other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Statement $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            return result;
        }

        public String toString() {
            return "ReactiveCassandraTemplate.StatementCallback(statement=" + this.getStatement() + ")";
        }
    }
}

