/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TimestampGenerator;
import com.datastax.driver.core.policies.AddressTranslator;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.cassandra.config.CassandraCqlClusterFactoryBean;
import org.springframework.data.cassandra.config.ClusterBuilderConfigurer;
import org.springframework.data.cassandra.config.CompressionType;
import org.springframework.data.cassandra.config.KeyspaceActions;
import org.springframework.data.cassandra.core.cql.CassandraExceptionTranslator;
import org.springframework.data.cassandra.core.cql.CqlTemplate;
import org.springframework.data.cassandra.core.cql.generator.AlterKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.CreateKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.AlterKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceActionSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceOptionsSpecification;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CassandraClusterFactoryBean
implements FactoryBean<Cluster>,
InitializingBean,
DisposableBean,
BeanNameAware,
PersistenceExceptionTranslator {
    public static final boolean DEFAULT_JMX_REPORTING_ENABLED = true;
    public static final boolean DEFAULT_METRICS_ENABLED = true;
    public static final boolean DEFAULT_SSL_ENABLED = false;
    public static final int DEFAULT_MAX_SCHEMA_AGREEMENT_WAIT_SECONDS = 10;
    public static final int DEFAULT_PORT = 9042;
    public static final String DEFAULT_CONTACT_POINTS = "localhost";
    protected static final Logger log = LoggerFactory.getLogger(CassandraCqlClusterFactoryBean.class);
    private boolean jmxReportingEnabled = true;
    private boolean metricsEnabled = true;
    private boolean sslEnabled = false;
    private int maxSchemaAgreementWaitSeconds = 10;
    private int port = 9042;
    private final PersistenceExceptionTranslator exceptionTranslator = new CassandraExceptionTranslator();
    @Nullable
    private Cluster cluster;
    @Nullable
    private ClusterBuilderConfigurer clusterBuilderConfigurer;
    @Nullable
    private AddressTranslator addressTranslator;
    @Nullable
    private AuthProvider authProvider;
    @Nullable
    private CompressionType compressionType;
    @Nullable
    private Host.StateListener hostStateListener;
    @Nullable
    private LatencyTracker latencyTracker;
    private List<CreateKeyspaceSpecification> keyspaceCreations = new ArrayList<CreateKeyspaceSpecification>();
    private List<AlterKeyspaceSpecification> keyspaceAlterations = new ArrayList<AlterKeyspaceSpecification>();
    private List<DropKeyspaceSpecification> keyspaceDrops = new ArrayList<DropKeyspaceSpecification>();
    private Set<KeyspaceActionSpecification> keyspaceSpecifications = new HashSet<KeyspaceActionSpecification>();
    private List<KeyspaceActions> keyspaceActions = new ArrayList<KeyspaceActions>();
    private List<String> startupScripts = new ArrayList<String>();
    private List<String> shutdownScripts = new ArrayList<String>();
    @Nullable
    private LoadBalancingPolicy loadBalancingPolicy;
    private NettyOptions nettyOptions = NettyOptions.DEFAULT_INSTANCE;
    @Nullable
    private PoolingOptions poolingOptions;
    @Nullable
    private ProtocolVersion protocolVersion;
    @Nullable
    private QueryOptions queryOptions;
    @Nullable
    private ReconnectionPolicy reconnectionPolicy;
    @Nullable
    private RetryPolicy retryPolicy;
    @Nullable
    private SpeculativeExecutionPolicy speculativeExecutionPolicy;
    @Nullable
    private SocketOptions socketOptions;
    @Nullable
    private SSLOptions sslOptions;
    @Nullable
    private TimestampGenerator timestampGenerator;
    @Nullable
    private String beanName;
    @Nullable
    private String clusterName;
    private String contactPoints = "localhost";
    @Nullable
    private String password;
    @Nullable
    private String username;

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.contactPoints, (String)"At least one server is required");
        Cluster.Builder clusterBuilder = this.newClusterBuilder();
        clusterBuilder.addContactPoints(StringUtils.commaDelimitedListToStringArray((String)this.contactPoints)).withPort(this.port);
        clusterBuilder.withMaxSchemaAgreementWaitSeconds(this.maxSchemaAgreementWaitSeconds);
        Optional.ofNullable(this.compressionType).map(CassandraClusterFactoryBean::convertCompressionType).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withCompression(arg_0));
        Optional.ofNullable(this.addressTranslator).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withAddressTranslator(arg_0));
        Optional.ofNullable(this.loadBalancingPolicy).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withLoadBalancingPolicy(arg_0));
        clusterBuilder.withNettyOptions(this.nettyOptions);
        Optional.ofNullable(this.poolingOptions).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withPoolingOptions(arg_0));
        Optional.ofNullable(this.protocolVersion).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withProtocolVersion(arg_0));
        Optional.ofNullable(this.queryOptions).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withQueryOptions(arg_0));
        Optional.ofNullable(this.reconnectionPolicy).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withReconnectionPolicy(arg_0));
        Optional.ofNullable(this.retryPolicy).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withRetryPolicy(arg_0));
        Optional.ofNullable(this.socketOptions).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withSocketOptions(arg_0));
        Optional.ofNullable(this.speculativeExecutionPolicy).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withSpeculativeExecutionPolicy(arg_0));
        Optional.ofNullable(this.timestampGenerator).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withTimestampGenerator(arg_0));
        if (this.authProvider != null) {
            clusterBuilder.withAuthProvider(this.authProvider);
        } else if (this.username != null) {
            clusterBuilder.withCredentials(this.username, this.password);
        }
        if (!this.jmxReportingEnabled) {
            clusterBuilder.withoutJMXReporting();
        }
        if (!this.metricsEnabled) {
            clusterBuilder.withoutMetrics();
        }
        if (this.sslEnabled) {
            if (this.sslOptions != null) {
                clusterBuilder.withSSL(this.sslOptions);
            } else {
                clusterBuilder.withSSL();
            }
        }
        Optional.ofNullable(this.resolveClusterName()).filter(StringUtils::hasText).ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withClusterName(arg_0));
        if (this.clusterBuilderConfigurer != null) {
            this.clusterBuilderConfigurer.configure(clusterBuilder);
        }
        this.cluster = clusterBuilder.build();
        Optional.ofNullable(this.hostStateListener).ifPresent(arg_0 -> ((Cluster)this.cluster).register(arg_0));
        Optional.ofNullable(this.latencyTracker).ifPresent(arg_0 -> ((Cluster)this.cluster).register(arg_0));
        this.generateSpecificationsFromFactoryBeans();
        ArrayList<KeyspaceOptionsSpecification> startup = new ArrayList<KeyspaceOptionsSpecification>(this.keyspaceCreations.size() + this.keyspaceAlterations.size());
        startup.addAll(this.keyspaceCreations);
        startup.addAll(this.keyspaceAlterations);
        this.executeSpecsAndScripts(startup, this.startupScripts, this.cluster);
    }

    Cluster.Builder newClusterBuilder() {
        return Cluster.builder();
    }

    @Nullable
    private String resolveClusterName() {
        return StringUtils.hasText((String)this.clusterName) ? this.clusterName : this.beanName;
    }

    public void destroy() {
        if (this.cluster != null) {
            this.executeSpecsAndScripts(this.keyspaceDrops, this.shutdownScripts, this.cluster);
            this.cluster.close();
        }
    }

    public Cluster getObject() {
        return this.cluster;
    }

    public Class<? extends Cluster> getObjectType() {
        return this.cluster != null ? this.cluster.getClass() : Cluster.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    private void generateSpecificationsFromFactoryBeans() {
        this.generateSpecifications(this.keyspaceSpecifications);
        this.keyspaceActions.forEach(actions -> this.generateSpecifications(actions.getActions()));
    }

    private void generateSpecifications(Collection<KeyspaceActionSpecification> specifications) {
        specifications.forEach(keyspaceActionSpecification -> {
            if (keyspaceActionSpecification instanceof CreateKeyspaceSpecification) {
                this.keyspaceCreations.add((CreateKeyspaceSpecification)keyspaceActionSpecification);
            }
            if (keyspaceActionSpecification instanceof DropKeyspaceSpecification) {
                this.keyspaceDrops.add((DropKeyspaceSpecification)keyspaceActionSpecification);
            }
            if (keyspaceActionSpecification instanceof AlterKeyspaceSpecification) {
                this.keyspaceAlterations.add((AlterKeyspaceSpecification)keyspaceActionSpecification);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSpecsAndScripts(List<? extends KeyspaceActionSpecification> keyspaceActionSpecifications, List<String> scripts, Cluster cluster) {
        if (!CollectionUtils.isEmpty(keyspaceActionSpecifications) || !CollectionUtils.isEmpty(scripts)) {
            try (Session session = cluster.connect();){
                CqlTemplate template = new CqlTemplate(session);
                keyspaceActionSpecifications.forEach(keyspaceActionSpecification -> template.execute(this.toCql((KeyspaceActionSpecification)keyspaceActionSpecification)));
                scripts.forEach(template::execute);
            }
        }
    }

    private String toCql(KeyspaceActionSpecification specification) {
        if (specification instanceof CreateKeyspaceSpecification) {
            return new CreateKeyspaceCqlGenerator((CreateKeyspaceSpecification)specification).toCql();
        }
        if (specification instanceof DropKeyspaceSpecification) {
            return new DropKeyspaceCqlGenerator((DropKeyspaceSpecification)specification).toCql();
        }
        if (specification instanceof AlterKeyspaceSpecification) {
            return new AlterKeyspaceCqlGenerator((AlterKeyspaceSpecification)specification).toCql();
        }
        throw new IllegalArgumentException("Unsupported specification type: " + ClassUtils.getQualifiedName(specification.getClass()));
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setContactPoints(String contactPoints) {
        this.contactPoints = contactPoints;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setCompressionType(@Nullable CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public void setPoolingOptions(@Nullable PoolingOptions poolingOptions) {
        this.poolingOptions = poolingOptions;
    }

    public void setProtocolVersion(@Nullable ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setSocketOptions(@Nullable SocketOptions socketOptions) {
        this.socketOptions = socketOptions;
    }

    public void setQueryOptions(@Nullable QueryOptions queryOptions) {
        this.queryOptions = queryOptions;
    }

    public void setAuthProvider(@Nullable AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    public void setNettyOptions(NettyOptions nettyOptions) {
        this.nettyOptions = nettyOptions;
    }

    public void setLoadBalancingPolicy(@Nullable LoadBalancingPolicy loadBalancingPolicy) {
        this.loadBalancingPolicy = loadBalancingPolicy;
    }

    public void setReconnectionPolicy(@Nullable ReconnectionPolicy reconnectionPolicy) {
        this.reconnectionPolicy = reconnectionPolicy;
    }

    public void setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public List<KeyspaceActions> getKeyspaceActions() {
        return Collections.unmodifiableList(this.keyspaceActions);
    }

    public void setKeyspaceActions(List<KeyspaceActions> keyspaceActions) {
        this.keyspaceActions = new ArrayList<KeyspaceActions>(keyspaceActions);
    }

    public void setKeyspaceCreations(List<CreateKeyspaceSpecification> specifications) {
        this.keyspaceCreations = new ArrayList<CreateKeyspaceSpecification>(specifications);
    }

    public List<CreateKeyspaceSpecification> getKeyspaceCreations() {
        return Collections.unmodifiableList(this.keyspaceCreations);
    }

    public void setKeyspaceDrops(List<DropKeyspaceSpecification> specifications) {
        this.keyspaceDrops = new ArrayList<DropKeyspaceSpecification>(specifications);
    }

    public List<DropKeyspaceSpecification> getKeyspaceDrops() {
        return Collections.unmodifiableList(this.keyspaceDrops);
    }

    public void setStartupScripts(List<String> scripts) {
        this.startupScripts = new ArrayList<String>(scripts);
    }

    public List<String> getStartupScripts() {
        return Collections.unmodifiableList(this.startupScripts);
    }

    public void setShutdownScripts(List<String> scripts) {
        this.shutdownScripts = new ArrayList<String>(scripts);
    }

    public List<String> getShutdownScripts() {
        return Collections.unmodifiableList(this.shutdownScripts);
    }

    public void setKeyspaceSpecifications(Set<KeyspaceActionSpecification> keyspaceSpecifications) {
        this.keyspaceSpecifications = new LinkedHashSet<KeyspaceActionSpecification>(keyspaceSpecifications);
    }

    public Set<KeyspaceActionSpecification> getKeyspaceSpecifications() {
        return Collections.unmodifiableSet(this.keyspaceSpecifications);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJmxReportingEnabled(boolean jmxReportingEnabled) {
        this.jmxReportingEnabled = jmxReportingEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public void setSslOptions(SSLOptions sslOptions) {
        this.sslOptions = sslOptions;
    }

    public void setHostStateListener(Host.StateListener hostStateListener) {
        this.hostStateListener = hostStateListener;
    }

    public void setLatencyTracker(LatencyTracker latencyTracker) {
        this.latencyTracker = latencyTracker;
    }

    public void setAddressTranslator(@Nullable AddressTranslator addressTranslator) {
        this.addressTranslator = addressTranslator;
    }

    public void setClusterBuilderConfigurer(@Nullable ClusterBuilderConfigurer clusterBuilderConfigurer) {
        this.clusterBuilderConfigurer = clusterBuilderConfigurer;
    }

    public void setClusterName(@Nullable String clusterName) {
        this.clusterName = clusterName;
    }

    public void setMaxSchemaAgreementWaitSeconds(int seconds) {
        this.maxSchemaAgreementWaitSeconds = seconds;
    }

    public void setSpeculativeExecutionPolicy(@Nullable SpeculativeExecutionPolicy speculativeExecutionPolicy) {
        this.speculativeExecutionPolicy = speculativeExecutionPolicy;
    }

    public void setTimestampGenerator(@Nullable TimestampGenerator timestampGenerator) {
        this.timestampGenerator = timestampGenerator;
    }

    private static ProtocolOptions.Compression convertCompressionType(CompressionType type) {
        switch (type) {
            case NONE: {
                return ProtocolOptions.Compression.NONE;
            }
            case SNAPPY: {
                return ProtocolOptions.Compression.SNAPPY;
            }
            case LZ4: {
                return ProtocolOptions.Compression.LZ4;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown compression type [%s]", new Object[]{type}));
    }
}

