/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.support;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.DriverException;
import org.springframework.data.cassandra.core.cql.PreparedStatementCreator;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.QueryOptionsUtil;
import org.springframework.data.cassandra.core.cql.support.PreparedStatementCache;
import org.springframework.util.Assert;

public class CachedPreparedStatementCreator
implements PreparedStatementCreator {
    private final PreparedStatementCache cache;
    private final RegularStatement statement;

    protected CachedPreparedStatementCreator(PreparedStatementCache cache, RegularStatement statement) {
        Assert.notNull((Object)cache, (String)"Cache must not be null");
        this.cache = cache;
        this.statement = statement;
    }

    public static CachedPreparedStatementCreator of(PreparedStatementCache cache, RegularStatement statement) {
        Assert.notNull((Object)cache, (String)"Cache must not be null");
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        return new CachedPreparedStatementCreator(cache, statement);
    }

    public static CachedPreparedStatementCreator of(PreparedStatementCache cache, String cql) {
        Assert.notNull((Object)cache, (String)"Cache must not be null");
        Assert.hasText((String)cql, (String)"CQL statement is required");
        return new CachedPreparedStatementCreator(cache, (RegularStatement)new SimpleStatement(cql));
    }

    public static CachedPreparedStatementCreator of(PreparedStatementCache cache, String cql, QueryOptions queryOptions) {
        Assert.notNull((Object)cache, (String)"Cache must not be null");
        Assert.hasText((String)cql, (String)"CQL statement is required");
        Assert.notNull((Object)queryOptions, (String)"QueryOptions must not be null");
        return new CachedPreparedStatementCreator(cache, (RegularStatement)QueryOptionsUtil.addQueryOptions(new SimpleStatement(cql), queryOptions));
    }

    public PreparedStatementCache getCache() {
        return this.cache;
    }

    @Override
    public PreparedStatement createPreparedStatement(Session session) throws DriverException {
        return this.getCache().getPreparedStatement(session, this.statement);
    }
}

