/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.Host;
import java.io.Serializable;
import org.springframework.util.Assert;

public final class RingMember
implements Serializable {
    private static final long serialVersionUID = -2582309141903132916L;
    private final String hostName;
    private final String address;
    private final String dc;
    private final String rack;

    public static RingMember from(Host host) {
        return new RingMember(host);
    }

    private RingMember(Host host) {
        Assert.notNull((Object)host, (String)"Host must not be null");
        this.hostName = host.getAddress().getHostName();
        this.address = host.getAddress().getHostAddress();
        this.dc = host.getDatacenter();
        this.rack = host.getRack();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getAddress() {
        return this.address;
    }

    public String getDataCenter() {
        return this.dc;
    }

    public String getRack() {
        return this.rack;
    }
}

