/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.data.cassandra.core.CassandraBatchOperations;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.QueryUtils;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.convert.EntityWriter;
import org.springframework.util.Assert;

class CassandraBatchTemplate
implements CassandraBatchOperations {
    private final CassandraOperations operations;
    private final AtomicBoolean executed = new AtomicBoolean();
    private final Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);

    CassandraBatchTemplate(CassandraOperations operations) {
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        this.operations = operations;
    }

    @Override
    public WriteResult execute() {
        if (this.executed.compareAndSet(false, true)) {
            return WriteResult.of(this.operations.getCqlOperations().queryForResultSet((Statement)this.batch));
        }
        throw new IllegalStateException("This Cassandra Batch was already executed");
    }

    @Override
    public CassandraBatchOperations withTimestamp(long timestamp) {
        this.assertNotExecuted();
        this.batch.using(QueryBuilder.timestamp((long)timestamp));
        return this;
    }

    @Override
    public CassandraBatchOperations insert(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.insert(Arrays.asList(entities));
    }

    @Override
    public CassandraBatchOperations insert(Iterable<?> entities) {
        return this.insert(entities, InsertOptions.empty());
    }

    @Override
    public CassandraBatchOperations insert(Iterable<?> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        CassandraMappingContext mappingContext = this.operations.getConverter().getMappingContext();
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)mappingContext.getRequiredPersistentEntity(entity.getClass());
            this.batch.add((RegularStatement)QueryUtils.createInsertQuery(persistentEntity.getTableName().toCql(), entity, options, this.operations.getConverter(), persistentEntity));
        }
        return this;
    }

    @Override
    public CassandraBatchOperations update(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.update(Arrays.asList(entities));
    }

    @Override
    public CassandraBatchOperations update(Iterable<?> entities) {
        return this.update(entities, UpdateOptions.empty());
    }

    @Override
    public CassandraBatchOperations update(Iterable<?> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            this.batch.add((RegularStatement)QueryUtils.createUpdateQuery(this.getTableName(entity), entity, options, (EntityWriter<Object, Object>)this.operations.getConverter()));
        }
        return this;
    }

    @Override
    public CassandraBatchOperations delete(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.delete(Arrays.asList(entities));
    }

    @Override
    public CassandraBatchOperations delete(Iterable<?> entities) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            this.batch.add((RegularStatement)QueryUtils.createDeleteQuery(this.getTableName(entity), entity, QueryOptions.empty(), (EntityWriter<Object, Object>)this.operations.getConverter()));
        }
        return this;
    }

    private void assertNotExecuted() {
        Assert.state((!this.executed.get() ? 1 : 0) != 0, (String)"This Cassandra Batch was already executed");
    }

    private String getTableName(Object entity) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        return this.operations.getTableName(entity.getClass()).toCql();
    }
}

