/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.Statement;
import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.DtoInstantiatingConverter;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.ClassUtils;

@FunctionalInterface
interface ReactiveCassandraQueryExecution {
    public Object execute(Statement var1, Class<?> var2);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ResultProcessor processor;
        @NonNull
        private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
        @NonNull
        private final EntityInstantiators instantiators;

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            if (returnedType.isInstance(source)) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.mappingContext, this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }

        @ConstructorProperties(value={"processor", "mappingContext", "instantiators"})
        public ResultProcessingConverter(@NonNull ResultProcessor processor, @NonNull MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext, @NonNull EntityInstantiators instantiators) {
            if (processor == null) {
                throw new NullPointerException("processor");
            }
            if (mappingContext == null) {
                throw new NullPointerException("mappingContext");
            }
            if (instantiators == null) {
                throw new NullPointerException("instantiators");
            }
            this.processor = processor;
            this.mappingContext = mappingContext;
            this.instantiators = instantiators;
        }
    }

    public static final class ResultProcessingExecution
    implements ReactiveCassandraQueryExecution {
        @NonNull
        private final ReactiveCassandraQueryExecution delegate;
        @NonNull
        private final Converter<Object, Object> converter;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.converter.convert(this.delegate.execute(statement, type));
        }

        @ConstructorProperties(value={"delegate", "converter"})
        public ResultProcessingExecution(@NonNull ReactiveCassandraQueryExecution delegate, @NonNull Converter<Object, Object> converter) {
            if (delegate == null) {
                throw new NullPointerException("delegate");
            }
            if (converter == null) {
                throw new NullPointerException("converter");
            }
            this.delegate = delegate;
            this.converter = converter;
        }
    }

    public static final class SingleEntityExecution
    implements ReactiveCassandraQueryExecution {
        @NonNull
        private final ReactiveCassandraOperations operations;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.operations.selectOne(statement, type);
        }

        @ConstructorProperties(value={"operations"})
        public SingleEntityExecution(@NonNull ReactiveCassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            this.operations = operations;
        }
    }

    public static final class CollectionExecution
    implements ReactiveCassandraQueryExecution {
        @NonNull
        private final ReactiveCassandraOperations operations;

        @Override
        public Object execute(Statement statement, Class<?> type) {
            return this.operations.select(statement, type);
        }

        @ConstructorProperties(value={"operations"})
        public CollectionExecution(@NonNull ReactiveCassandraOperations operations) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            this.operations = operations;
        }
    }
}

