/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Truncate;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.ReactiveResultSet;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.data.cassandra.ReactiveSessionFactory;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.QueryUtils;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.ReactiveCqlOperations;
import org.springframework.data.cassandra.core.cql.ReactiveCqlTemplate;
import org.springframework.data.cassandra.core.cql.ReactiveSessionCallback;
import org.springframework.data.cassandra.core.cql.session.DefaultReactiveSessionFactory;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveCassandraTemplate
implements ReactiveCassandraOperations {
    private final CassandraConverter converter;
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final ReactiveCqlOperations cqlOperations;
    private final StatementFactory statementFactory;

    public ReactiveCassandraTemplate(ReactiveSession session) {
        this(session, (CassandraConverter)ReactiveCassandraTemplate.newConverter());
    }

    public ReactiveCassandraTemplate(ReactiveSession session, CassandraConverter converter) {
        this(new DefaultReactiveSessionFactory(session), converter);
    }

    public ReactiveCassandraTemplate(ReactiveSessionFactory sessionFactory, CassandraConverter converter) {
        Assert.notNull((Object)sessionFactory, (String)"ReactiveSessionFactory must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.cqlOperations = new ReactiveCqlTemplate(sessionFactory);
        this.mappingContext = this.converter.getMappingContext();
        this.statementFactory = new StatementFactory(new QueryMapper(converter), new UpdateMapper(converter));
    }

    public ReactiveCassandraTemplate(ReactiveCqlOperations reactiveCqlOperations, CassandraConverter converter) {
        Assert.notNull((Object)reactiveCqlOperations, (String)"ReactiveCqlOperations must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.cqlOperations = reactiveCqlOperations;
        this.mappingContext = this.converter.getMappingContext();
        this.statementFactory = new StatementFactory(new QueryMapper(converter), new UpdateMapper(converter));
    }

    @Override
    public CassandraConverter getConverter() {
        return this.converter;
    }

    private static MappingCassandraConverter newConverter() {
        MappingCassandraConverter converter = new MappingCassandraConverter();
        converter.afterPropertiesSet();
        return converter;
    }

    protected MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public ReactiveCqlOperations getReactiveCqlOperations() {
        return this.cqlOperations;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    private CqlIdentifier getTableName(Object entity) {
        return ((CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass((Object)entity))).getTableName();
    }

    @Override
    public <T> Flux<T> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        return this.select((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> Mono<T> selectOne(String cql, Class<T> entityClass) {
        return this.select(cql, entityClass).next();
    }

    @Override
    public <T> Flux<T> select(Statement cql, Class<T> entityClass) {
        Assert.notNull((Object)cql, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getReactiveCqlOperations().query(cql, (row, rowNum) -> this.getConverter().read(entityClass, row));
    }

    @Override
    public <T> Mono<T> selectOne(Statement statement, Class<T> entityClass) {
        return this.select(statement, entityClass).next();
    }

    @Override
    public <T> Flux<T> select(Query query, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement)this.getStatementFactory().select(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public <T> Mono<T> selectOne(Query query, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement)this.getStatementFactory().select(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public Mono<Boolean> update(Query query, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getReactiveCqlOperations().execute((Statement)this.getStatementFactory().update(query, update, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)));
    }

    @Override
    public Mono<Boolean> delete(Query query, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getReactiveCqlOperations().execute((Statement)this.getStatementFactory().delete(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)));
    }

    @Override
    public Mono<Long> count(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Select select = QueryBuilder.select().countAll().from(((CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)).getTableName().toCql());
        return this.getReactiveCqlOperations().queryForObject((Statement)select, Long.class);
    }

    @Override
    public Mono<Boolean> exists(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass);
        Select select = QueryBuilder.select().from(entity.getTableName().toCql());
        this.getConverter().write(id, select.where(), entity);
        return this.getReactiveCqlOperations().queryForRows((Statement)select).hasElements();
    }

    @Override
    public <T> Mono<T> selectOneById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass);
        Select select = QueryBuilder.select().all().from(entity.getTableName().toCql());
        this.getConverter().write(id, select.where(), entity);
        return this.selectOne((Statement)select, entityClass);
    }

    @Override
    public <T> Mono<T> insert(T entity) {
        return this.insert(entity, InsertOptions.empty()).map(writeResult -> entity);
    }

    @Override
    public Mono<WriteResult> insert(Object entity, InsertOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"InsertOptions must not be null");
        Insert insert = QueryUtils.createInsertQuery(this.getTableName(entity).toCql(), entity, options, (EntityWriter<Object, Object>)this.getConverter());
        return this.getReactiveCqlOperations().execute(new StatementCallback((Statement)insert)).next();
    }

    @Override
    public <T> Mono<T> update(T entity) {
        return this.update(entity, UpdateOptions.empty()).map(writeResult -> entity);
    }

    @Override
    public Mono<WriteResult> update(Object entity, UpdateOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"UpdateOptions must not be null");
        com.datastax.driver.core.querybuilder.Update update = QueryUtils.createUpdateQuery(this.getTableName(entity).toCql(), entity, options, (EntityWriter<Object, Object>)this.converter);
        return this.getReactiveCqlOperations().execute(new StatementCallback((Statement)update)).next();
    }

    @Override
    public <T> Mono<T> delete(T entity) {
        return this.delete(entity, QueryOptions.empty()).map(reactiveWriteResult -> entity);
    }

    @Override
    public Mono<WriteResult> delete(Object entity, QueryOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        Delete delete = QueryUtils.createDeleteQuery(this.getTableName(entity).toCql(), entity, options, (EntityWriter<Object, Object>)this.getConverter());
        return this.getReactiveCqlOperations().execute(new StatementCallback((Statement)delete)).next();
    }

    @Override
    public Mono<Boolean> deleteById(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass);
        Delete delete = QueryBuilder.delete().from(entity.getTableName().toCql());
        this.getConverter().write(id, delete.where(), entity);
        return this.getReactiveCqlOperations().execute((Statement)delete);
    }

    @Override
    public Mono<Void> truncate(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Truncate truncate = QueryBuilder.truncate((String)((CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)).getTableName().toCql());
        return this.getReactiveCqlOperations().execute((Statement)truncate).then();
    }

    static final class StatementCallback
    implements ReactiveSessionCallback<WriteResult>,
    CqlProvider {
        @NonNull
        private final Statement statement;

        @Override
        public Publisher<WriteResult> doInSession(ReactiveSession session) throws DriverException, DataAccessException {
            return session.execute(this.statement).flatMap(StatementCallback::toWriteResult);
        }

        @Override
        public String getCql() {
            return this.statement.toString();
        }

        private static Mono<WriteResult> toWriteResult(ReactiveResultSet resultSet) {
            return resultSet.rows().collectList().map(rows -> new WriteResult(resultSet.getAllExecutionInfo(), resultSet.wasApplied(), (List<Row>)rows));
        }

        @ConstructorProperties(value={"statement"})
        public StatementCallback(@NonNull Statement statement) {
            if (statement == null) {
                throw new NullPointerException("statement");
            }
            this.statement = statement;
        }

        @NonNull
        public Statement getStatement() {
            return this.statement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementCallback)) {
                return false;
            }
            StatementCallback other = (StatementCallback)o;
            Statement this$statement = this.getStatement();
            Statement other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Statement $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            return result;
        }

        public String toString() {
            return "ReactiveCassandraTemplate.StatementCallback(statement=" + this.getStatement() + ")";
        }
    }
}

