/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cassandra.core.util.CollectionUtils;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.repository.TypedIdCassandraRepository;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.util.Assert;

public class SimpleCassandraRepository<T, ID extends Serializable>
implements TypedIdCassandraRepository<T, ID> {
    private final CassandraEntityInformation<T, ID> entityInformation;
    private final CassandraOperations operations;

    public SimpleCassandraRepository(CassandraEntityInformation<T, ID> metadata, CassandraOperations operations) {
        Assert.notNull(metadata, (String)"CassandraEntityInformation must not be null");
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        this.entityInformation = metadata;
        this.operations = operations;
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Insert insert = this.createFullInsert(entity);
        this.operations.execute(insert);
        return entity;
    }

    public <S extends T> List<S> save(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        ArrayList<S> result = new ArrayList<S>();
        Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        for (S entity : entities) {
            result.add(entity);
            batch.add((RegularStatement)this.createFullInsert(entity));
        }
        this.operations.execute(batch);
        return result;
    }

    private <S extends T> Insert createFullInsert(S entity) {
        CassandraConverter converter = this.operations.getConverter();
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)converter.getMappingContext().getPersistentEntity(entity.getClass());
        LinkedHashMap toInsert = new LinkedHashMap();
        converter.write(entity, toInsert, persistentEntity);
        Insert insert = QueryBuilder.insertInto((String)persistentEntity.getTableName().toCql());
        for (Map.Entry entry : toInsert.entrySet()) {
            insert.value((String)entry.getKey(), entry.getValue());
        }
        return insert;
    }

    @Override
    public <S extends T> S insert(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return this.operations.insert(entity);
    }

    public T findOne(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        return this.operations.selectOneById(this.entityInformation.getJavaType(), id);
    }

    public boolean exists(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        return this.operations.exists(this.entityInformation.getJavaType(), id);
    }

    public long count() {
        return this.operations.count(this.entityInformation.getTableName());
    }

    public void delete(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        this.operations.deleteById(this.entityInformation.getJavaType(), id);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null");
        this.delete((T)this.entityInformation.getId(entity));
    }

    public void delete(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        this.operations.delete(CollectionUtils.toList(entities));
    }

    public void deleteAll() {
        this.operations.truncate(this.entityInformation.getTableName());
    }

    public List<T> findAll() {
        return this.operations.selectAll(this.entityInformation.getJavaType());
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        return this.operations.selectBySimpleIds(this.entityInformation.getJavaType(), ids);
    }

    protected List<T> findAll(Select query) {
        return this.operations.select(query, this.entityInformation.getJavaType());
    }
}

