/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.beans.ConstructorProperties;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.CustomConversions;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParametersParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryExecution;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.ConvertingParameterAccessor;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractCassandraQuery
implements RepositoryQuery {
    protected static Logger log = LoggerFactory.getLogger(AbstractCassandraQuery.class);
    private final CassandraOperations template;
    private final CassandraQueryMethod queryMethod;
    private final EntityInstantiators instantiators;

    public AbstractCassandraQuery(CassandraQueryMethod queryMethod, CassandraOperations operations) {
        Assert.notNull((Object)((Object)queryMethod), (String)"CassandraQueryMethod must not be null");
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        this.queryMethod = queryMethod;
        this.template = operations;
        this.instantiators = new EntityInstantiators();
    }

    public CassandraQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    public Object execute(Object[] parameters) {
        ConvertingParameterAccessor parameterAccessor = new ConvertingParameterAccessor(this.template.getConverter(), new CassandraParametersParameterAccessor(this.queryMethod, parameters));
        ResultProcessor resultProcessor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        String query = this.createQuery(parameterAccessor);
        CassandraQueryExecution queryExecution = this.getExecution(query, parameterAccessor, new CassandraQueryExecution.ResultProcessingConverter(resultProcessor, this.template.getConverter().getMappingContext(), this.instantiators));
        CassandraReturnedType returnedType = new CassandraReturnedType(resultProcessor.getReturnedType(), this.template.getConverter().getCustomConversions());
        Class<?> resultType = returnedType.isProjecting() ? returnedType.getDomainType() : returnedType.getReturnedType();
        return queryExecution.execute(query, resultType);
    }

    private CassandraQueryExecution getExecution(String query, CassandraParameterAccessor accessor, Converter<Object, Object> resultProcessing) {
        return new CassandraQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(accessor, resultProcessing), resultProcessing);
    }

    private CassandraQueryExecution getExecutionToWrap(CassandraParameterAccessor accessor, Converter<Object, Object> resultProcessing) {
        if (this.queryMethod.isCollectionQuery()) {
            return new CassandraQueryExecution.CollectionExecution(this.template);
        }
        if (this.queryMethod.isResultSetQuery()) {
            return new CassandraQueryExecution.ResultSetQuery(this.template);
        }
        if (this.queryMethod.isStreamQuery()) {
            return new CassandraQueryExecution.StreamExecution(this.template, resultProcessing);
        }
        return new CassandraQueryExecution.SingleEntityExecution(this.template);
    }

    @Deprecated
    public Object getCollectionOfEntity(ResultSet resultSet, Class<?> declaredReturnType, Class<?> returnedUnwrappedObjectType) {
        AbstractCollection results = ClassUtils.isAssignable(SortedSet.class, declaredReturnType) ? new TreeSet() : (ClassUtils.isAssignable(Set.class, declaredReturnType) ? new HashSet() : new ArrayList());
        CassandraConverter converter = this.template.getConverter();
        for (Row row : resultSet) {
            results.add(converter.read(returnedUnwrappedObjectType, row));
        }
        return results;
    }

    @Deprecated
    public Object getSingleEntity(ResultSet resultSet, Class<?> type) {
        Object result = resultSet.isExhausted() ? null : this.template.getConverter().read(type, resultSet.one());
        this.warnIfMoreResults(resultSet);
        return result;
    }

    private void warnIfMoreResults(ResultSet resultSet) {
        if (log.isWarnEnabled() && !resultSet.isExhausted()) {
            int count = 0;
            while (resultSet.one() != null) {
                ++count;
            }
            log.warn("ignoring extra {} row{}", (Object)count, (Object)(count == 1 ? "" : "s"));
        }
    }

    @Deprecated
    protected void warnIfMoreResults(Iterator<Row> iterator) {
        if (log.isWarnEnabled() && iterator.hasNext()) {
            int count = 0;
            while (iterator.hasNext()) {
                ++count;
                iterator.next();
            }
            log.warn("ignoring extra {} row{}", (Object)count, (Object)(count == 1 ? "" : "s"));
        }
    }

    @Deprecated
    public void setConversionService(ConversionService conversionService) {
        throw new UnsupportedOperationException("setConversionService(ConversionService) is not supported anymore. Please use CassandraMappingContext instead");
    }

    @Deprecated
    public ConversionService getConversionService() {
        return this.template.getConverter().getConversionService();
    }

    protected abstract String createQuery(CassandraParameterAccessor var1);

    private class CassandraReturnedType {
        private final ReturnedType returnedType;
        private final CustomConversions customConversions;

        boolean isProjecting() {
            if (!this.returnedType.isProjecting()) {
                return false;
            }
            if (ClassUtils.isAssignable(Map.class, (Class)this.returnedType.getReturnedType())) {
                return false;
            }
            if (this.customConversions.hasCustomWriteTarget(this.returnedType.getReturnedType())) {
                return false;
            }
            return !this.customConversions.isSimpleType(this.returnedType.getReturnedType());
        }

        Class<?> getDomainType() {
            return this.returnedType.getDomainType();
        }

        Class<?> getReturnedType() {
            return this.returnedType.getReturnedType();
        }

        @ConstructorProperties(value={"returnedType", "customConversions"})
        public CassandraReturnedType(ReturnedType returnedType, CustomConversions customConversions) {
            this.returnedType = returnedType;
            this.customConversions = customConversions;
        }
    }
}

