/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.data.cassandra.core.CassandraBatchOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.util.Assert;

class CassandraBatchTemplate
implements CassandraBatchOperations {
    static final Object[] EMPTY_ARRAY = new Object[0];
    private AtomicBoolean executed = new AtomicBoolean();
    private final Batch batch;
    private final CassandraTemplate cassandraTemplate;

    public CassandraBatchTemplate(CassandraTemplate cassandraTemplate) {
        Assert.notNull((Object)cassandraTemplate, (String)"CassandraTemplate must not be null");
        this.cassandraTemplate = cassandraTemplate;
        this.batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
    }

    @Override
    public void execute() {
        if (this.executed.compareAndSet(false, true)) {
            this.cassandraTemplate.execute(this.batch);
            return;
        }
        this.assertNotExecuted();
    }

    @Override
    public CassandraBatchOperations withTimestamp(long timestamp) {
        this.assertNotExecuted();
        this.batch.using(QueryBuilder.timestamp((long)timestamp));
        return this;
    }

    @Override
    public CassandraBatchOperations insert(Object ... entities) {
        return this.insert(this.nullSafeIterable(entities));
    }

    @Override
    public CassandraBatchOperations insert(Iterable<?> entities) {
        this.assertNotExecuted();
        for (Object entity : this.nullSafeIterable(entities)) {
            Assert.notNull(entity, (String)"Entity must not be null");
            this.batch.add((RegularStatement)this.cassandraTemplate.createInsertQuery(entity, null));
        }
        return this;
    }

    @Override
    public CassandraBatchOperations update(Object ... entities) {
        return this.update(this.nullSafeIterable(entities));
    }

    @Override
    public CassandraBatchOperations update(Iterable<?> entities) {
        this.assertNotExecuted();
        for (Object entity : this.nullSafeIterable(entities)) {
            Assert.notNull(entity, (String)"Entity must not be null");
            this.batch.add((RegularStatement)this.cassandraTemplate.createUpdateQuery(entity, null));
        }
        return this;
    }

    @Override
    public CassandraBatchOperations delete(Object ... entities) {
        return this.delete(this.nullSafeIterable(entities));
    }

    @Override
    public CassandraBatchOperations delete(Iterable<?> entities) {
        this.assertNotExecuted();
        for (Object entity : this.nullSafeIterable(entities)) {
            Assert.notNull(entity, (String)"Entity must not be null");
            this.batch.add((RegularStatement)this.cassandraTemplate.createDeleteQuery(entity, null));
        }
        return this;
    }

    private void assertNotExecuted() {
        Assert.state((!this.executed.get() ? 1 : 0) != 0, (String)"This Cassandra Batch was already executed");
    }

    private <T> Iterable<T> nullSafeIterable(T ... array) {
        return array == null ? Collections.emptyList() : Arrays.asList(array);
    }

    private <T> Iterable<T> nullSafeIterable(Iterable<T> iterable) {
        return iterable != null ? iterable : Collections.emptyList();
    }
}

