/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.CustomConversions;
import org.springframework.data.convert.EntityInstantiators;

public abstract class AbstractCassandraConverter
implements CassandraConverter,
InitializingBean {
    protected final ConversionService conversionService;
    protected CustomConversions conversions = new CustomConversions();
    protected EntityInstantiators instantiators = new EntityInstantiators();

    public AbstractCassandraConverter(ConversionService conversionService) {
        this.conversionService = conversionService == null ? new DefaultConversionService() : conversionService;
    }

    public void setInstantiators(EntityInstantiators instantiators) {
        this.instantiators = instantiators == null ? new EntityInstantiators() : instantiators;
    }

    public void setCustomConversions(CustomConversions conversions) {
        this.conversions = conversions;
    }

    @Override
    public CustomConversions getCustomConversions() {
        return this.conversions;
    }

    public void afterPropertiesSet() {
        this.initializeConverters();
    }

    private void initializeConverters() {
        if (this.conversionService instanceof GenericConversionService) {
            this.conversions.registerConvertersIn((GenericConversionService)this.conversionService);
        }
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }
}

