/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UDTValue;
import org.springframework.data.cassandra.convert.CassandraValueProvider;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.util.Assert;

public class CassandraUDTValueProvider
implements CassandraValueProvider {
    private final UDTValue udtValue;
    private final CodecRegistry codecRegistry;
    private final SpELExpressionEvaluator evaluator;

    public CassandraUDTValueProvider(UDTValue udtValue, CodecRegistry codecRegistry, DefaultSpELExpressionEvaluator evaluator) {
        Assert.notNull((Object)udtValue, (String)"UDTValue must not be null");
        Assert.notNull((Object)codecRegistry, (String)"CodecRegistry must not be null");
        Assert.notNull((Object)evaluator, (String)"SpELExpressionEvaluator must not be null");
        this.udtValue = udtValue;
        this.codecRegistry = codecRegistry;
        this.evaluator = evaluator;
    }

    public Object getPropertyValue(CassandraPersistentProperty property) {
        String expression = property.getSpelExpression();
        if (expression != null) {
            return this.evaluator.evaluate(expression);
        }
        String name = property.getColumnName().toCql();
        DataType fieldType = this.udtValue.getType().getFieldType(name);
        return this.udtValue.get(name, this.codecRegistry.codecFor(fieldType));
    }

    @Override
    public boolean hasProperty(CassandraPersistentProperty property) {
        return this.udtValue.getType().contains(property.getColumnName().toCql());
    }
}

