/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import com.datastax.driver.core.UserType;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.UserDefinedType;
import org.springframework.data.cassandra.mapping.UserTypeResolver;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class CassandraUserTypePersistentEntity<T>
extends BasicCassandraPersistentEntity<T> {
    private final UserTypeResolver resolver;
    private final Object lock = new Object();
    private volatile UserType userType;

    public CassandraUserTypePersistentEntity(TypeInformation<T> typeInformation, CassandraMappingContext mappingContext, CassandraPersistentEntityMetadataVerifier verifier, UserTypeResolver resolver) {
        super(typeInformation, mappingContext, verifier);
        Assert.notNull((Object)resolver, (String)"UserTypeResolver must not be null");
        this.resolver = resolver;
    }

    @Override
    protected CqlIdentifier determineTableName() {
        UserDefinedType typeAnnotation = (UserDefinedType)this.findAnnotation(UserDefinedType.class);
        return this.determineName(typeAnnotation.value(), typeAnnotation.forceQuote());
    }

    @Override
    public boolean isUserDefinedType() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserType getUserType() {
        if (this.userType == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.userType == null) {
                    CqlIdentifier identifier = this.determineTableName();
                    UserType userType = this.resolver.resolveType(identifier);
                    if (userType == null) {
                        throw new MappingException(String.format("User type [%s] not found", identifier));
                    }
                    this.userType = userType;
                }
            }
        }
        return this.userType;
    }
}

