/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.PrimaryKey;
import org.springframework.data.cassandra.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.mapping.Table;
import org.springframework.data.cassandra.mapping.VerifierMappingExceptions;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.MappingException;

public class PrimaryKeyClassEntityMetadataVerifier
implements CassandraPersistentEntityMetadataVerifier {
    @Override
    public void verify(CassandraPersistentEntity<?> entity) throws MappingException {
        if (entity.getType().isInterface() || !entity.isCompositePrimaryKey()) {
            return;
        }
        ArrayList<MappingException> exceptions = new ArrayList<MappingException>();
        final ArrayList idProperties = new ArrayList();
        final ArrayList compositePrimaryKeys = new ArrayList();
        final ArrayList partitionKeyColumns = new ArrayList();
        final ArrayList primaryKeyColumns = new ArrayList();
        Class entityType = entity.getType();
        if (entity.findAnnotation(Table.class) != null) {
            exceptions.add(new MappingException(String.format("Entity cannot be of type @%s and @%s", Table.class.getSimpleName(), PrimaryKeyClass.class.getSimpleName())));
        }
        if (!entityType.getSuperclass().equals(Object.class)) {
            exceptions.add(new MappingException(String.format("@%s must only extend Object", PrimaryKeyClass.class.getSimpleName())));
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                if (property.isCompositePrimaryKey()) {
                    compositePrimaryKeys.add(property);
                } else if (property.isIdProperty()) {
                    idProperties.add(property);
                } else if (property.isClusterKeyColumn()) {
                    primaryKeyColumns.add(property);
                } else if (property.isPartitionKeyColumn()) {
                    partitionKeyColumns.add(property);
                    primaryKeyColumns.add(property);
                }
            }
        });
        if (!compositePrimaryKeys.isEmpty()) {
            exceptions.add(new MappingException("Composite primary keys are not allowed inside of composite primary key classes"));
        }
        if (primaryKeyColumns.isEmpty()) {
            exceptions.add(new MappingException(String.format("Composite primary key type [%1$s] has no fields annotated with @%2$s", entity.getType().getName(), PrimaryKeyColumn.class.getSimpleName())));
        }
        if (partitionKeyColumns.isEmpty()) {
            exceptions.add(new MappingException(String.format("At least one of the @%s annotations must have a type of PARTITIONED", PrimaryKeyColumn.class.getSimpleName())));
        }
        if (!idProperties.isEmpty()) {
            exceptions.add(new MappingException(String.format("Annotations @%1$s and @%2$s are invalid for type annotated with @%3$s", Id.class.getSimpleName(), PrimaryKey.class.getSimpleName(), PrimaryKeyClass.class.getSimpleName())));
        }
        if (!exceptions.isEmpty()) {
            PrimaryKeyClassEntityMetadataVerifier.fail(entity, exceptions);
        }
    }

    private static void fail(CassandraPersistentEntity<?> entity, List<MappingException> exceptions) {
        throw new VerifierMappingExceptions(entity, exceptions);
    }
}

